/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.graph.Graph;
import org.esa.beam.framework.gpf.graph.GraphException;
import org.esa.beam.framework.gpf.graph.GraphIO;
import org.esa.beam.framework.gpf.graph.GraphProcessor;
import org.esa.beam.framework.gpf.graph.Node;
import org.esa.beam.gpf.operators.standard.ReadOp;
import org.esa.beam.gpf.operators.standard.WriteOp;
import org.esa.nest.util.FileIOUtils;

public class GPFProcessor {
    private final Graph graph;
    private final GraphProcessor processor = new GraphProcessor();

    public GPFProcessor(File graphFile) throws GraphException, IOException {
        this(graphFile, null);
    }

    public GPFProcessor(File graphFile, Map<String, String> parameterMap) throws GraphException, IOException {
        this.graph = GPFProcessor.readGraph(graphFile, parameterMap);
    }

    public static Graph readGraph(File graphFile, Map<String, String> parameterMap) throws GraphException, IOException {
        try {
            return GPFProcessor.readInGraph(graphFile, parameterMap);
        }
        catch (Exception e) {
            FileIOUtils.replaceText((File)graphFile, (File)graphFile, (String)"Xpp3DomElement", (String)"XppDomElement");
            return GPFProcessor.readInGraph(graphFile, parameterMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Graph readInGraph(File graphFile, Map<String, String> parameterMap) throws GraphException, IOException {
        Graph graph = null;
        try (FileReader fileReader = new FileReader(graphFile);){
            graph = GraphIO.read((Reader)fileReader, parameterMap);
        }
        return graph;
    }

    public void setIO(File srcFile, File tgtFile, String format) {
        String writeOperatorAlias;
        Node writerNode;
        String readOperatorAlias = OperatorSpi.getOperatorAlias(ReadOp.class);
        Node readerNode = GPFProcessor.findNode(this.graph, readOperatorAlias);
        if (readerNode != null) {
            DefaultDomElement param = new DefaultDomElement("parameters");
            param.createChild("file").setValue(srcFile.getAbsolutePath());
            readerNode.setConfiguration((DomElement)param);
        }
        if ((writerNode = GPFProcessor.findNode(this.graph, writeOperatorAlias = OperatorSpi.getOperatorAlias(WriteOp.class))) != null && tgtFile != null) {
            DomElement origParam = writerNode.getConfiguration();
            ((DomElement)origParam.getChild("file")).setValue(tgtFile.getAbsolutePath());
            if (format != null) {
                ((DomElement)origParam.getChild("formatName")).setValue(format);
            }
        }
    }

    public void executeGraph(ProgressMonitor pm) throws GraphException {
        this.processor.executeGraph(this.graph, pm);
    }

    private static Node findNode(Graph graph, String alias) {
        for (Node n : graph.getNodes()) {
            if (!n.getOperatorName().equals(alias)) continue;
            return n;
        }
        return null;
    }
}

