/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.beam.framework.gpf.ui.BaseOperatorUI;
import org.esa.beam.framework.gpf.ui.UIValidation;
import org.esa.beam.framework.ui.AppContext;
import org.esa.nest.dat.dialogs.FileTable;
import org.esa.nest.dat.dialogs.ProductSetPanel;

public class ProductSetReaderOpUI
extends BaseOperatorUI {
    private final FileTable productSetTable = new FileTable();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JPanel comp = ProductSetPanel.createComponent(this.productSetTable, true);
        this.initParameters();
        return comp;
    }

    public void initParameters() {
        this.convertFromDOM();
        String[] fList = (String[])this.paramMap.get("fileList");
        this.productSetTable.setFiles(fList);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        File[] fileList = this.productSetTable.getFileList();
        if (fileList.length == 0) {
            return;
        }
        String[] fList = new String[fileList.length];
        for (int i = 0; i < fileList.length; ++i) {
            fList[i] = fileList[i].getName().isEmpty() ? "" : fileList[i].getAbsolutePath();
        }
        this.paramMap.put("fileList", fList);
    }

    public void setProductFileList(File[] productFileList) {
        this.productSetTable.setFiles(productFileList);
    }
}

