/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.beam.dataio.dimap.DimapProductWriter;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.framework.gpf.experimental.Output;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.nest.gpf.TileWriterUI;

@OperatorMetadata(alias="TileWriter", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2013 by Array Systems Computing Inc.", description="Writes a data product to a tiles.", category="Utilities")
public class TileWriterOp
extends Operator
implements Output {
    @TargetProduct
    private Product targetProduct;
    @SourceProduct(alias="source", description="The source product to be written.")
    private Product sourceProduct;
    @Parameter(description="The output file to which the data product is written.")
    private File file;
    @Parameter(defaultValue="BEAM-DIMAP", description="The name of the output file format.")
    private String formatName;
    @Parameter(defaultValue="4", valueSet={"2", "4", "9", "16", "36", "64", "100", "256"}, description="The number of output tiles")
    private String numberOfTiles = "4";
    private final Map<MultiLevelImage, List<Point>> todoLists = new HashMap<MultiLevelImage, List<Point>>();
    private boolean productFileWritten;
    private Dimension tileSize;
    private int tileCountX;
    private SubsetInfo[] subsetInfo = null;

    public TileWriterOp() {
        this.setRequiresAllBands(true);
    }

    public void initialize() throws OperatorException {
        try {
            this.targetProduct = this.sourceProduct;
            this.tileSize = ImageManager.getPreferredTileSize((Product)this.targetProduct);
            this.targetProduct.setPreferredTileSize(this.tileSize);
            this.tileCountX = MathUtils.ceilInt((double)((double)this.targetProduct.getSceneRasterWidth() / (double)this.tileSize.width));
            int numFiles = Integer.parseInt(this.numberOfTiles);
            int numRows = (int)Math.sqrt(numFiles);
            int width = this.sourceProduct.getSceneRasterWidth() / numRows;
            int height = this.sourceProduct.getSceneRasterHeight() / numRows;
            this.subsetInfo = new SubsetInfo[numFiles];
            int n = 0;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numRows; ++j) {
                    Band[] bands;
                    ProductSubsetDef subsetDef = new ProductSubsetDef();
                    subsetDef.addNodeNames(this.sourceProduct.getTiePointGridNames());
                    subsetDef.addNodeNames(this.sourceProduct.getBandNames());
                    subsetDef.setRegion(i * width, j * height, width, height);
                    subsetDef.setSubSampling(1, 1);
                    subsetDef.setIgnoreMetadata(false);
                    this.subsetInfo[n] = new SubsetInfo();
                    this.subsetInfo[n].subsetBuilder = new ProductSubsetBuilder();
                    this.subsetInfo[n].product = this.subsetInfo[n].subsetBuilder.readProductNodes((Object)this.sourceProduct, subsetDef);
                    this.subsetInfo[n].file = new File(this.file.getParentFile(), TileWriterOp.createName(this.file, n + 1));
                    this.subsetInfo[n].productWriter = ProductIO.getProductWriter((String)this.formatName);
                    if (this.subsetInfo[n].productWriter == null) {
                        throw new OperatorException("No data product writer for the '" + this.formatName + "' format available");
                    }
                    this.subsetInfo[n].productWriter.setIncrementalMode(false);
                    this.subsetInfo[n].productWriter.setFormatName(this.formatName);
                    this.subsetInfo[n].product.setProductWriter(this.subsetInfo[n].productWriter);
                    for (Band b : bands = this.subsetInfo[n].product.getBands()) {
                    }
                    ++n;
                }
            }
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private static String createName(File file, int n) {
        return FileUtils.getFilenameWithoutExtension((File)file) + '_' + n + FileUtils.getExtension((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            TileWriterOp tileWriterOp = this;
            synchronized (tileWriterOp) {
                if (!this.productFileWritten) {
                    for (SubsetInfo info : this.subsetInfo) {
                        info.productWriter.writeProductNodes(info.product, (Object)info.file);
                    }
                    this.productFileWritten = true;
                }
            }
            Rectangle rect = targetTile.getRectangle();
            for (SubsetInfo info : this.subsetInfo) {
                Rectangle trgRect = info.subsetBuilder.getSubsetDef().getRegion();
                if (info.written || !rect.intersects(trgRect)) continue;
                this.writeTile(info, targetBand.getName(), trgRect);
            }
            this.markTileDone(targetBand, targetTile);
        }
        catch (Exception e) {
            if (e instanceof OperatorException) {
                throw (OperatorException)e;
            }
            throw new OperatorException((Throwable)e);
        }
    }

    private synchronized void writeTile(SubsetInfo info, String bandName, Rectangle trgRect) throws IOException {
        if (info.written) {
            return;
        }
        Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(bandName), trgRect);
        ProductData rawSamples = sourceTile.getRawSamples();
        Band trgBand = info.product.getBand(bandName);
        info.productWriter.writeBandRasterData(trgBand, 0, 0, trgBand.getSceneRasterWidth(), trgBand.getSceneRasterHeight(), rawSamples, ProgressMonitor.NULL);
        info.written = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markTileDone(Band targetBand, Tile targetTile) throws IOException {
        boolean done;
        Map<MultiLevelImage, List<Point>> map = this.todoLists;
        synchronized (map) {
            MultiLevelImage sourceImage = targetBand.getSourceImage();
            List<Point> currentTodoList = this.getTodoList(sourceImage);
            currentTodoList.remove(new Point(sourceImage.XToTileX(targetTile.getMinX()), sourceImage.YToTileY(targetTile.getMinY())));
            done = this.isDone();
        }
        if (done) {
            for (SubsetInfo info : this.subsetInfo) {
                if (!(info.productWriter instanceof DimapProductWriter)) continue;
                ProductWriter productWriter = info.productWriter;
                synchronized (productWriter) {
                    info.productWriter.writeProductNodes(info.product, (Object)info.file);
                }
            }
        }
    }

    private boolean isDone() {
        for (List<Point> todoList : this.todoLists.values()) {
            if (todoList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<Point> getTodoList(MultiLevelImage sourceImage) {
        List<Point> todoList = this.todoLists.get(sourceImage);
        if (todoList == null) {
            int numXTiles = sourceImage.getNumXTiles();
            int numYTiles = sourceImage.getNumYTiles();
            todoList = new ArrayList<Point>(numXTiles * numYTiles);
            for (int y = 0; y < numYTiles; ++y) {
                for (int x = 0; x < numXTiles; ++x) {
                    todoList.add(new Point(x, y));
                }
            }
            this.todoLists.put(sourceImage, todoList);
        }
        return todoList;
    }

    public void dispose() {
        try {
            for (SubsetInfo info : this.subsetInfo) {
                info.productWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.todoLists.clear();
        super.dispose();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TileWriterOp.class);
            this.setOperatorUI(TileWriterUI.class);
        }
    }

    private static class SubsetInfo {
        Product product;
        ProductSubsetBuilder subsetBuilder;
        File file;
        ProductWriter productWriter;
        boolean written = false;

        private SubsetInfo() {
        }
    }
}

