/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.beam.framework.gpf.ui.BaseOperatorUI;
import org.esa.beam.framework.gpf.ui.TargetProductSelector;
import org.esa.beam.framework.gpf.ui.UIValidation;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.util.SystemUtils;

public class TileWriterUI
extends BaseOperatorUI {
    private final JComboBox numberOfTiles = new JComboBox<String>(new String[]{"2", "4", "9", "16", "36", "64", "100", "256"});
    TargetProductSelector targetProductSelector = null;
    private static final String FILE_PARAMETER = "file";
    private AppContext appContext;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.paramMap = parameterMap;
        this.targetProductSelector = new TargetProductSelector();
        this.appContext = appContext;
        File saveDir = null;
        Object value = this.paramMap.get(FILE_PARAMETER);
        if (value != null) {
            File file = (File)value;
            saveDir = file.getParentFile();
        }
        if (saveDir == null) {
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String savePath = appContext.getPreferences().getPropertyString("app.file.lastSaveDir", homeDirPath);
            saveDir = new File(savePath);
        }
        this.targetProductSelector.getModel().setProductDir(saveDir);
        this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + appContext.getApplicationName());
        this.initParameters();
        return this.createPanel();
    }

    public JPanel createPanel() {
        JPanel subPanel1 = new JPanel(new BorderLayout(3, 3));
        subPanel1.add((Component)this.targetProductSelector.getProductNameLabel(), "North");
        subPanel1.add((Component)this.targetProductSelector.getProductNameTextField(), "Center");
        JPanel subPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        subPanel2.add(this.targetProductSelector.getSaveToFileCheckBox());
        subPanel2.add(this.targetProductSelector.getFormatNameComboBox());
        JPanel subPanel3 = new JPanel(new BorderLayout(3, 3));
        subPanel3.add((Component)this.targetProductSelector.getProductDirLabel(), "North");
        subPanel3.add((Component)this.targetProductSelector.getProductDirTextField(), "Center");
        subPanel3.add((Component)this.targetProductSelector.getProductDirChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(1.0);
        tableLayout.setCellPadding(0, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(1, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(2, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(3, 0, new Insets(3, 3, 3, 3));
        tableLayout.setCellPadding(4, 0, new Insets(0, 24, 3, 3));
        tableLayout.setCellPadding(5, 0, new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.setBorder(BorderFactory.createTitledBorder("Target Tile Products"));
        panel.add(new JLabel("Number of Tiles:"));
        panel.add(this.numberOfTiles);
        panel.add(subPanel1);
        panel.add(subPanel2);
        panel.add(subPanel3);
        panel.add(this.targetProductSelector.getOpenInAppCheckBox());
        return panel;
    }

    public void initParameters() {
        assert (this.paramMap != null);
        String fileName = "target";
        Object value = this.paramMap.get(FILE_PARAMETER);
        if (value != null) {
            File file = (File)value;
            fileName = file.getName();
        } else if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            fileName = this.sourceProducts[0].getName();
        }
        this.targetProductSelector.getProductNameTextField().setText(fileName);
        this.targetProductSelector.getModel().setProductName(fileName);
        String numTiles = (String)this.paramMap.get("numberOfTiles");
        if (numTiles == null || numTiles.isEmpty()) {
            numTiles = "4";
        }
        this.numberOfTiles.setSelectedItem(numTiles);
    }

    public UIValidation validateParameters() {
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        this.appContext.getPreferences().setPropertyString("app.file.lastSaveDir", productDir);
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (this.targetProductSelector.getModel().getProductName() != null) {
            this.paramMap.put(FILE_PARAMETER, this.targetProductSelector.getModel().getProductFile());
            this.paramMap.put("formatName", this.targetProductSelector.getModel().getFormatName());
            this.paramMap.put("numberOfTiles", this.numberOfTiles.getSelectedItem());
        }
    }
}

