/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationTile;

public abstract class BaseElevationModel
implements ElevationModel,
Resampling.Raster {
    private final int NUM_X_TILES;
    protected final int NUM_Y_TILES;
    protected final int NUM_PIXELS_PER_TILE;
    private final double NUM_PIXELS_PER_TILEinv;
    private final float NO_DATA_VALUE;
    protected final int DEGREE_RES;
    private final int RASTER_WIDTH;
    protected final int RASTER_HEIGHT;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    protected final ElevationModelDescriptor descriptor;
    private final ElevationFile[][] elevationFiles;
    private final Resampling resampling;
    private final Resampling.Raster resamplingRaster;
    private final List<ElevationTile> elevationTileCache = new ArrayList<ElevationTile>(20);
    private int maxCacheSize = 60;

    public BaseElevationModel(ElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        this.descriptor = descriptor;
        if (resamplingMethod == null) {
            resamplingMethod = Resampling.BILINEAR_INTERPOLATION;
        }
        this.resampling = resamplingMethod;
        this.resamplingRaster = this;
        this.NUM_X_TILES = descriptor.getNumXTiles();
        this.NUM_Y_TILES = descriptor.getNumYTiles();
        this.NO_DATA_VALUE = descriptor.getNoDataValue();
        this.NUM_PIXELS_PER_TILE = descriptor.getPixelRes();
        this.NUM_PIXELS_PER_TILEinv = 1.0 / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES = descriptor.getDegreeRes();
        this.RASTER_WIDTH = this.NUM_X_TILES * this.NUM_PIXELS_PER_TILE;
        this.RASTER_HEIGHT = this.NUM_Y_TILES * this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE = (double)this.DEGREE_RES / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv = 1.0 / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
        this.elevationFiles = this.createElevationFiles();
    }

    @Override
    public Resampling getResampling() {
        return this.resampling;
    }

    @Override
    public ElevationModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setMaxCacheSize(int size) {
        this.maxCacheSize = size;
    }

    @Override
    public final double getElevation(GeoPos geoPos) throws Exception {
        double pixelY;
        if (geoPos.lon > 180.0f) {
            geoPos.lon -= 360.0f;
        }
        if ((pixelY = this.getIndexY(geoPos)) < 0.0) {
            return this.NO_DATA_VALUE;
        }
        Resampling.Index newIndex = this.resampling.createIndex();
        this.resampling.computeIndex(this.getIndexX(geoPos), pixelY, this.RASTER_WIDTH, this.RASTER_HEIGHT, newIndex);
        double elevation = this.resampling.resample(this.resamplingRaster, newIndex);
        return Double.isNaN(elevation) ? (double)this.NO_DATA_VALUE : elevation;
    }

    public abstract double getIndexX(GeoPos var1);

    public abstract double getIndexY(GeoPos var1);

    @Override
    public abstract GeoPos getGeoPos(PixelPos var1);

    @Override
    public PixelPos getIndex(GeoPos geoPos) {
        return new PixelPos((float)this.getIndexX(geoPos), (float)this.getIndexY(geoPos));
    }

    @Override
    public void dispose() {
        for (ElevationTile tile : this.elevationTileCache) {
            if (tile == null) continue;
            tile.dispose();
        }
        this.elevationTileCache.clear();
        ElevationFile[][] elevationFileArray = this.elevationFiles;
        int n = elevationFileArray.length;
        for (int i = 0; i < n; ++i) {
            ElevationFile[] elevationFile;
            for (ElevationFile anElevationFile : elevationFile = elevationFileArray[i]) {
                if (anElevationFile == null) continue;
                anElevationFile.dispose();
            }
        }
    }

    public int getWidth() {
        return this.RASTER_WIDTH;
    }

    public int getHeight() {
        return this.RASTER_HEIGHT;
    }

    @Override
    public final float getSample(double pixelX, double pixelY) throws Exception {
        int tileXIndex = (int)(pixelX * this.NUM_PIXELS_PER_TILEinv);
        int tileYIndex = (int)(pixelY * this.NUM_PIXELS_PER_TILEinv);
        ElevationTile tile = this.elevationFiles[tileXIndex][tileYIndex].getTile();
        if (tile == null) {
            return Float.NaN;
        }
        float sample = tile.getSample((int)(pixelX - (double)(tileXIndex * this.NUM_PIXELS_PER_TILE)), (int)(pixelY - (double)(tileYIndex * this.NUM_PIXELS_PER_TILE)));
        return sample == this.NO_DATA_VALUE ? Float.NaN : sample;
    }

    private ElevationFile[][] createElevationFiles() {
        ElevationFile[][] elevationFiles = new ElevationFile[this.NUM_X_TILES][this.NUM_Y_TILES];
        File demInstallDir = this.descriptor.getDemInstallDir();
        for (int x = 0; x < elevationFiles.length; ++x) {
            for (int y = 0; y < elevationFiles[x].length; ++y) {
                this.createElevationFile(elevationFiles, x, y, demInstallDir);
            }
        }
        return elevationFiles;
    }

    protected abstract void createElevationFile(ElevationFile[][] var1, int var2, int var3, File var4);

    public void updateCache(ElevationTile tile) {
        this.elevationTileCache.remove(tile);
        this.elevationTileCache.add(0, tile);
        while (this.elevationTileCache.size() > this.maxCacheSize) {
            int index = this.elevationTileCache.size() - 1;
            ElevationTile lastTile = this.elevationTileCache.get(index);
            if (lastTile != null) {
                lastTile.clearCache();
            }
            this.elevationTileCache.remove(index);
        }
    }

    protected static ProductReaderPlugIn getReaderPlugIn(String formatName) {
        Iterator readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(formatName);
        return (ProductReaderPlugIn)readerPlugIns.next();
    }

    @Override
    public final boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            int tileYIndex = (int)((double)y[i] * this.NUM_PIXELS_PER_TILEinv);
            int pixelY = y[i] - tileYIndex * this.NUM_PIXELS_PER_TILE;
            for (int j = 0; j < x.length; ++j) {
                int tileXIndex = (int)((double)x[j] * this.NUM_PIXELS_PER_TILEinv);
                ElevationTile tile = this.elevationFiles[tileXIndex][tileYIndex].getTile();
                if (tile == null) {
                    samples[i][j] = Double.NaN;
                    allValid = false;
                    continue;
                }
                samples[i][j] = tile.getSample(x[j] - tileXIndex * this.NUM_PIXELS_PER_TILE, pixelY);
                if (samples[i][j] != (double)this.NO_DATA_VALUE) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }
}

