/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import com.bc.ceres.core.ProgressMonitor;
import java.util.Arrays;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationTile;

public class BaseElevationTile
implements ElevationTile {
    protected Product product;
    private final Band band;
    private final int bandWidth;
    protected final float noDataValue;
    private final float[][] objectArray;
    private final boolean useDEMGravitationalModel;

    public BaseElevationTile(ElevationModel dem, Product product) {
        this.product = product;
        this.band = product.getBandAt(0);
        this.bandWidth = this.band.getSceneRasterWidth();
        this.noDataValue = dem.getDescriptor().getNoDataValue();
        this.objectArray = new float[this.band.getSceneRasterHeight() + 1][];
        String prop = System.getProperty("useDEMGravitationalModel");
        this.useDEMGravitationalModel = prop != null && prop.equalsIgnoreCase("true");
    }

    @Override
    public final void clearCache() {
        if (this.objectArray != null) {
            Arrays.fill((Object[])this.objectArray, 0, this.objectArray.length, null);
        }
    }

    @Override
    public final float getSample(int pixelX, int pixelY) throws Exception {
        float[] line = this.objectArray[pixelY];
        if (line == null) {
            line = this.band.readPixels(0, pixelY, this.bandWidth, 1, new float[this.bandWidth], ProgressMonitor.NULL);
            if (this.useDEMGravitationalModel) {
                this.addGravitationalModel(pixelY, line);
            }
            this.objectArray[pixelY] = line;
        }
        return line[pixelX];
    }

    @Override
    public void dispose() {
        this.clearCache();
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }

    protected void addGravitationalModel(int index, float[] line) {
    }
}

