/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import java.util.Arrays;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.EarthGravitationalModel96;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModelRegistry;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.TileGeoreferencing;
import org.jlinda.core.Orbit;
import org.jlinda.core.Point;
import org.jlinda.core.SLCImage;
import org.jlinda.core.Window;
import org.jlinda.core.utils.TriangleUtils;

public class DEMFactory {
    private static final String AUTODEM = " (Auto Download)";
    static final String DELAUNAY_INTERPOLATION = "DELAUNAY_INTERPOLATION";
    private static final ElevationModelDescriptor[] descriptors;
    private static final String[] demNameList;
    private static final String[] demResamplingList;

    public static String[] getDEMNameList() {
        return demNameList;
    }

    public static String[] getDEMResamplingMethods() {
        return demResamplingList;
    }

    public static String getProperDEMName(String name) {
        return name.replace(AUTODEM, "");
    }

    public static ElevationModel createElevationModel(String demName, String demResamplingMethod) {
        ElevationModel dem;
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(demName);
        if (demDescriptor == null) {
            throw new OperatorException("The DEM '" + demName + "' is not supported.");
        }
        if (demDescriptor.isInstallingDem()) {
            throw new OperatorException("The DEM '" + demName + "' is currently being installed.");
        }
        Resampling resampleMethod = null;
        if (!demResamplingMethod.equals(DELAUNAY_INTERPOLATION)) {
            resampleMethod = ResamplingFactory.createResampling((String)demResamplingMethod);
        }
        if ((dem = demDescriptor.createDem(resampleMethod)) == null) {
            throw new OperatorException("The DEM '" + demName + "' has not been installed.");
        }
        return dem;
    }

    public static void checkIfDEMInstalled(String demName) {
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(demName);
        if (demDescriptor == null) {
            throw new OperatorException("The DEM '" + demName + "' is not supported.");
        }
        if (!(demDescriptor.isInstallingDem() || demDescriptor.isDemInstalled() || demDescriptor.installDemFiles(VisatApp.getApp()))) {
            throw new OperatorException("DEM " + demName + " must be installed first");
        }
    }

    public static void validateDEM(String demName, Product srcProduct) {
        if (demName.contains("SRTM")) {
            GeoCoding geocoding = srcProduct.getGeoCoding();
            int w = srcProduct.getSceneRasterWidth();
            int h = srcProduct.getSceneRasterHeight();
            GeoPos geo1 = geocoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
            GeoPos geo2 = geocoding.getGeoPos(new PixelPos((float)w, 0.0f), null);
            GeoPos geo3 = geocoding.getGeoPos(new PixelPos((float)w, (float)h), null);
            GeoPos geo4 = geocoding.getGeoPos(new PixelPos(0.0f, (float)h), null);
            if (geo1.getLat() > 60.0f && geo2.getLat() > 60.0f && geo3.getLat() > 60.0f && geo4.getLat() > 60.0f || geo1.getLat() < -60.0f && geo2.getLat() < -60.0f && geo3.getLat() < -60.0f && geo4.getLat() < -60.0f) {
                throw new OperatorException("Entire image is outside of SRTM valid area.\nPlease use another DEM.");
            }
        }
    }

    public static void fillDEM(double[][] localDEM, float alt) {
        for (double[] row : localDEM) {
            Arrays.fill(row, (double)alt);
        }
    }

    public static String appendAutoDEM(String demName) {
        if (demName.equals("GETASSE30") || demName.equals("SRTM 3Sec") || demName.equals("ACE2_5Min") || demName.equals("ACE30")) {
            demName = demName + AUTODEM;
        }
        return demName;
    }

    public static boolean getLocalDEM(ElevationModel dem, float demNoDataValue, String demResamplingMethod, TileGeoreferencing tileGeoRef, int x0, int y0, int tileWidth, int tileHeight, Product sourceProduct, boolean nodataValueAtSea, double[][] localDEM) throws Exception {
        if (demResamplingMethod != null && demResamplingMethod.equals(DELAUNAY_INTERPOLATION)) {
            return DEMFactory.getLocalDEMUsingDelaunayInterpolation(dem, demNoDataValue, tileGeoRef, x0, y0, tileWidth, tileHeight, sourceProduct, localDEM);
        }
        int maxY = y0 + tileHeight + 1;
        int maxX = x0 + tileWidth + 1;
        GeoPos geoPos = new GeoPos();
        boolean valid = false;
        for (int y = y0 - 1; y < maxY; ++y) {
            int yy = y - y0 + 1;
            for (int x = x0 - 1; x < maxX; ++x) {
                tileGeoRef.getGeoPos(x, y, geoPos);
                double alt = dem.getElevation(geoPos);
                if (alt == (double)demNoDataValue && !nodataValueAtSea) {
                    alt = EarthGravitationalModel96.instance().getEGM(geoPos.lat, geoPos.lon);
                }
                if (!valid && alt != (double)demNoDataValue) {
                    valid = true;
                }
                localDEM[yy][x - x0 + 1] = alt;
            }
        }
        return valid;
    }

    public static synchronized boolean getLocalDEMUsingDelaunayInterpolation(ElevationModel dem, float demNoDataValue, TileGeoreferencing tileGeoRef, int x0, int y0, int tileWidth, int tileHeight, Product sourceProduct, double[][] localDEM) throws Exception {
        int maxY = y0 + tileHeight + 1;
        int maxX = x0 + tileWidth + 1;
        PixelPos pixelPos = new PixelPos();
        Window tileWindow = new Window((long)(y0 - 1), (long)(y0 + tileHeight), (long)(x0 - 1), (long)(x0 + tileWidth));
        GeoPos tgtUL = new GeoPos();
        GeoPos tgtUR = new GeoPos();
        GeoPos tgtLL = new GeoPos();
        GeoPos tgtLR = new GeoPos();
        tileGeoRef.getGeoPos(x0 - 1, y0 - 1, tgtUL);
        tileGeoRef.getGeoPos(x0 + tileWidth, y0 - 1, tgtUR);
        tileGeoRef.getGeoPos(x0 - 1, y0 + tileHeight, tgtLL);
        tileGeoRef.getGeoPos(x0 + tileWidth, y0 + tileHeight, tgtLR);
        double latMin = Math.min(Math.min(Math.min(tgtUL.lat, tgtUR.lat), tgtLL.lat), tgtLR.lat);
        double latMax = Math.max(Math.max(Math.max(tgtUL.lat, tgtUR.lat), tgtLL.lat), tgtLR.lat);
        double lonMin = Math.min(Math.min(Math.min(tgtUL.lon, tgtUR.lon), tgtLL.lon), tgtLR.lon);
        double lonMax = Math.max(Math.max(Math.max(tgtUL.lon, tgtUR.lon), tgtLL.lon), tgtLR.lon);
        GeoPos upperLeftCorner = new GeoPos((float)latMax, (float)lonMin);
        GeoPos lowerRightCorner = new GeoPos((float)latMin, (float)lonMax);
        GeoPos[] geoCorners = new GeoPos[]{upperLeftCorner, lowerRightCorner};
        GeoPos geoExtent = new GeoPos((float)(0.25 * (latMax - latMin)), (float)(0.25 * (lonMax - lonMin)));
        geoCorners[0].lat += geoExtent.lat;
        geoCorners[0].lon -= geoExtent.lon;
        geoCorners[1].lat -= geoExtent.lat;
        geoCorners[1].lon += geoExtent.lon;
        if (geoCorners[0].lon > 180.0f) {
            geoCorners[0].lon -= 360.0f;
        }
        if (geoCorners[1].lon > 180.0f) {
            geoCorners[1].lon -= 360.0f;
        }
        boolean crossMeridian = false;
        if (geoCorners[0].lon > 0.0f && geoCorners[1].lon < 0.0f) {
            crossMeridian = true;
        }
        PixelPos upperLeftCornerPos = dem.getIndex(geoCorners[0]);
        PixelPos lowerRightCornerPos = dem.getIndex(geoCorners[1]);
        upperLeftCornerPos = new PixelPos((float)Math.floor(upperLeftCornerPos.x), (float)Math.floor(upperLeftCornerPos.y));
        lowerRightCornerPos = new PixelPos((float)Math.ceil(lowerRightCornerPos.x), (float)Math.ceil(lowerRightCornerPos.y));
        double[][] x_in = null;
        double[][] y_in = null;
        double[][] z_in = null;
        int nLatPixels = (int)Math.abs(lowerRightCornerPos.y - upperLeftCornerPos.y);
        PixelPos pos = new PixelPos();
        if (!crossMeridian) {
            int nLonPixels = (int)Math.abs(lowerRightCornerPos.x - upperLeftCornerPos.x);
            x_in = new double[nLatPixels][nLonPixels];
            y_in = new double[nLatPixels][nLonPixels];
            z_in = new double[nLatPixels][nLonPixels];
            int startX = (int)upperLeftCornerPos.x;
            int endX = startX + nLonPixels;
            int startY = (int)upperLeftCornerPos.y;
            int endY = startY + nLatPixels;
            int y = startY;
            int i = 0;
            while (y < endY) {
                int x = startX;
                int j = 0;
                while (x < endX) {
                    pos.setLocation((float)x + 0.5f, (float)y + 0.5f);
                    tileGeoRef.getPixelPos(dem.getGeoPos(pos), pixelPos);
                    x_in[i][j] = pixelPos.x;
                    y_in[i][j] = pixelPos.y;
                    try {
                        float elev = dem.getSample(x, y);
                        if (Float.isNaN(elev)) {
                            elev = demNoDataValue;
                        }
                        z_in[i][j] = elev;
                    }
                    catch (Exception e) {
                        z_in[i][j] = demNoDataValue;
                    }
                    ++x;
                    ++j;
                }
                ++y;
                ++i;
            }
        } else {
            int j;
            int x;
            PixelPos endPixelPos = dem.getIndex(new GeoPos(geoCorners[0].lat, 180.0f));
            int nLonPixels = (int)(Math.abs(upperLeftCornerPos.x - endPixelPos.x) + lowerRightCornerPos.x);
            x_in = new double[nLatPixels][nLonPixels];
            y_in = new double[nLatPixels][nLonPixels];
            z_in = new double[nLatPixels][nLonPixels];
            int startX = (int)upperLeftCornerPos.x;
            int endX = (int)endPixelPos.x;
            int startY = (int)upperLeftCornerPos.y;
            int endY = startY + nLatPixels;
            int y = startY;
            int i = 0;
            while (y < endY) {
                x = startX;
                j = 0;
                while (x < endX) {
                    pos.setLocation((float)x + 0.5f, (float)y + 0.5f);
                    tileGeoRef.getPixelPos(dem.getGeoPos(pos), pixelPos);
                    x_in[i][j] = pixelPos.x;
                    y_in[i][j] = pixelPos.y;
                    try {
                        float elev = dem.getSample(x, y);
                        if (Float.isNaN(elev)) {
                            elev = demNoDataValue;
                        }
                        z_in[i][j] = elev;
                    }
                    catch (Exception e) {
                        z_in[i][j] = demNoDataValue;
                    }
                    ++x;
                    ++j;
                }
                ++y;
                ++i;
            }
            y = startY;
            i = 0;
            while (y < endY) {
                x = 0;
                j = endX - startX;
                while (x < (int)lowerRightCornerPos.x) {
                    pos.setLocation((float)x + 0.5f, (float)y + 0.5f);
                    tileGeoRef.getPixelPos(dem.getGeoPos(pos), pixelPos);
                    x_in[i][j] = pixelPos.x;
                    y_in[i][j] = pixelPos.y;
                    try {
                        float elev = dem.getSample(x, y);
                        if (Float.isNaN(elev)) {
                            elev = demNoDataValue;
                        }
                        z_in[i][j] = elev;
                    }
                    catch (Exception e) {
                        z_in[i][j] = demNoDataValue;
                    }
                    ++x;
                    ++j;
                }
                ++y;
                ++i;
            }
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
        SLCImage meta = new SLCImage(absRoot);
        Orbit orbit = new Orbit(absRoot, 3);
        long firstLine = tileWindow.linelo + 1L;
        long lastLine = tileWindow.linehi - 1L;
        long firstPixel = tileWindow.pixlo + 1L;
        long lastPixel = tileWindow.pixhi - 1L;
        Point p1 = orbit.lp2xyz((double)firstLine, (double)firstPixel, meta);
        Point p2 = orbit.lp2xyz((double)firstLine, (double)lastPixel, meta);
        Point p3 = orbit.lp2xyz((double)lastLine, (double)firstPixel, meta);
        Point p4 = orbit.lp2xyz((double)lastLine, (double)lastPixel, meta);
        double rangeSpacing = (p1.min(p2).norm() + p3.min(p4).norm()) / 2.0 / (double)(lastPixel - firstPixel);
        double aziSpacing = (p1.min(p3).norm() + p2.min(p4).norm()) / 2.0 / (double)(lastLine - firstLine);
        double rngAzRatio = rangeSpacing / aziSpacing;
        double[][] elevation = TriangleUtils.gridDataLinear((double[][])y_in, (double[][])x_in, (double[][])z_in, (Window)tileWindow, (double)rngAzRatio, (int)1, (int)1, (double)demNoDataValue, (int)0);
        boolean valid = false;
        for (int y = y0 - 1; y < maxY; ++y) {
            int yy = y - y0 + 1;
            for (int x = x0 - 1; x < maxX; ++x) {
                float alt = (float)elevation[yy][x - x0 + 1];
                if (!valid && alt != demNoDataValue) {
                    valid = true;
                }
                localDEM[yy][x - x0 + 1] = alt;
            }
        }
        return valid;
    }

    private static GeoPos[] extendCorners(GeoPos extraGeo, GeoPos[] inGeo) {
        if (inGeo.length != 2) {
            throw new IllegalArgumentException("Input GeoPos[] array has to have exactly 2 elements");
        }
        GeoPos[] outGeo = new GeoPos[inGeo.length];
        outGeo[0] = new GeoPos();
        outGeo[0].lat = inGeo[0].lat + extraGeo.lat;
        outGeo[0].lon = inGeo[0].lon - extraGeo.lon;
        outGeo[1] = new GeoPos();
        outGeo[1].lat = inGeo[1].lat - extraGeo.lat;
        outGeo[1].lon = inGeo[1].lon + extraGeo.lon;
        return outGeo;
    }

    static {
        int i;
        descriptors = ElevationModelRegistry.getInstance().getAllDescriptors();
        demNameList = new String[descriptors.length];
        demResamplingList = new String[ResamplingFactory.resamplingNames.length + 1];
        for (i = 0; i < descriptors.length; ++i) {
            DEMFactory.demNameList[i] = DEMFactory.appendAutoDEM(descriptors[i].getName());
        }
        i = 0;
        for (String resampleName : ResamplingFactory.resamplingNames) {
            DEMFactory.demResamplingList[i++] = resampleName;
        }
        DEMFactory.demResamplingList[i] = DELAUNAY_INTERPOLATION;
    }
}

