/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.snap.util.Maths;
import org.esa.snap.util.Settings;

public final class EarthGravitationalModel96 {
    private static final String NAME = "ww15mgh_b.grd";
    private static final int NUM_LATS = 721;
    private static final int NUM_LONS = 1441;
    private static final int NUM_CHAR_PER_NORMAL_LINE = 74;
    private static final int NUM_CHAR_PER_SHORT_LINE = 11;
    private static final int NUM_CHAR_PER_EMPTY_LINE = 1;
    private static final int BLOCK_HEIGHT = 20;
    private static final int NUM_OF_BLOCKS_PER_LAT = 9;
    private static final int MAX_LATS = 720;
    private static final int MAX_LONS = 1440;
    private final float[][] egm = new float[721][1441];
    private static EarthGravitationalModel96 theInstance = null;

    public static EarthGravitationalModel96 instance() {
        if (theInstance == null) {
            theInstance = new EarthGravitationalModel96();
        }
        return theInstance;
    }

    private EarthGravitationalModel96() {
        FileInputStream stream;
        String filePath = Settings.instance().get("AuxData.egm96AuxDataPath");
        String fileName = filePath + File.separator + NAME;
        try {
            stream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new OperatorException("File not found: " + fileName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        int rowIdx = 0;
        int colIdx = 0;
        try {
            boolean numLatLinesToSkip = false;
            int numCharInHeader = 75;
            int numCharInEachLatLine = 13341;
            int totalCharToSkip = 75;
            reader.skip(75L);
            int numLinesInEachLatLine = 191;
            int numLinesToRead = 137711;
            int linesRead = 0;
            for (int i = 0; i < 137710; ++i) {
                line = reader.readLine();
                ++linesRead;
                if (!line.equals("")) {
                    StringTokenizer st = new StringTokenizer(line);
                    int numCols = st.countTokens();
                    for (int j = 0; j < numCols; ++j) {
                        this.egm[rowIdx][colIdx] = Float.parseFloat(st.nextToken());
                        ++colIdx;
                    }
                }
                if (linesRead % 191 != 0) continue;
                ++rowIdx;
                colIdx = 0;
            }
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    public float getEGM(double lat, double lon) {
        double r = (90.0 - lat) / 0.25;
        double c = (lon < 0.0 ? lon + 360.0 : lon) / 0.25;
        double[][] v = new double[4][4];
        int r0 = FastMath.max((int)((int)r - 1), (int)0);
        int c0 = FastMath.max((int)((int)c - 1), (int)0);
        int ci1 = c0 + 1;
        int ci2 = c0 + 2;
        int ci3 = c0 + 3;
        if (ci3 > 1440) {
            c0 = FastMath.min((int)c0, (int)1440);
            ci1 = FastMath.min((int)ci1, (int)1440);
            ci2 = FastMath.min((int)ci2, (int)1440);
            ci3 = FastMath.min((int)ci3, (int)1440);
        }
        for (int i = 0; i < 4; ++i) {
            int ri = r0 + i > 720 ? FastMath.min((int)(r0 + i), (int)720) : r0 + i;
            v[i][0] = this.egm[ri][c0];
            v[i][1] = this.egm[ri][ci1];
            v[i][2] = this.egm[ri][ci2];
            v[i][3] = this.egm[ri][ci3];
        }
        return (float)Maths.interpolationBiCubic((double[][])v, (double)(c - (double)(c0 + 1)), (double)(r - (double)(r0 + 1)));
    }
}

