/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.ElevationTile;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.util.ResourceUtils;
import org.esa.snap.util.ftpUtils;

public abstract class ElevationFile {
    protected File localFile;
    private final File localZipFile;
    private final ProductReader productReader;
    protected boolean localFileExists = false;
    protected boolean remoteFileExists = true;
    private boolean errorInLocalFile = false;
    private ElevationTile tile = null;
    private ftpUtils ftp = null;
    private Map<String, Long> fileSizeMap = null;
    private boolean unrecoverableError = false;

    public ElevationFile(File localFile, ProductReader reader) {
        this.localFile = localFile;
        this.localZipFile = new File(localFile.getParentFile(), FileUtils.getFilenameWithoutExtension((File)localFile) + ".zip");
        this.productReader = reader;
    }

    public void dispose() {
        try {
            if (this.ftp != null) {
                this.ftp.disconnect();
            }
            this.ftp = null;
            this.tile.dispose();
            this.tile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFileName() {
        return this.localFile.getName();
    }

    public final ElevationTile getTile() throws IOException {
        if (this.tile == null) {
            if (!this.remoteFileExists && !this.localFileExists) {
                return null;
            }
            this.getFile();
        }
        return this.tile;
    }

    protected ElevationTile createTile(Product product) {
        return null;
    }

    protected boolean findLocalFile() {
        return this.localFile.exists() && this.localFile.isFile() || this.localZipFile.exists() && this.localZipFile.isFile();
    }

    private synchronized void getFile() throws IOException {
        block10: {
            try {
                if (this.tile != null) {
                    return;
                }
                if (!this.localFileExists && !this.errorInLocalFile) {
                    this.localFileExists = this.findLocalFile();
                }
                if (this.localFileExists) {
                    this.getLocalFile();
                } else if (this.remoteFileExists && this.getRemoteFile()) {
                    this.getLocalFile();
                }
                if (this.tile != null) {
                    this.errorInLocalFile = false;
                } else {
                    if (!this.remoteFileExists && this.localFileExists) {
                        System.out.println("Unable to reader product " + this.localFile.getAbsolutePath());
                    }
                    this.localFileExists = false;
                    this.errorInLocalFile = true;
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                this.tile = null;
                this.localFileExists = false;
                this.errorInLocalFile = true;
                if (!this.unrecoverableError) break block10;
                throw new IOException(e);
            }
        }
    }

    private void getLocalFile() throws IOException {
        Product product;
        File dataFile = this.localFile;
        if (!dataFile.exists()) {
            dataFile = this.getFileFromZip(this.localZipFile);
        }
        if (dataFile != null && (product = this.productReader.readProductNodes((Object)dataFile, null)) != null) {
            this.tile = this.createTile(product);
        }
    }

    protected abstract String getRemoteFTP();

    protected abstract String getRemotePath();

    protected abstract boolean getRemoteFile() throws IOException;

    protected boolean getRemoteHttpFile(String baseUrl) throws IOException {
        VisatApp visatApp = VisatApp.getApp();
        String remotePath = baseUrl + this.localZipFile.getName();
        System.out.println("http retrieving " + remotePath);
        try {
            if (visatApp != null) {
                visatApp.setStatusBarMessage("Downloading " + this.localZipFile.getName());
            }
            ElevationFile.downloadFile(new URL(remotePath), this.localZipFile);
            if (visatApp != null) {
                visatApp.setStatusBarMessage("");
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("http error:" + e.getMessage() + " on " + remotePath);
            this.remoteFileExists = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadFile(URL fileUrl, File localZipFile) throws IOException {
        BufferedOutputStream os;
        File outputFile = new File(localZipFile.getParentFile(), new File(fileUrl.getFile()).getName());
        URLConnection urlConnection = fileUrl.openConnection();
        int contentLength = urlConnection.getContentLength();
        BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream(), contentLength);
        try {
            os = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
        try {
            int b;
            int n;
            StatusProgressMonitor status = new StatusProgressMonitor((float)contentLength, "Downloading " + localZipFile.getName() + "... ");
            status.setAllowStdOut(false);
            int size = 32768;
            byte[] buf = new byte[32768];
            int total = 0;
            while ((n = ((InputStream)is).read(buf, 0, 32768)) > -1) {
                ((OutputStream)os).write(buf, 0, n);
                status.worked(total += n);
            }
            status.done();
            while ((b = ((InputStream)is).read()) != -1) {
                ((OutputStream)os).write(b);
            }
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return outputFile;
    }

    protected boolean getRemoteFTPFile() throws IOException {
        try {
            if (this.ftp == null) {
                this.ftp = new ftpUtils(this.getRemoteFTP());
                this.fileSizeMap = ftpUtils.readRemoteFileList((ftpUtils)this.ftp, (String)this.getRemoteFTP(), (String)this.getRemotePath());
            }
            String remoteFileName = this.localZipFile.getName();
            Long fileSize = this.fileSizeMap.get(remoteFileName);
            ftpUtils.FTPError result = this.ftp.retrieveFile(this.getRemotePath() + remoteFileName, this.localZipFile, fileSize);
            if (result == ftpUtils.FTPError.OK) {
                return true;
            }
            if (result == ftpUtils.FTPError.FILE_NOT_FOUND) {
                this.remoteFileExists = false;
            } else {
                this.dispose();
            }
            this.localZipFile.delete();
            return false;
        }
        catch (SocketException e) {
            this.unrecoverableError = true;
            throw e;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (this.ftp == null) {
                this.unrecoverableError = false;
                this.remoteFileExists = false;
                throw new IOException("Failed to connect to FTP " + this.getRemoteFTP() + '\n' + e.getMessage());
            }
            this.dispose();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getFileFromZip(File dataFile) throws IOException {
        String ext = FileUtils.getExtension((String)dataFile.getName());
        if (ext.equalsIgnoreCase(".zip")) {
            String baseName = this.localFile.getName();
            File newFile = new File(ResourceUtils.getApplicationUserTempDataDir(), baseName);
            if (newFile.exists()) {
                return newFile;
            }
            ZipFile zipFile = null;
            FilterOutputStream fileoutputstream = null;
            try {
                int n;
                String folderName;
                zipFile = new ZipFile(dataFile);
                fileoutputstream = new BufferedOutputStream(new FileOutputStream(newFile));
                ZipEntry zipEntry = zipFile.getEntry(baseName);
                if (zipEntry == null && (zipEntry = zipFile.getEntry(baseName.toLowerCase())) == null && (zipEntry = zipFile.getEntry((folderName = FileUtils.getFilenameWithoutExtension((String)dataFile.getName())) + '/' + this.localFile.getName())) == null) {
                    this.localFileExists = false;
                    throw new IOException("Entry '" + baseName + "' not found in zip file.");
                }
                int size = 8192;
                byte[] buf = new byte[8192];
                InputStream zipinputstream = zipFile.getInputStream(zipEntry);
                while ((n = zipinputstream.read(buf, 0, 8192)) > -1) {
                    ((BufferedOutputStream)fileoutputstream).write(buf, 0, n);
                }
                File file = newFile;
                return file;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                dataFile.delete();
                File file = null;
                return file;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
                if (fileoutputstream != null) {
                    fileoutputstream.close();
                }
            }
        }
        return dataFile;
    }
}

