/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationModelDescriptor;
import org.esa.nest.dataio.dem.FileElevationTile;

public class FileElevationModel
implements ElevationModel,
Resampling.Raster {
    private Resampling resampling;
    private Resampling.Index resamplingIndex;
    private Resampling.Raster resamplingRaster;
    private GeoCoding tileGeocoding;
    private FileElevationTile fileElevationTile;
    private int RASTER_WIDTH;
    private int RASTER_HEIGHT;
    private float noDataValue = 0.0f;

    public FileElevationModel(File file, String resamplingMethodName) throws IOException {
        this(file, resamplingMethodName, null);
    }

    public FileElevationModel(File file, String resamplingMethodName, Float demNoDataValue) throws IOException {
        if (resamplingMethodName.equals("DELAUNAY_INTERPOLATION")) {
            throw new OperatorException("Delaunay interpolation for an external DEM file is currently not supported");
        }
        this.init(file, ResamplingFactory.createResampling((String)resamplingMethodName), demNoDataValue);
    }

    public FileElevationModel(File file, Resampling resamplingMethod, Float demNoDataValue) throws IOException {
        this.init(file, resamplingMethod, demNoDataValue);
    }

    private void init(File file, Resampling resamplingMethod, Float demNoDataValue) throws IOException {
        ProductReader productReader = ProductIO.getProductReaderForInput((Object)file);
        Product product = productReader.readProductNodes((Object)file, null);
        this.RASTER_WIDTH = product.getBandAt(0).getSceneRasterWidth();
        this.RASTER_HEIGHT = product.getBandAt(0).getSceneRasterHeight();
        this.fileElevationTile = new FileElevationTile(product);
        this.tileGeocoding = product.getGeoCoding();
        this.noDataValue = demNoDataValue == null ? (float)product.getBandAt(0).getNoDataValue() : demNoDataValue.floatValue();
        this.resampling = resamplingMethod;
        this.resamplingIndex = this.resampling.createIndex();
        this.resamplingRaster = this;
    }

    @Override
    public void dispose() {
        this.fileElevationTile.dispose();
    }

    @Override
    public ElevationModelDescriptor getDescriptor() {
        return null;
    }

    public float getNoDataValue() {
        return this.noDataValue;
    }

    @Override
    public Resampling getResampling() {
        return this.resampling;
    }

    @Override
    public synchronized double getElevation(GeoPos geoPos) throws Exception {
        try {
            PixelPos pix = this.tileGeocoding.getPixelPos(geoPos, null);
            if (!pix.isValid() || pix.x < 0.0f || pix.y < 0.0f || pix.x >= (float)this.RASTER_WIDTH || pix.y >= (float)this.RASTER_HEIGHT) {
                return this.noDataValue;
            }
            this.resampling.computeIndex((double)pix.x, (double)pix.y, this.RASTER_WIDTH, this.RASTER_HEIGHT, this.resamplingIndex);
            double elevation = this.resampling.resample(this.resamplingRaster, this.resamplingIndex);
            if (Double.isNaN(elevation)) {
                return this.noDataValue;
            }
            return elevation;
        }
        catch (Exception e) {
            throw new Exception("Problem reading DEM: " + e.getMessage());
        }
    }

    @Override
    public PixelPos getIndex(GeoPos geoPos) {
        return this.tileGeocoding.getPixelPos(geoPos, null);
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        return this.tileGeocoding.getGeoPos(pixelPos, null);
    }

    @Override
    public float getSample(double pixelX, double pixelY) throws IOException {
        float sample = this.fileElevationTile.getSample((int)pixelX, (int)pixelY);
        if (sample == this.noDataValue) {
            return Float.NaN;
        }
        return sample;
    }

    public int getWidth() {
        return this.RASTER_WIDTH;
    }

    public int getHeight() {
        return this.RASTER_HEIGHT;
    }

    @Override
    public boolean getSamples(int[] x, int[] y, double[][] samples) throws IOException {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                samples[i][j] = this.fileElevationTile.getSample(x[j], y[i]);
                if (samples[i][j] != (double)this.noDataValue) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }
}

