/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.util.CachingObjectArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;

class FileElevationTile {
    private CachingObjectArray linesCache;
    private Product product;
    private static final int maxLines = 500;
    private final List<Integer> indexList = new ArrayList<Integer>(500);

    public FileElevationTile(Product product) {
        this.product = product;
        this.linesCache = new CachingObjectArray(this.getLineFactory());
        this.linesCache.setCachedRange(0, product.getBandAt(0).getSceneRasterHeight());
    }

    public float getSample(int pixelX, int pixelY) throws IOException {
        float[] line;
        try {
            line = (float[])this.linesCache.getObject(pixelY);
        }
        catch (Exception e) {
            throw FileElevationTile.convertLineCacheException(e);
        }
        return line[pixelX];
    }

    public void dispose() {
        this.clearCache();
        this.linesCache = null;
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }

    public void clearCache() {
        this.linesCache.clear();
    }

    private CachingObjectArray.ObjectFactory getLineFactory() {
        final Band band = this.product.getBandAt(0);
        final int width = this.product.getSceneRasterWidth();
        return new CachingObjectArray.ObjectFactory(){

            public Object createObject(int index) throws Exception {
                FileElevationTile.this.updateCache(index);
                return band.readPixels(0, index, width, 1, new float[width], ProgressMonitor.NULL);
            }
        };
    }

    private void updateCache(int index) {
        this.indexList.remove((Object)index);
        this.indexList.add(0, index);
        if (this.indexList.size() > 500) {
            int i = this.indexList.size() - 1;
            this.linesCache.setObject(i, null);
            this.indexList.remove(i);
        }
    }

    private static IOException convertLineCacheException(Exception e) {
        IOException ioe;
        if (e instanceof IOException) {
            ioe = (IOException)e;
        } else {
            ioe = new IOException();
            ioe.setStackTrace(e.getStackTrace());
        }
        return ioe;
    }
}

