/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.ace;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.ace.ACEElevationModelDescriptor;
import org.esa.nest.dataio.dem.ace.ACEFile;

public class ACEElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = ACEElevationModel.getReaderPlugIn("ACE");

    public ACEElevationModel(ACEElevationModelDescriptor descriptor, Resampling resamplingMethod) throws IOException {
        super(descriptor, resamplingMethod);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE + 0.5;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - ((double)geoPos.lat + 90.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE + 0.5;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        float pixelLat = (float)((double)((float)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 90.0);
        float pixelLon = (float)((double)pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0);
        return new GeoPos(pixelLat, pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 90;
        String fileName = this.descriptor.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new ACEFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }
}

