/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.ace;

import java.io.File;
import java.util.Locale;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.nest.dataio.dem.ace.ACEReader;
import org.esa.snap.gpf.ReaderUtils;

public class ACEReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "ACE";
    private static final String[] FILE_EXTENSIONS = new String[]{".ACE"};
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String DESCRIPTION = "ACE Data Product Tile";

    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null) {
            String[] extensions;
            String fileName = file.getName().toLowerCase();
            for (String extension : extensions = this.getDefaultFileExtensions()) {
                if (!fileName.endsWith(extension.toLowerCase()) || fileName.equals(extension.toLowerCase())) continue;
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ACEReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(FORMAT_NAME, FILE_EXTENSIONS, DESCRIPTION);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }
}

