/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.ace2_5min;

import java.io.File;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.ace2_5min.ACE2_5MinElevationModelDescriptor;
import org.esa.nest.dataio.dem.ace2_5min.ACE2_5MinFile;

public class ACE2_5MinElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = ACE2_5MinElevationModel.getReaderPlugIn("ACE2");

    public ACE2_5MinElevationModel(ACE2_5MinElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super(descriptor, resamplingMethod);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - ((double)geoPos.lat + 90.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        float pixelLat = (float)(90.0 - (double)pixelPos.y * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE);
        float pixelLon = (float)((double)pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0);
        return new GeoPos(pixelLat, pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 90;
        String fileName = this.descriptor.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new ACE2_5MinFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }
}

