/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.ace2_5min;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.bc.io.FileDownloader;
import com.bc.io.FileUnpacker;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.AbstractElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ace2_5min.ACE2_5MinElevationModel;
import org.esa.snap.util.Settings;

public class ACE2_5MinElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "ACE2_5Min";
    private static final String DB_FILE_SUFFIX = "_5M.ACE2";
    private static final String ARCHIVE_URL_PATH = "http://nest.s3.amazonaws.com/data/5M_HEIGHTS.zip";
    public static final int NUM_X_TILES = 24;
    public static final int NUM_Y_TILES = 12;
    public static final int DEGREE_RES = 15;
    public static final int PIXEL_RES = 180;
    public static final int NO_DATA_VALUE = -500;
    public static final GeoPos RASTER_ORIGIN = new GeoPos(90.0f, 180.0f);
    public static final int RASTER_WIDTH = 4320;
    public static final int RASTER_HEIGHT = 2160;
    private static final Datum DATUM = Datum.WGS_84;
    private File aceDemInstallDir = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Datum getDatum() {
        return DATUM;
    }

    @Override
    public int getNumXTiles() {
        return 24;
    }

    @Override
    public int getNumYTiles() {
        return 12;
    }

    @Override
    public float getNoDataValue() {
        return -500.0f;
    }

    @Override
    public int getRasterWidth() {
        return 4320;
    }

    @Override
    public int getRasterHeight() {
        return 2160;
    }

    @Override
    public GeoPos getRasterOrigin() {
        return RASTER_ORIGIN;
    }

    @Override
    public int getDegreeRes() {
        return 15;
    }

    @Override
    public int getPixelRes() {
        return 180;
    }

    @Override
    public File getDemInstallDir() {
        if (this.aceDemInstallDir == null) {
            String path = Settings.instance().get("DEM.ace2_5MinDEMDataPath");
            this.aceDemInstallDir = new File(path);
            if (!this.aceDemInstallDir.exists()) {
                this.aceDemInstallDir.mkdirs();
            }
        }
        return this.aceDemInstallDir;
    }

    @Override
    public boolean isDemInstalled() {
        return true;
    }

    @Override
    public URL getDemArchiveUrl() {
        try {
            return new URL(ARCHIVE_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("MalformedURLException not expected: http://nest.s3.amazonaws.com/data/5M_HEIGHTS.zip");
        }
    }

    @Override
    @Deprecated
    public ElevationModel createDem() {
        if (!this.isDemInstalled()) {
            this.installDemFiles(null);
        }
        return new ACE2_5MinElevationModel(this, Resampling.NEAREST_NEIGHBOUR);
    }

    @Override
    public ElevationModel createDem(Resampling resamplingMethod) {
        if (!this.isDemInstalled()) {
            this.installDemFiles(null);
        }
        return new ACE2_5MinElevationModel(this, resamplingMethod);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        String lonString;
        String latString;
        String string = latString = minLat < 0 ? Math.abs(minLat) + "S" : minLat + "N";
        while (latString.length() < 3) {
            latString = '0' + latString;
        }
        String string2 = lonString = minLon < 0 ? Math.abs(minLon) + "W" : minLon + "E";
        while (lonString.length() < 4) {
            lonString = '0' + lonString;
        }
        return latString + lonString + DB_FILE_SUFFIX;
    }

    @Override
    public synchronized boolean installDemFiles(Object uiComponent) {
        boolean success;
        if (this.isDemInstalled()) {
            return true;
        }
        if (this.isInstallingDem()) {
            return true;
        }
        Component parent = uiComponent instanceof Component ? (Component)uiComponent : null;
        File demInstallDir = this.getDemInstallDir();
        if (!demInstallDir.exists() && !(success = demInstallDir.mkdirs())) {
            return false;
        }
        try {
            VisatApp visatApp = VisatApp.getApp();
            if (visatApp != null) {
                visatApp.setStatusBarMessage("Downloading ACE2 5Min DEM...");
            }
            File archiveFile = FileDownloader.downloadFile((URL)this.getDemArchiveUrl(), (File)demInstallDir, (Component)parent);
            FileUnpacker.unpackZip((File)archiveFile, (File)demInstallDir, (Component)parent);
            archiveFile.delete();
            if (visatApp != null) {
                visatApp.setStatusBarMessage("");
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void installWithProgressMonitor(final Component parent) {
        ProgressMonitorSwingWorker worker = new ProgressMonitorSwingWorker((Component)VisatApp.getApp().getMainFrame(), "Installing Ace2 5min DEM..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground(ProgressMonitor pm) throws Exception {
                pm.beginTask("Installing Ace2 5min DEM", 3);
                try {
                    URL archiveUrl = ACE2_5MinElevationModelDescriptor.this.getDemArchiveUrl();
                    File demInstallDir = ACE2_5MinElevationModelDescriptor.this.getDemInstallDir();
                    File archiveFile = FileDownloader.downloadFile((URL)archiveUrl, (File)demInstallDir, (Component)parent);
                    pm.worked(1);
                    FileUnpacker.unpackZip((File)archiveFile, (File)demInstallDir, (Component)parent);
                    pm.worked(1);
                    archiveFile.delete();
                    pm.worked(1);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    pm.done();
                }
                return true;
            }
        };
        worker.executeWithBlocking();
    }
}

