/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.aster;

import com.bc.io.FileUnpacker;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.aster.AsterElevationModelDescriptor;
import org.esa.nest.dataio.dem.aster.AsterFile;

public final class AsterElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = AsterElevationModel.getReaderPlugIn("GeoTIFF");

    public AsterElevationModel(AsterElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super(descriptor, resamplingMethod);
        this.unpackTileBundles();
        this.setMaxCacheSize(12);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (83.0 - (double)geoPos.lat) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = (double)((float)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 83.0;
        double pixelLon = (double)pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos((float)pixelLat, (float)pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 83;
        String fileName = this.descriptor.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new AsterFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private void unpackTileBundles() {
        File parentFolder = this.descriptor.getDemInstallDir();
        File[] files = parentFolder.listFiles();
        try {
            for (File f : files) {
                String name = f.getName().toLowerCase();
                if (!name.startsWith("tiles_") || !name.endsWith(".zip")) continue;
                Window component = null;
                if (VisatApp.getApp() != null) {
                    component = VisatApp.getApp().getApplicationWindow();
                }
                FileUnpacker.unpackZip((File)f, (File)parentFolder, (Component)component);
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

