/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.aster;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.util.SystemUtils;
import org.esa.nest.dataio.dem.AbstractElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.aster.AsterElevationModel;
import org.esa.snap.util.Settings;

public class AsterElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "ASTER 1sec GDEM";
    private static final String DB_FILE_SUFFIX = ".TIF";
    private static final String ARCHIVE_URL_PATH = SystemUtils.BEAM_HOME_PAGE + "data/ACE.zip";
    private static final int NUM_X_TILES = 360;
    private static final int NUM_Y_TILES = 166;
    private static final int DEGREE_RES = 1;
    private static final int PIXEL_RES = 3600;
    private static final int NO_DATA_VALUE = -9999;
    private static final GeoPos RASTER_ORIGIN = new GeoPos(83.0f, 180.0f);
    private static final int RASTER_WIDTH = 1296000;
    private static final int RASTER_HEIGHT = 597600;
    private static final Datum DATUM = Datum.WGS_84;
    private File demInstallDir = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumXTiles() {
        return 360;
    }

    @Override
    public int getNumYTiles() {
        return 166;
    }

    @Override
    public Datum getDatum() {
        return DATUM;
    }

    @Override
    public float getNoDataValue() {
        return -9999.0f;
    }

    @Override
    public int getRasterWidth() {
        return 1296000;
    }

    @Override
    public int getRasterHeight() {
        return 597600;
    }

    @Override
    public GeoPos getRasterOrigin() {
        return RASTER_ORIGIN;
    }

    @Override
    public int getDegreeRes() {
        return 1;
    }

    @Override
    public int getPixelRes() {
        return 3600;
    }

    @Override
    public File getDemInstallDir() {
        if (this.demInstallDir == null) {
            String path = Settings.instance().get("DEM.AsterDEMDataPath");
            this.demInstallDir = new File(path);
            if (!this.demInstallDir.exists()) {
                this.demInstallDir.mkdirs();
            }
        }
        return this.demInstallDir;
    }

    @Override
    public boolean isDemInstalled() {
        return true;
    }

    @Override
    public URL getDemArchiveUrl() {
        try {
            return new URL(ARCHIVE_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("MalformedURLException not expected: " + ARCHIVE_URL_PATH);
        }
    }

    @Override
    @Deprecated
    public ElevationModel createDem() {
        try {
            return new AsterElevationModel(this, Resampling.BILINEAR_INTERPOLATION);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ElevationModel createDem(Resampling resamplingMethod) {
        try {
            return new AsterElevationModel(this, resamplingMethod);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        StringBuilder name = new StringBuilder("ASTGTM_");
        name.append(minLat < 0 ? "S" : "N");
        String latString = String.valueOf(Math.abs(minLat));
        while (latString.length() < 2) {
            latString = '0' + latString;
        }
        name.append(latString);
        name.append(minLon < 0 ? "W" : "E");
        String lonString = String.valueOf(Math.abs(minLon));
        while (lonString.length() < 3) {
            lonString = '0' + lonString;
        }
        name.append(lonString);
        name.append(".zip");
        return name.toString();
    }
}

