/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.aster;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.io.FileUtils;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.ElevationTile;
import org.esa.nest.dataio.dem.aster.AsterElevationModel;
import org.esa.nest.dataio.dem.aster.AsterElevationTile;

public final class AsterFile
extends ElevationFile {
    private final AsterElevationModel demModel;

    public AsterFile(AsterElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    @Override
    protected String getRemoteFTP() {
        return null;
    }

    @Override
    protected String getRemotePath() {
        return null;
    }

    @Override
    protected boolean getRemoteFile() throws IOException {
        this.remoteFileExists = false;
        return false;
    }

    @Override
    protected ElevationTile createTile(Product product) {
        AsterElevationTile tile = new AsterElevationTile(this.demModel, product);
        this.demModel.updateCache(tile);
        return tile;
    }

    @Override
    protected boolean findLocalFile() {
        if (this.localFile.exists() && this.localFile.isFile() && this.localFile.length() > 0L) {
            return true;
        }
        String name = FileUtils.getFilenameWithoutExtension((String)this.localFile.getName());
        String v2Name = name.replace("ASTGTM", "ASTGTM2");
        File v2File = new File(this.localFile.getParentFile(), v2Name + ".zip");
        if (v2File.exists()) {
            this.localFile = new File(this.localFile.getParentFile(), v2Name + "_dem.tif");
            return true;
        }
        File unzipFile = new File(this.localFile.getParentFile(), name + "_dem.tif");
        if (unzipFile.exists()) {
            this.localFile = unzipFile;
            return true;
        }
        File v2UnzipFile = new File(this.localFile.getParentFile(), v2Name + "_dem.tif");
        if (v2UnzipFile.exists()) {
            this.localFile = v2UnzipFile;
            return true;
        }
        return false;
    }

    @Override
    protected File getFileFromZip(File dataFile) throws IOException {
        if (!dataFile.exists()) {
            String v2Name = dataFile.getName().replace("ASTGTM", "ASTGTM2");
            dataFile = new File(dataFile.getParentFile(), v2Name);
        }
        return super.getFileFromZip(dataFile);
    }
}

