/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.getasse30;

import java.io.File;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.getasse30.GETASSE30ElevationModelDescriptor;
import org.esa.nest.dataio.dem.getasse30.GETASSE30File;

public class GETASSE30ElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = GETASSE30ElevationModel.getReaderPlugIn("GETASSE30");

    public GETASSE30ElevationModel(GETASSE30ElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super(descriptor, resamplingMethod);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) / (double)this.DEGREE_RES * (double)this.NUM_PIXELS_PER_TILE + 0.5;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - ((double)geoPos.lat + 90.0) / (double)this.DEGREE_RES * (double)this.NUM_PIXELS_PER_TILE + 0.5;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        float pixelLat = ((float)this.RASTER_HEIGHT - pixelPos.y) / (float)(this.DEGREE_RES * this.NUM_PIXELS_PER_TILE) - 90.0f;
        float pixelLon = pixelPos.x / (float)(this.DEGREE_RES * this.NUM_PIXELS_PER_TILE) - 180.0f;
        return new GeoPos(pixelLat, pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 90;
        String fileName = this.descriptor.createTileFilename(minLat, minLon);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new GETASSE30File(this, localFile, productReaderPlugIn.createReaderInstance());
    }
}

