/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.getasse30;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.util.SystemUtils;
import org.esa.nest.dataio.dem.AbstractElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.getasse30.GETASSE30ElevationModel;
import org.esa.snap.util.Settings;

public class GETASSE30ElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "GETASSE30";
    private static final String DB_FILE_SUFFIX = ".GETASSE30";
    private static final String ARCHIVE_URL_PATH = SystemUtils.BEAM_HOME_PAGE + "data/GETASSE30.zip";
    private static final int NUM_X_TILES = 24;
    private static final int NUM_Y_TILES = 12;
    private static final int DEGREE_RES = 15;
    private static final int PIXEL_RES = 1800;
    public static final int NO_DATA_VALUE = -9999;
    private static final GeoPos RASTER_ORIGIN = new GeoPos(90.0f, 180.0f);
    private static final int RASTER_WIDTH = 43200;
    private static final int RASTER_HEIGHT = 21600;
    private static final Datum DATUM = Datum.WGS_84;
    private File demInstallDir = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Datum getDatum() {
        return DATUM;
    }

    @Override
    public int getNumXTiles() {
        return 24;
    }

    @Override
    public int getNumYTiles() {
        return 12;
    }

    @Override
    public float getNoDataValue() {
        return -9999.0f;
    }

    @Override
    public int getRasterWidth() {
        return 43200;
    }

    @Override
    public int getRasterHeight() {
        return 21600;
    }

    @Override
    public GeoPos getRasterOrigin() {
        return RASTER_ORIGIN;
    }

    @Override
    public int getDegreeRes() {
        return 15;
    }

    @Override
    public int getPixelRes() {
        return 1800;
    }

    @Override
    public File getDemInstallDir() {
        if (this.demInstallDir == null) {
            String path = Settings.instance().get("DEM.Getasse30DEMDataPath");
            this.demInstallDir = new File(path);
            if (!this.demInstallDir.exists()) {
                this.demInstallDir.mkdirs();
            }
        }
        return this.demInstallDir;
    }

    @Override
    public boolean isDemInstalled() {
        return true;
    }

    @Override
    public URL getDemArchiveUrl() {
        try {
            return new URL(ARCHIVE_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("MalformedURLException not expected: " + ARCHIVE_URL_PATH);
        }
    }

    @Override
    @Deprecated
    public ElevationModel createDem() {
        return this.createDem(Resampling.BILINEAR_INTERPOLATION);
    }

    @Override
    public ElevationModel createDem(Resampling resampling) {
        return new GETASSE30ElevationModel(this, resampling);
    }

    public File getTileFile(int minLon, int minLat) {
        return new File(this.getDemInstallDir(), this.createTileFilename(minLat, minLon));
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        String lonString;
        String latString;
        String string = latString = minLat < 0 ? Math.abs(minLat) + "S" : minLat + "N";
        while (latString.length() < 3) {
            latString = "0" + latString;
        }
        String string2 = lonString = minLon < 0 ? Math.abs(minLon) + "W" : minLon + "E";
        while (lonString.length() < 4) {
            lonString = "0" + lonString;
        }
        return latString + lonString + DB_FILE_SUFFIX;
    }
}

