/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.srtm1_esrigrid;

import java.io.File;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.srtm1_esrigrid.SRTM1GridElevationModelDescriptor;
import org.esa.nest.dataio.dem.srtm1_esrigrid.SRTM1GridFile;

public final class SRTM1GridElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = SRTM1GridElevationModel.getReaderPlugIn("ARC_INFO_BIN_GRID");

    public SRTM1GridElevationModel(SRTM1GridElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super(descriptor, resamplingMethod);
        this.setMaxCacheSize(12);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (double)this.RASTER_HEIGHT - ((double)geoPos.lat + 60.0) / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        float pixelLat = (float)((double)((float)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0);
        float pixelLon = (float)((double)pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0);
        return new GeoPos(pixelLat, pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        int minLon = x * this.DEGREE_RES - 180;
        int minLat = y * this.DEGREE_RES - 60;
        String folderName = this.descriptor.createTileFilename(minLat, minLon);
        File localFolder = new File(demInstallDir, folderName);
        File localFile = new File(localFolder, "hdr.adf");
        elevationFiles[x][this.NUM_Y_TILES - 1 - y] = new SRTM1GridFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }
}

