/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.srtm1_esrigrid;

import java.io.File;
import java.net.URL;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.AbstractElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.srtm1_esrigrid.SRTM1GridElevationModel;
import org.esa.snap.util.Settings;

public class SRTM1GridElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    public static final String NAME = "SRTM 1Sec Grid";
    public static final String DB_FILE_SUFFIX = ".adf";
    public static final int NUM_X_TILES = 360;
    public static final int NUM_Y_TILES = 120;
    public static final int DEGREE_RES = 1;
    public static final int PIXEL_RES = 3600;
    public static final int NO_DATA_VALUE = Short.MIN_VALUE;
    public static final GeoPos RASTER_ORIGIN = new GeoPos(60.0f, 180.0f);
    public static final int RASTER_WIDTH = 1296000;
    public static final int RASTER_HEIGHT = 432000;
    public static final Datum DATUM = Datum.WGS_84;
    private File demInstallDir = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Datum getDatum() {
        return DATUM;
    }

    @Override
    public int getNumXTiles() {
        return 360;
    }

    @Override
    public int getNumYTiles() {
        return 120;
    }

    @Override
    public float getNoDataValue() {
        return -32768.0f;
    }

    @Override
    public int getRasterWidth() {
        return 1296000;
    }

    @Override
    public int getRasterHeight() {
        return 432000;
    }

    @Override
    public GeoPos getRasterOrigin() {
        return RASTER_ORIGIN;
    }

    @Override
    public int getDegreeRes() {
        return 1;
    }

    @Override
    public int getPixelRes() {
        return 3600;
    }

    @Override
    public File getDemInstallDir() {
        if (this.demInstallDir == null) {
            String path = Settings.instance().get("DEM.srtm1GridDEMDataPath");
            this.demInstallDir = new File(path);
            if (!this.demInstallDir.exists()) {
                this.demInstallDir.mkdirs();
            }
        }
        return this.demInstallDir;
    }

    @Override
    public boolean isDemInstalled() {
        return true;
    }

    @Override
    public URL getDemArchiveUrl() {
        return null;
    }

    @Override
    @Deprecated
    public ElevationModel createDem() {
        try {
            return new SRTM1GridElevationModel(this, Resampling.BILINEAR_INTERPOLATION);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ElevationModel createDem(Resampling resamplingMethod) {
        try {
            return new SRTM1GridElevationModel(this, resamplingMethod);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        StringBuilder name = new StringBuilder(12);
        name.append(minLon < 0 ? "w" : "e");
        String lonString = String.valueOf(Math.abs(minLon));
        while (lonString.length() < 2) {
            lonString = '0' + lonString;
        }
        name.append(lonString);
        name.append('_');
        name.append(minLat < 0 ? "s" : "n");
        String latString = String.valueOf(Math.abs(minLat));
        while (latString.length() < 2) {
            latString = '0' + latString;
        }
        name.append(latString);
        return name.toString();
    }
}

