/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.srtm3_geotiff;

import java.io.File;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.nest.dataio.dem.BaseElevationModel;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.srtm3_geotiff.SRTM3GeoTiffElevationModelDescriptor;
import org.esa.nest.dataio.dem.srtm3_geotiff.SRTM3GeoTiffFile;

public final class SRTM3GeoTiffElevationModel
extends BaseElevationModel {
    private static final ProductReaderPlugIn productReaderPlugIn = SRTM3GeoTiffElevationModel.getReaderPlugIn("GeoTIFF");

    public SRTM3GeoTiffElevationModel(SRTM3GeoTiffElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super(descriptor, resamplingMethod);
        this.setMaxCacheSize(12);
    }

    @Override
    public double getIndexX(GeoPos geoPos) {
        return ((double)geoPos.lon + 180.0) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv + 0.25;
    }

    @Override
    public double getIndexY(GeoPos geoPos) {
        return (60.0 - (double)geoPos.lat) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv - 0.5;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos) {
        float pixelLat = (float)((double)((float)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0);
        float pixelLon = (float)((double)pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0);
        return new GeoPos(pixelLat, pixelLon);
    }

    @Override
    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        String fileName = this.descriptor.createTileFilename(x + 1, y + 1);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][y] = new SRTM3GeoTiffFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }
}

