/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.srtm3_geotiff;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.util.SystemUtils;
import org.esa.nest.dataio.dem.AbstractElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.srtm3_geotiff.SRTM3GeoTiffElevationModel;
import org.esa.snap.util.Settings;

public class SRTM3GeoTiffElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "SRTM 3Sec";
    private static final String DB_FILE_SUFFIX = ".tif";
    private static final String ARCHIVE_URL_PATH = SystemUtils.BEAM_HOME_PAGE + "data/ACE.zip";
    private static final int NUM_X_TILES = 72;
    private static final int NUM_Y_TILES = 24;
    private static final int DEGREE_RES = 5;
    private static final int PIXEL_RES = 6000;
    private static final int NO_DATA_VALUE = Short.MIN_VALUE;
    private static final GeoPos RASTER_ORIGIN = new GeoPos(60.0f, 180.0f);
    private static final int RASTER_WIDTH = 432000;
    private static final int RASTER_HEIGHT = 144000;
    private static final Datum DATUM = Datum.WGS_84;
    private File demInstallDir = null;
    private static SRTM3GeoTiffElevationModel demModel = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Datum getDatum() {
        return DATUM;
    }

    @Override
    public int getNumXTiles() {
        return 72;
    }

    @Override
    public int getNumYTiles() {
        return 24;
    }

    @Override
    public float getNoDataValue() {
        return -32768.0f;
    }

    @Override
    public int getRasterWidth() {
        return 432000;
    }

    @Override
    public int getRasterHeight() {
        return 144000;
    }

    @Override
    public GeoPos getRasterOrigin() {
        return RASTER_ORIGIN;
    }

    @Override
    public int getDegreeRes() {
        return 5;
    }

    @Override
    public int getPixelRes() {
        return 6000;
    }

    @Override
    public File getDemInstallDir() {
        if (this.demInstallDir == null) {
            String path = Settings.instance().get("DEM.srtm3GeoTiffDEMDataPath");
            this.demInstallDir = new File(path);
            if (!this.demInstallDir.exists()) {
                this.demInstallDir.mkdirs();
            }
        }
        return this.demInstallDir;
    }

    @Override
    public boolean isDemInstalled() {
        return true;
    }

    @Override
    public URL getDemArchiveUrl() {
        try {
            return new URL(ARCHIVE_URL_PATH);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("MalformedURLException not expected: " + ARCHIVE_URL_PATH);
        }
    }

    @Override
    @Deprecated
    public synchronized ElevationModel createDem() {
        return new SRTM3GeoTiffElevationModel(this, Resampling.BILINEAR_INTERPOLATION);
    }

    @Override
    public synchronized ElevationModel createDem(Resampling resamplingMethod) {
        return new SRTM3GeoTiffElevationModel(this, resamplingMethod);
    }

    @Override
    public String createTileFilename(int tileX, int tileY) {
        StringBuilder name = new StringBuilder("srtm_");
        if (tileX < 10) {
            name.append('0');
        }
        name.append(tileX);
        name.append('_');
        if (tileY < 10) {
            name.append('0');
        }
        name.append(tileY);
        name.append(DB_FILE_SUFFIX);
        return name.toString();
    }
}

