/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dataio.dem.srtm3_geotiff;

import java.io.File;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Product;
import org.esa.nest.dataio.dem.ElevationFile;
import org.esa.nest.dataio.dem.ElevationTile;
import org.esa.nest.dataio.dem.srtm3_geotiff.SRTM3GeoTiffElevationModel;
import org.esa.nest.dataio.dem.srtm3_geotiff.SRTM3GeoTiffElevationTile;
import org.esa.snap.util.Settings;
import org.esa.snap.util.ftpUtils;

public final class SRTM3GeoTiffFile
extends ElevationFile {
    private final SRTM3GeoTiffElevationModel demModel;
    private static final String remoteFTP = Settings.instance().get("DEM.srtm3GeoTiffDEM_FTP");
    private static final String remotePath = ftpUtils.getPathFromSettings((String)"DEM.srtm3GeoTiffDEM_remotePath");
    private static final String remoteHTTP = "http://droppr.org/srtm/v4.1/6_5x5_TIFs/";

    public SRTM3GeoTiffFile(SRTM3GeoTiffElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    @Override
    protected String getRemoteFTP() {
        return remoteFTP;
    }

    @Override
    protected String getRemotePath() {
        return remotePath;
    }

    @Override
    protected ElevationTile createTile(Product product) {
        SRTM3GeoTiffElevationTile tile = new SRTM3GeoTiffElevationTile(this.demModel, product);
        this.demModel.updateCache(tile);
        return tile;
    }

    @Override
    protected boolean getRemoteFile() throws IOException {
        try {
            if (remoteFTP.isEmpty() || remoteFTP.startsWith("http")) {
                return this.getRemoteHttpFile(remoteHTTP);
            }
            return this.getRemoteFTPFile();
        }
        catch (Exception e) {
            return this.getRemoteHttpFile(remoteHTTP);
        }
    }
}

