/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="AddElevation", category="Geometric Operations/DEM Tools", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Creates a DEM band")
public final class CreateElevationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"ACE", "GETASSE30", "SRTM 3Sec", "ASTER 1sec GDEM"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(description="The elevation band name.", defaultValue="elevation", label="Elevation Band Name")
    private String elevationBandName = "elevation";
    @Parameter(description="The external DEM file.", defaultValue=" ", label="External DEM")
    private String externalDEM = " ";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BISINC_5_POINT_INTERPOLATION", "BICUBIC_INTERPOLATION"}, defaultValue="BILINEAR_INTERPOLATION", label="Resampling Method")
    private String resamplingMethod = "BILINEAR_INTERPOLATION";
    private FileElevationModel fileElevationModel = null;
    private ElevationModel dem = null;
    private Band elevationBand = null;
    private float noDataValue = 0.0f;
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);

    public void initialize() throws OperatorException {
        try {
            if (this.externalDEM != null && !this.externalDEM.trim().isEmpty()) {
                this.fileElevationModel = new FileElevationModel(new File(this.externalDEM), this.resamplingMethod);
                this.noDataValue = this.fileElevationModel.getNoDataValue();
            } else {
                this.dem = DEMFactory.createElevationModel(this.demName, this.resamplingMethod);
                this.noDataValue = this.dem.getDescriptor().getNoDataValue();
            }
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (Band band : this.sourceProduct.getBands()) {
            if (band.getName().equalsIgnoreCase(this.elevationBandName)) {
                throw new OperatorException("Band " + this.elevationBandName + " already exists. Try another name.");
            }
            if (band instanceof VirtualBand) {
                VirtualBand sourceBand = (VirtualBand)band;
                VirtualBand targetBand = new VirtualBand(sourceBand.getName(), sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getExpression());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                this.targetProduct.addBand((Band)targetBand);
                this.sourceRasterMap.put((Band)targetBand, band);
                continue;
            }
            Band targetBand = ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(band.getSourceImage());
            this.sourceRasterMap.put(targetBand, band);
        }
        this.elevationBand = this.targetProduct.addBand(this.elevationBandName, 30);
        this.elevationBand.setNoDataValue((double)this.noDataValue);
        this.elevationBand.setUnit("meters");
        this.elevationBand.setDescription(this.dem.getDescriptor().getName());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            if (targetBand == this.elevationBand) {
                Rectangle targetRectangle = targetTile.getRectangle();
                int x0 = targetRectangle.x;
                int y0 = targetRectangle.y;
                int w = targetRectangle.width;
                int h = targetRectangle.height;
                ProductData trgData = targetTile.getDataBuffer();
                TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, y0, w, h);
                float demNoDataValue = this.dem.getDescriptor().getNoDataValue();
                double[][] localDEM = new double[h + 2][w + 2];
                DEMFactory.getLocalDEM(this.dem, demNoDataValue, this.resamplingMethod, tileGeoRef, x0, y0, w, h, this.sourceProduct, true, localDEM);
                TileIndex trgIndex = new TileIndex(targetTile);
                int maxX = x0 + w;
                int maxY = y0 + h;
                for (int y = y0; y < maxY; ++y) {
                    int yy = y - y0 + 1;
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        trgData.setElemDoubleAt(trgIndex.getIndex(x), localDEM[yy][x - x0 + 1]);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CreateElevationOp.class);
        }
    }
}

