/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.ui.AppContext;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class CreateElevationOpUI
extends BaseOperatorUI {
    private final JComboBox<String> demName = new JComboBox<String>(DEMFactory.getDEMNameList());
    private final JTextField elevationBandName = new JTextField("");
    private final JTextField externalDEM = new JTextField("");
    private final JComboBox demResamplingMethod = new JComboBox<String>(DEMFactory.getDEMResamplingMethods());

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            this.demName.setSelectedItem(DEMFactory.appendAutoDEM(demNameParam));
        }
        this.elevationBandName.setText(String.valueOf(this.paramMap.get("elevationBandName")));
        this.externalDEM.setText(String.valueOf(this.paramMap.get("externalDEM")));
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("resamplingMethod"));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)this.demName.getSelectedItem()));
        this.paramMap.put("elevationBandName", this.elevationBandName.getText());
        this.paramMap.put("externalDEM", this.externalDEM.getText());
        this.paramMap.put("resamplingMethod", this.demResamplingMethod.getSelectedItem());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"External DEM:", (JComponent)this.externalDEM);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Method:", (JComponent)this.demResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Elevation Band Name:", (JComponent)this.elevationBandName);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

