/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.dat.layersrc;

import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.beam.framework.ui.layer.LayerSource;
import org.esa.beam.framework.ui.layer.LayerSourcePageContext;
import org.esa.nest.dat.layersrc.GCPVectorLayer;
import org.esa.nest.dat.layersrc.GCPVectorLayerType;
import org.esa.snap.datamodel.AbstractMetadata;

public class GCPVectorLayerSource
implements LayerSource {
    public boolean isApplicable(LayerSourcePageContext pageContext) {
        MetadataElement bandElem;
        Product product = pageContext.getAppContext().getSelectedProduct();
        Band band = product.getBand(pageContext.getAppContext().getSelectedProductSceneView().getRaster().getName());
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
        if (absRoot != null && (bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)band.getName(), (boolean)false)) != null) {
            MetadataElement warpDataElem = bandElem.getElement("WarpData");
            return warpDataElem != null;
        }
        return false;
    }

    public boolean hasFirstPage() {
        return false;
    }

    public AbstractLayerSourceAssistantPage getFirstPage(LayerSourcePageContext pageContext) {
        return null;
    }

    public boolean canFinish(LayerSourcePageContext pageContext) {
        return true;
    }

    public boolean performFinish(LayerSourcePageContext pageContext) {
        Product product = pageContext.getAppContext().getSelectedProduct();
        Band band = product.getBand(pageContext.getAppContext().getSelectedProductSceneView().getRaster().getName());
        GCPVectorLayer fieldLayer = GCPVectorLayerType.createLayer(product, band);
        pageContext.getLayerContext().getRootLayer().getChildren().add(0, fieldLayer);
        return true;
    }

    public void cancel(LayerSourcePageContext pageContext) {
    }
}

