/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.FeatureCollectionClipper;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.gpf.Collocator;
import org.esa.nest.gpf.GCPManager;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.ProductInformation;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.StackUtils;
import org.esa.snap.gpf.TileIndex;

@OperatorMetadata(alias="CreateStack", category="SAR Processing/Coregistration", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Collocates two or more products based on their geo-codings.")
public class CreateStackOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @Parameter(description="The list of source bands.", alias="masterBands", itemAlias="band", rasterDataNodeType=Band.class, label="Master Band")
    private String[] masterBandNames = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Slave Bands")
    private String[] slaveBandNames = null;
    private Product masterProduct = null;
    private final Band[] masterBands = new Band[2];
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(valueSet={"NONE", "NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BISINC_5_POINT_INTERPOLATION", "BICUBIC_INTERPOLATION"}, defaultValue="NONE", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingType = "NONE";
    private Resampling selectedResampling = null;
    @Parameter(valueSet={"Master", "Minimum", "Maximum"}, defaultValue="Master", description="The output image extents.", label="Output Extents")
    private String extent = "Master";
    static final String MASTER_EXTENT = "Master";
    static final String MIN_EXTENT = "Minimum";
    static final String MAX_EXTENT = "Maximum";
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Product, int[]> slaveOffsettMap = new HashMap<Product, int[]>(10);
    private boolean appendToMaster = false;
    private boolean productPixelSpacingChecked = false;

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            if (this.sourceProduct.length < 2) {
                throw new OperatorException("Please select at least two source products");
            }
            for (Product prod : this.sourceProduct) {
                if (prod.getGeoCoding() != null) continue;
                throw new OperatorException(MessageFormat.format("Product ''{0}'' has no geo-coding.", prod.getName()));
            }
            if (this.masterBandNames == null || this.masterBandNames.length == 0 || this.getMasterProduct(this.masterBandNames[0]) == null) {
                Band defaultBand;
                Product defaultProd = this.sourceProduct[0];
                if (defaultProd != null && (defaultBand = defaultProd.getBandAt(0)) != null) {
                    this.masterBandNames = defaultBand.getUnit() != null && defaultBand.getUnit().equals("real") ? new String[]{defaultProd.getBandAt(0).getName(), defaultProd.getBandAt(1).getName()} : new String[]{defaultBand.getName()};
                }
                if (this.masterBandNames.length == 0) {
                    this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                    return;
                }
            }
            this.masterProduct = this.getMasterProduct(this.masterBandNames[0]);
            if (this.masterProduct == null) {
                this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                return;
            }
            this.appendToMaster = AbstractMetadata.getAbstractedMetadata((Product)this.masterProduct).getAttributeInt("coregistered_stack", 0) == 1;
            ArrayList<String> masterProductBands = new ArrayList<String>(this.masterProduct.getNumBands());
            Band[] slaveBandList = this.getSlaveBands();
            if (this.masterProduct == null || slaveBandList.length == 0 || slaveBandList[0] == null) {
                this.targetProduct = OperatorUtils.createDummyTargetProduct((Product[])this.sourceProduct);
                return;
            }
            if (this.resamplingType.contains("NONE") && !this.extent.equals(MASTER_EXTENT)) {
                throw new OperatorException("Please select only Master extents when resampling type is None");
            }
            if (this.appendToMaster) {
                this.extent = MASTER_EXTENT;
            }
            switch (this.extent) {
                case "Master": {
                    this.targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
                    ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
                    break;
                }
                case "Minimum": {
                    this.determinMinExtents();
                    break;
                }
                default: {
                    this.determinMaxExtents();
                }
            }
            if (this.appendToMaster) {
                for (Band b : this.masterProduct.getBands()) {
                    if (b instanceof VirtualBand) continue;
                    Band targetBand = new Band(b.getName(), b.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                    ProductUtils.copyRasterDataNodeProperties((RasterDataNode)b, (RasterDataNode)targetBand);
                    targetBand.setSourceImage(b.getSourceImage());
                    masterProductBands.add(b.getName());
                    this.sourceRasterMap.put(targetBand, b);
                    this.targetProduct.addBand(targetBand);
                }
            }
            String suffix = "_mst";
            if (!this.appendToMaster) {
                for (Band srcBand : slaveBandList) {
                    if (srcBand != this.masterBands[0] && (this.masterBands.length <= 1 || srcBand != this.masterBands[1])) continue;
                    suffix = "_mst" + StackUtils.getBandTimeStamp((Product)srcBand.getProduct());
                    Band targetBand = new Band(srcBand.getName() + suffix, srcBand.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                    ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
                    if (this.extent.equals(MASTER_EXTENT)) {
                        targetBand.setSourceImage(srcBand.getSourceImage());
                    }
                    masterProductBands.add(targetBand.getName());
                    this.sourceRasterMap.put(targetBand, srcBand);
                    this.targetProduct.addBand(targetBand);
                }
            }
            int cnt = 1;
            if (this.appendToMaster) {
                for (Band trgBand : this.targetProduct.getBands()) {
                    String name = trgBand.getName();
                    if (!name.contains("slv" + cnt)) continue;
                    ++cnt;
                }
            }
            for (Band srcBand : slaveBandList) {
                if (srcBand == this.masterBands[0] || this.masterBands.length > 1 && srcBand == this.masterBands[1]) continue;
                if (srcBand.getUnit() == null || !srcBand.getUnit().equals("imaginary")) {
                    suffix = "_slv" + cnt++ + StackUtils.getBandTimeStamp((Product)srcBand.getProduct());
                }
                String tgtBandName = srcBand.getName() + suffix;
                if (this.targetProduct.getBand(tgtBandName) != null) continue;
                Product srcProduct = srcBand.getProduct();
                Band targetBand = new Band(tgtBandName, srcBand.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
                if (this.extent.equals(MASTER_EXTENT) && (srcProduct == this.masterProduct || srcProduct.isCompatibleProduct(this.targetProduct, 0.001f))) {
                    targetBand.setSourceImage(srcBand.getSourceImage());
                }
                if (srcBand.getProduct() == this.masterProduct) {
                    masterProductBands.add(tgtBandName);
                }
                this.sourceRasterMap.put(targetBand, srcBand);
                this.targetProduct.addBand(targetBand);
            }
            this.copySlaveMetadata();
            StackUtils.saveMasterProductBandNames((Product)this.targetProduct, (String[])masterProductBands.toArray(new String[masterProductBands.size()]));
            this.saveSlaveProductNames(this.targetProduct, this.sourceRasterMap);
            this.updateMetadata();
            PlacemarkGroup masterGCPgroup = this.masterProduct.getGcpGroup();
            if (masterGCPgroup.getNodeCount() > 0) {
                OperatorUtils.copyGCPsToTarget((ProductNodeGroup)masterGCPgroup, GCPManager.instance().getGcpGroup(this.targetProduct.getBandAt(0)), (GeoCoding)this.targetProduct.getGeoCoding());
            }
            if (!this.resamplingType.contains("NONE")) {
                this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
            } else {
                this.computeTargetSlaveCoordinateOffsets();
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void updateMetadata() {
        MetadataElement abstractedMetadata = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        abstractedMetadata.setAttributeInt("collocated_stack", 1);
        MetadataElement inputElem = ProductInformation.getInputProducts((Product)this.targetProduct);
        for (Product srcProduct : this.sourceProduct) {
            MetadataAttribute[] slvInputProductAttrbList;
            if (srcProduct == this.masterProduct) continue;
            MetadataElement slvInputElem = ProductInformation.getInputProducts((Product)srcProduct);
            for (MetadataAttribute attrib : slvInputProductAttrbList = slvInputElem.getAttributes()) {
                MetadataAttribute inputAttrb = AbstractMetadata.addAbstractedAttribute((MetadataElement)inputElem, (String)"InputProduct", (int)41, (String)"", (String)"");
                inputAttrb.getData().setElems((Object)attrib.getData().getElemString());
            }
        }
    }

    private void copySlaveMetadata() {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.targetProduct.getMetadataRoot());
        for (Product prod : this.sourceProduct) {
            MetadataElement slvAbsMetadata;
            if (prod == this.masterProduct || (slvAbsMetadata = AbstractMetadata.getAbstractedMetadata((Product)prod)) == null) continue;
            String timeStamp = StackUtils.getBandTimeStamp((Product)prod);
            MetadataElement targetSlaveMetadata = new MetadataElement(prod.getName() + timeStamp);
            targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
            ProductUtils.copyMetadata((MetadataElement)slvAbsMetadata, (MetadataElement)targetSlaveMetadata);
        }
    }

    private void saveSlaveProductNames(Product targetProduct, Map<Band, Band> sourceRasterMap) {
        for (Product prod : this.sourceProduct) {
            if (prod == this.masterProduct) continue;
            String suffix = StackUtils.getBandTimeStamp((Product)prod);
            ArrayList<String> bandNames = new ArrayList<String>(10);
            for (Band tgtBand : sourceRasterMap.keySet()) {
                Band srcBand = sourceRasterMap.get(tgtBand);
                Product srcProduct = srcBand.getProduct();
                if (srcProduct != prod) continue;
                bandNames.add(tgtBand.getName());
            }
            String prodName = prod.getName() + suffix;
            StackUtils.saveSlaveProductBandNames((Product)targetProduct, (String)prodName, (String[])bandNames.toArray(new String[bandNames.size()]));
        }
    }

    private Product getMasterProduct(String name) {
        String masterName = this.getProductName(name);
        for (Product prod : this.sourceProduct) {
            if (!prod.getName().equals(masterName)) continue;
            return prod;
        }
        return null;
    }

    private Band[] getSlaveBands() throws OperatorException {
        String unit;
        ArrayList<Band> bandList = new ArrayList<Band>(5);
        if (this.masterProduct == null) {
            throw new OperatorException("masterProduct is null");
        }
        if (this.masterBandNames.length > 2) {
            throw new OperatorException("Master band should be one real band or a real and imaginary band");
        }
        this.masterBands[0] = this.masterProduct.getBand(CreateStackOp.getBandName(this.masterBandNames[0]));
        if (!this.appendToMaster) {
            bandList.add(this.masterBands[0]);
        }
        if ((unit = this.masterBands[0].getUnit()) != null) {
            if (unit.contains("phase")) {
                throw new OperatorException("Phase band should not be selected for co-registration");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("Real and imaginary master bands should be selected in pairs");
            }
            if (unit.contains("real")) {
                if (this.masterBandNames.length < 2) {
                    if (!CreateStackOp.contains(this.masterBandNames, this.slaveBandNames[0])) {
                        throw new OperatorException("Real and imaginary master bands should be selected in pairs");
                    }
                    int iBandIdx = this.masterProduct.getBandIndex(CreateStackOp.getBandName(this.masterBandNames[0]));
                    this.masterBands[1] = this.masterProduct.getBandAt(iBandIdx + 1);
                    if (!this.masterBands[1].getUnit().equals("imaginary")) {
                        throw new OperatorException("For complex products select a real and an imaginary band");
                    }
                    if (!this.appendToMaster) {
                        bandList.add(this.masterBands[1]);
                    }
                } else {
                    Product prod = this.getMasterProduct(this.masterBandNames[1]);
                    if (prod != this.masterProduct) {
                        // empty if block
                    }
                    this.masterBands[1] = this.masterProduct.getBand(CreateStackOp.getBandName(this.masterBandNames[1]));
                    if (!this.masterBands[1].getUnit().equals("imaginary")) {
                        throw new OperatorException("For complex products select a real and an imaginary band");
                    }
                    if (!this.appendToMaster) {
                        bandList.add(this.masterBands[1]);
                    }
                }
            }
        }
        if (this.slaveBandNames == null || this.slaveBandNames.length == 0 || CreateStackOp.contains(this.masterBandNames, this.slaveBandNames[0])) {
            for (Product slvProduct : this.sourceProduct) {
                for (Band band : slvProduct.getBands()) {
                    if (band.getUnit() != null && band.getUnit().equals("phase") || band instanceof VirtualBand || slvProduct == this.masterProduct && (band == this.masterBands[0] || band == this.masterBands[1] || this.appendToMaster)) continue;
                    bandList.add(band);
                }
            }
        } else {
            for (int i = 0; i < this.slaveBandNames.length; ++i) {
                String name = this.slaveBandNames[i];
                if (CreateStackOp.contains(this.masterBandNames, name)) {
                    throw new OperatorException("Please do not select the same band as master and slave");
                }
                String bandName = CreateStackOp.getBandName(name);
                String productName = this.getProductName(name);
                Product prod = this.getProduct(productName, bandName);
                if (prod == null) continue;
                Band band = prod.getBand(bandName);
                String bandUnit = band.getUnit();
                if (bandUnit != null) {
                    if (bandUnit.contains("phase")) {
                        throw new OperatorException("Phase band should not be selected for co-registration");
                    }
                    if (bandUnit.contains("real") || bandUnit.contains("imaginary")) {
                        if (this.slaveBandNames.length < 2) {
                            throw new OperatorException("Real and imaginary slave bands should be selected in pairs");
                        }
                        String nextBandName = CreateStackOp.getBandName(this.slaveBandNames[i + 1]);
                        String nextBandProdName = this.getProductName(this.slaveBandNames[i + 1]);
                        if (!nextBandProdName.contains(productName)) {
                            throw new OperatorException("Real and imaginary slave bands should be selected from the same product in pairs");
                        }
                        Band nextBand = prod.getBand(nextBandName);
                        if (bandUnit.contains("real") && !nextBand.getUnit().contains("imaginary") || bandUnit.contains("imaginary") && !nextBand.getUnit().contains("real")) {
                            throw new OperatorException("Real and imaginary slave bands should be selected in pairs");
                        }
                        bandList.add(band);
                        bandList.add(nextBand);
                        ++i;
                        continue;
                    }
                    bandList.add(band);
                    continue;
                }
                bandList.add(band);
            }
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    private Product getProduct(String productName, String bandName) {
        for (Product prod : this.sourceProduct) {
            if (!prod.getName().equals(productName) || prod.getBand(bandName) == null) continue;
            return prod;
        }
        return null;
    }

    private static boolean contains(String[] nameList, String name) {
        for (String nameInList : nameList) {
            if (!name.equals(nameInList)) continue;
            return true;
        }
        return false;
    }

    private static String getBandName(String name) {
        if (name.contains("::")) {
            return name.substring(0, name.indexOf("::"));
        }
        return name;
    }

    private String getProductName(String name) {
        if (name.contains("::")) {
            return name.substring(name.indexOf("::") + 2, name.length());
        }
        return this.sourceProduct[0].getName();
    }

    private void determinMinExtents() {
        Geometry tgtGeometry = FeatureCollectionClipper.createGeoBoundaryPolygon((Product)this.masterProduct);
        for (Product slvProd : this.sourceProduct) {
            if (slvProd == this.masterProduct) continue;
            Geometry slvGeometry = FeatureCollectionClipper.createGeoBoundaryPolygon((Product)slvProd);
            tgtGeometry = tgtGeometry.intersection(slvGeometry);
        }
        GeoCoding mstGeoCoding = this.masterProduct.getGeoCoding();
        PixelPos pixPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        float mstWidth = this.masterProduct.getSceneRasterWidth();
        float mstHeight = this.masterProduct.getSceneRasterHeight();
        float maxX = 0.0f;
        float maxY = 0.0f;
        float minX = mstWidth;
        float minY = mstHeight;
        for (Coordinate c : tgtGeometry.getCoordinates()) {
            geoPos.setLocation((float)c.y, (float)c.x);
            mstGeoCoding.getPixelPos(geoPos, pixPos);
            if (!pixPos.isValid() || pixPos.x == -1.0f || pixPos.y == -1.0f) continue;
            if (pixPos.x < minX) {
                minX = Math.max(0.0f, pixPos.x);
            }
            if (pixPos.y < minY) {
                minY = Math.max(0.0f, pixPos.y);
            }
            if (pixPos.x > maxX) {
                maxX = Math.min(mstWidth, pixPos.x);
            }
            if (!(pixPos.y > maxY)) continue;
            maxY = Math.min(mstHeight, pixPos.y);
        }
        ProductSubsetBuilder subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(this.masterProduct.getTiePointGridNames());
        subsetDef.setRegion((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
        subsetDef.setSubSampling(1, 1);
        subsetDef.setIgnoreMetadata(false);
        try {
            Band[] bands;
            this.targetProduct = subsetReader.readProductNodes((Object)this.masterProduct, subsetDef);
            for (Band b : bands = this.targetProduct.getBands()) {
                this.targetProduct.removeBand(b);
            }
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private void determinMaxExtents() throws Exception {
        try {
            GeoCoding masterGeoCoding = this.masterProduct.getGeoCoding();
            float xMin = 0.0f;
            float xMax = this.masterProduct.getSceneRasterWidth();
            float yMin = 0.0f;
            float yMax = this.masterProduct.getSceneRasterHeight();
            PixelPos pixelPosUL = new PixelPos();
            PixelPos pixelPosUR = new PixelPos();
            PixelPos pixelPosLL = new PixelPos();
            PixelPos pixelPosLR = new PixelPos();
            GeoPos geoPosUL = new GeoPos();
            GeoPos geoPosUR = new GeoPos();
            GeoPos geoPosLL = new GeoPos();
            GeoPos geoPosLR = new GeoPos();
            for (Product slvProd : this.sourceProduct) {
                if (slvProd == this.masterProduct) continue;
                GeoCoding slaveGeoCoding = slvProd.getGeoCoding();
                GeoPos geoPosFirstNear = slaveGeoCoding.getGeoPos(new PixelPos(0.0f, 0.0f), null);
                GeoPos geoPosFirstFar = slaveGeoCoding.getGeoPos(new PixelPos((float)(slvProd.getSceneRasterWidth() - 1), 0.0f), null);
                GeoPos geoPosLastNear = slaveGeoCoding.getGeoPos(new PixelPos(0.0f, (float)(slvProd.getSceneRasterHeight() - 1)), null);
                GeoPos geoPosLastFar = slaveGeoCoding.getGeoPos(new PixelPos((float)(slvProd.getSceneRasterWidth() - 1), (float)(slvProd.getSceneRasterHeight() - 1)), null);
                masterGeoCoding.getPixelPos(geoPosFirstNear, pixelPosUL);
                masterGeoCoding.getPixelPos(geoPosFirstFar, pixelPosUR);
                masterGeoCoding.getPixelPos(geoPosLastNear, pixelPosLL);
                masterGeoCoding.getPixelPos(geoPosLastFar, pixelPosLR);
                float[] xArray = new float[]{pixelPosUL.x, pixelPosUR.x, pixelPosLL.x, pixelPosLR.x};
                float[] yArray = new float[]{pixelPosUL.y, pixelPosUR.y, pixelPosLL.y, pixelPosLR.y};
                for (int i = 0; i < 4; ++i) {
                    xMin = Math.min(xMin, xArray[i]);
                    xMax = Math.max(xMax, xArray[i]);
                    yMin = Math.min(yMin, yArray[i]);
                    yMax = Math.max(yMax, yArray[i]);
                }
            }
            int sceneWidth = (int)(xMax - xMin) + 1;
            int sceneHeight = (int)(yMax - yMin) + 1;
            this.targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), sceneWidth, sceneHeight);
            masterGeoCoding.getGeoPos(new PixelPos(xMin, yMin), geoPosUL);
            masterGeoCoding.getGeoPos(new PixelPos(xMax, yMin), geoPosUR);
            masterGeoCoding.getGeoPos(new PixelPos(xMin, yMax), geoPosLL);
            masterGeoCoding.getGeoPos(new PixelPos(xMax, yMax), geoPosLR);
            float[] latTiePoints = new float[]{geoPosUL.lat, geoPosUR.lat, geoPosLL.lat, geoPosLR.lat};
            float[] lonTiePoints = new float[]{geoPosUL.lon, geoPosUR.lon, geoPosLL.lon, geoPosLR.lon};
            TiePointGrid latGrid = new TiePointGrid("latitude", 2, 2, 0.5f, 0.5f, (float)(sceneWidth - 1), (float)(sceneHeight - 1), latTiePoints);
            latGrid.setUnit("deg");
            TiePointGrid lonGrid = new TiePointGrid("longitude", 2, 2, 0.5f, 0.5f, (float)(sceneWidth - 1), (float)(sceneHeight - 1), lonTiePoints, TiePointGrid.DISCONT_AT_180);
            lonGrid.setUnit("deg");
            this.targetProduct.addTiePointGrid(latGrid);
            this.targetProduct.addTiePointGrid(lonGrid);
            this.targetProduct.setGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid, Datum.WGS_84));
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void computeTargetSlaveCoordinateOffsets() {
        GeoCoding targGeoCoding = this.targetProduct.getGeoCoding();
        int targImageWidth = this.targetProduct.getSceneRasterWidth();
        int targImageHeight = this.targetProduct.getSceneRasterHeight();
        Geometry tgtGeometry = FeatureCollectionClipper.createGeoBoundaryPolygon((Product)this.targetProduct);
        PixelPos slvPixelPos = new PixelPos();
        PixelPos tgtPixelPos = new PixelPos();
        GeoPos slvGeoPos = new GeoPos();
        for (Product slvProd : this.sourceProduct) {
            if (slvProd == this.masterProduct && this.extent.equals(MASTER_EXTENT)) {
                this.slaveOffsettMap.put(slvProd, new int[]{0, 0});
                continue;
            }
            GeoCoding slvGeoCoding = slvProd.getGeoCoding();
            int slvImageWidth = slvProd.getSceneRasterWidth();
            int slvImageHeight = slvProd.getSceneRasterHeight();
            boolean foundOverlapPoint = false;
            slvGeoCoding.getGeoPos(new PixelPos(10.0f, 10.0f), slvGeoPos);
            if (!foundOverlapPoint) {
                Geometry slvGeometry = FeatureCollectionClipper.createGeoBoundaryPolygon((Product)slvProd);
                Geometry intersect = tgtGeometry.intersection(slvGeometry);
                for (Coordinate c : intersect.getCoordinates()) {
                    CreateStackOp.getPixelPos((float)c.y, (float)c.x, slvGeoCoding, slvPixelPos);
                    if (!slvPixelPos.isValid() || !(slvPixelPos.x >= 0.0f) || !(slvPixelPos.x < (float)slvImageWidth) || !(slvPixelPos.y >= 0.0f) || !(slvPixelPos.y < (float)slvImageHeight)) continue;
                    CreateStackOp.getPixelPos((float)c.y, (float)c.x, targGeoCoding, tgtPixelPos);
                    if (!tgtPixelPos.isValid() || !(tgtPixelPos.x >= 0.0f) || !(tgtPixelPos.x < (float)targImageWidth) || !(tgtPixelPos.y >= 0.0f) || !(tgtPixelPos.y < (float)targImageHeight)) continue;
                    this.addOffset(slvProd, (int)slvPixelPos.x - (int)tgtPixelPos.x, (int)slvPixelPos.y - (int)tgtPixelPos.y);
                    foundOverlapPoint = true;
                    break;
                }
            }
            if (foundOverlapPoint) continue;
            throw new OperatorException("Product " + slvProd.getName() + " has no overlap with master product.");
        }
    }

    private static boolean pixelPosValid(GeoCoding geoCoding, GeoPos geoPos, PixelPos pixelPos, int width, int height) {
        geoCoding.getPixelPos(geoPos, pixelPos);
        return pixelPos.isValid() && pixelPos.x >= 0.0f && pixelPos.x < (float)width && pixelPos.y >= 0.0f && pixelPos.y < (float)height;
    }

    private static void getPixelPos(float lat, float lon, GeoCoding srcGeoCoding, PixelPos pixelPos) {
        srcGeoCoding.getPixelPos(new GeoPos(lat, lon), pixelPos);
    }

    private void addOffset(Product slvProd, int offsetX, int offsetY) {
        this.slaveOffsettMap.put(slvProd, new int[]{offsetX, offsetY});
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block11: {
            try {
                Band sourceRaster = this.sourceRasterMap.get(targetBand);
                Product srcProduct = sourceRaster.getProduct();
                int srcImageWidth = srcProduct.getSceneRasterWidth();
                int srcImageHeight = srcProduct.getSceneRasterHeight();
                if (this.resamplingType.contains("NONE")) {
                    if (!this.productPixelSpacingChecked) {
                        this.checkProductPixelSpacings();
                    }
                    float noDataValue = (float)targetBand.getGeophysicalNoDataValue();
                    Rectangle targetRectangle = targetTile.getRectangle();
                    ProductData trgData = targetTile.getDataBuffer();
                    int tx0 = targetRectangle.x;
                    int ty0 = targetRectangle.y;
                    int tw = targetRectangle.width;
                    int th = targetRectangle.height;
                    int maxX = tx0 + tw;
                    int maxY = ty0 + th;
                    int[] offset = this.slaveOffsettMap.get(srcProduct);
                    int sx0 = Math.min(Math.max(0, tx0 + offset[0]), srcImageWidth - 1);
                    int sy0 = Math.min(Math.max(0, ty0 + offset[1]), srcImageHeight - 1);
                    int sw = Math.min(sx0 + tw - 1, srcImageWidth - 1) - sx0 + 1;
                    int sh = Math.min(sy0 + th - 1, srcImageHeight - 1) - sy0 + 1;
                    Rectangle srcRectangle = new Rectangle(sx0, sy0, sw, sh);
                    Tile srcTile = this.getSourceTile((RasterDataNode)sourceRaster, srcRectangle);
                    ProductData srcData = srcTile.getDataBuffer();
                    TileIndex trgIndex = new TileIndex(targetTile);
                    TileIndex srcIndex = new TileIndex(srcTile);
                    boolean isInt = false;
                    int trgDataType = trgData.getType();
                    if (trgDataType == srcData.getType() && (trgDataType == 11 || trgDataType == 12)) {
                        isInt = true;
                    }
                    for (int ty = ty0; ty < maxY; ++ty) {
                        int sy = ty + offset[1];
                        int trgOffset = trgIndex.calculateStride(ty);
                        if (sy < 0 || sy >= srcImageHeight) {
                            for (int tx = tx0; tx < maxX; ++tx) {
                                trgData.setElemDoubleAt(tx - trgOffset, (double)noDataValue);
                            }
                            continue;
                        }
                        int srcOffset = srcIndex.calculateStride(sy);
                        for (int tx = tx0; tx < maxX; ++tx) {
                            int sx = tx + offset[0];
                            if (sx < 0 || sx >= srcImageWidth) {
                                trgData.setElemDoubleAt(tx - trgOffset, (double)noDataValue);
                                continue;
                            }
                            if (isInt) {
                                trgData.setElemIntAt(tx - trgOffset, srcData.getElemIntAt(sx - srcOffset));
                                continue;
                            }
                            trgData.setElemDoubleAt(tx - trgOffset, srcData.getElemDoubleAt(sx - srcOffset));
                        }
                    }
                    break block11;
                }
                Collocator col = new Collocator(this, srcProduct, this.targetProduct, targetTile.getRectangle());
                col.collocateSourceBand((RasterDataNode)sourceRaster, targetTile, this.selectedResampling);
            }
            catch (Throwable e) {
                OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
            }
        }
    }

    private synchronized void checkProductPixelSpacings() throws OperatorException {
        if (this.productPixelSpacingChecked) {
            return;
        }
        this.productPixelSpacingChecked = true;
    }

    public static void checkPixelSpacing(Product[] sourceProducts) throws Exception {
        double savedRangeSpacing = 0.0;
        double savedAzimuthSpacing = 0.0;
        for (Product prod : sourceProducts) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)prod);
            if (absRoot == null) {
                throw new OperatorException(MessageFormat.format("Product ''{0}'' has no abstract metadata.", prod.getName()));
            }
            double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
            double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
            double a = Math.abs(rangeSpacing - savedRangeSpacing);
            double b = Math.abs(azimuthSpacing - savedAzimuthSpacing);
            if (savedRangeSpacing > 0.0 && savedAzimuthSpacing > 0.0 && (Math.abs(rangeSpacing - savedRangeSpacing) > 0.05 || Math.abs(azimuthSpacing - savedAzimuthSpacing) > 0.05)) {
                throw new OperatorException("Resampling type cannot be NONE because pixel spacings are different for master and slave products");
            }
            savedRangeSpacing = rangeSpacing;
            savedAzimuthSpacing = azimuthSpacing;
        }
    }

    protected void setTestParameters(String ext) {
        this.extent = ext;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CreateStackOp.class);
        }
    }
}

