/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.resamp.Resampling;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.FileElevationModel;
import org.esa.nest.gpf.CoarseRegistration;
import org.esa.nest.gpf.geometric.SARGeocoding;
import org.esa.nest.gpf.geometric.SARUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.datamodel.ProductInformation;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.StackUtils;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.gpf.ThreadManager;
import org.esa.snap.gpf.TileIndex;
import org.jlinda.core.Window;
import org.jlinda.core.delaunay.FastDelaunayTriangulator;
import org.jlinda.core.delaunay.Triangle;
import org.jlinda.core.delaunay.TriangulationException;

@OperatorMetadata(alias="DEM-Based-Coregistration", category="SAR Processing/Coregistration", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Create DEM Based Co-registrated Images", internal=true)
public class DEMBasedCoregistrationOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @Parameter(description="The list of master bands.", alias="masterBands", itemAlias="band", rasterDataNodeType=Band.class, label="Master Band")
    private String[] masterBandNames = null;
    @Parameter(description="The list of slave bands.", alias="slaveBands", itemAlias="band", rasterDataNodeType=Band.class, label="Slave Bands")
    private String[] slaveBandNames = null;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(valueSet={"ACE", "GETASSE30", "SRTM 3Sec", "ASTER 1sec GDEM"}, description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(valueSet={"NEAREST_NEIGHBOUR", "BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION", "BICUBIC_INTERPOLATION", "BISINC_5_POINT_INTERPOLATION"}, defaultValue="BICUBIC_INTERPOLATION", label="DEM Resampling Method")
    private String demResamplingMethod = "BICUBIC_INTERPOLATION";
    @Parameter(label="External DEM")
    private File externalDEMFile = null;
    @Parameter(label="DEM No Data Value", defaultValue="0")
    private double externalDEMNoDataValue = 0.0;
    @Parameter(valueSet={"BILINEAR_INTERPOLATION", "CUBIC_CONVOLUTION"}, defaultValue="BILINEAR_INTERPOLATION", description="The method to be used when resampling the slave grid onto the master grid.", label="Resampling Type")
    private String resamplingType = "BILINEAR_INTERPOLATION";
    private Resampling selectedResampling = null;
    private Product masterProduct = null;
    private Product slaveProduct = null;
    private ImageInfo masterInfo = null;
    private ImageInfo slaveInfo = null;
    private ElevationModel dem = null;
    private boolean isElevationModelAvailable = false;
    private float demNoDataValue = 0.0f;
    private int polyDegree = 2;
    private int numGCPs = 20;
    private int rowUpSamplingFactor = 4;
    private int colUpSamplingFactor = 4;
    private int cWindowWidth = 128;
    private int cWindowHeight = 128;
    private int cHalfWindowWidth = 0;
    private int cHalfWindowHeight = 0;
    private int maxIteration = 10;
    private double gcpTolerance = 0.5;
    private boolean isBiasAvailable = false;
    private double azBias = 0.0;
    private double rgBias = 0.0;
    private double noDataValue = -9999.0;

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            if (this.sourceProduct.length != 2) {
                throw new OperatorException("Please select two source products");
            }
            this.cHalfWindowWidth = this.cWindowWidth / 2;
            this.cHalfWindowHeight = this.cWindowHeight / 2;
            this.masterProduct = this.sourceProduct[0];
            this.masterInfo = new ImageInfo(this.masterProduct, this.polyDegree);
            this.masterBandNames = this.masterProduct.getBandNames();
            this.slaveProduct = this.sourceProduct[1];
            this.slaveInfo = new ImageInfo(this.slaveProduct, this.polyDegree);
            this.slaveBandNames = this.slaveProduct.getBandNames();
            if (this.externalDEMFile == null) {
                DEMFactory.checkIfDEMInstalled((String)this.demName);
            }
            DEMFactory.validateDEM((String)this.demName, (Product)this.masterProduct);
            this.selectedResampling = ResamplingFactory.createResampling((String)this.resamplingType);
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        if (this.dem != null) {
            this.dem.dispose();
            this.dem = null;
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.masterProduct.getName(), this.masterProduct.getProductType(), this.masterProduct.getSceneRasterWidth(), this.masterProduct.getSceneRasterHeight());
        String suffix = "_mst" + StackUtils.getBandTimeStamp((Product)this.masterProduct);
        for (String bandName : this.masterBandNames) {
            ProductUtils.copyBand((String)bandName, (Product)this.masterProduct, (String)(bandName + suffix), (Product)this.targetProduct, (boolean)true);
        }
        suffix = "_slv1" + StackUtils.getBandTimeStamp((Product)this.slaveProduct);
        for (String bandName : this.slaveBandNames) {
            Band band = this.slaveProduct.getBand(bandName);
            Band targetBand = new Band(bandName + suffix, band.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
            targetBand.setUnit(band.getUnit());
            this.targetProduct.addBand(targetBand);
        }
        ProductUtils.copyProductNodes((Product)this.masterProduct, (Product)this.targetProduct);
        this.copySlaveMetadata();
        this.updateTargetProductMetadata();
    }

    private void copySlaveMetadata() {
        MetadataElement targetSlaveMetadataRoot = AbstractMetadata.getSlaveMetadata((MetadataElement)this.targetProduct.getMetadataRoot());
        MetadataElement slvAbsMetadata = AbstractMetadata.getAbstractedMetadata((Product)this.slaveProduct);
        if (slvAbsMetadata != null) {
            String timeStamp = StackUtils.getBandTimeStamp((Product)this.slaveProduct);
            MetadataElement targetSlaveMetadata = new MetadataElement(this.slaveProduct.getName() + timeStamp);
            targetSlaveMetadataRoot.addElement(targetSlaveMetadata);
            ProductUtils.copyMetadata((MetadataElement)slvAbsMetadata, (MetadataElement)targetSlaveMetadata);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataAttribute[] slvInputProductAttrbList;
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
        MetadataElement inputElem = ProductInformation.getInputProducts((Product)this.targetProduct);
        MetadataElement slvInputElem = ProductInformation.getInputProducts((Product)this.slaveProduct);
        for (MetadataAttribute attrib : slvInputProductAttrbList = slvInputElem.getAttributes()) {
            MetadataAttribute inputAttrb = AbstractMetadata.addAbstractedAttribute((MetadataElement)inputElem, (String)"InputProduct", (int)41, (String)"", (String)"");
            inputAttrb.getData().setElems((Object)attrib.getData().getElemString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        try {
            if (!this.isElevationModelAvailable) {
                this.getElevationModel();
            }
            if (!this.isBiasAvailable) {
                this.estimateBias();
            }
            double[][] firstTermInAzShift = new double[h][w];
            double[][] firstTermInRgShift = new double[h][w];
            this.computeFirstTermInAzRgShifts(x0, xMax, y0, yMax, firstTermInAzShift, firstTermInRgShift);
            PixelPos[] slavePixPos = new PixelPos[h * w];
            this.computeAzRgShifts(x0, xMax, y0, yMax, firstTermInAzShift, firstTermInRgShift, slavePixPos);
            Rectangle sourceRectangle = DEMBasedCoregistrationOp.getBoundingBox(slavePixPos, this.slaveProduct.getSceneRasterWidth(), this.slaveProduct.getSceneRasterHeight());
            if (sourceRectangle == null) {
                return;
            }
            String suffix = "_slv1" + StackUtils.getBandTimeStamp((Product)this.slaveProduct);
            for (String bandName : this.slaveBandNames) {
                Band targetBand = this.targetProduct.getBand(bandName + suffix);
                Tile targetTile = targetTileMap.get(targetBand);
                this.resampleSourceBand((RasterDataNode)this.slaveProduct.getBand(bandName), sourceRectangle, slavePixPos, targetTile, this.selectedResampling);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void getElevationModel() throws Exception {
        if (this.isElevationModelAvailable) {
            return;
        }
        try {
            if (this.externalDEMFile != null) {
                this.dem = new FileElevationModel(this.externalDEMFile, this.demResamplingMethod, Float.valueOf((float)this.externalDEMNoDataValue));
                this.demNoDataValue = (float)this.externalDEMNoDataValue;
                this.demName = this.externalDEMFile.getPath();
            } else {
                this.dem = DEMFactory.createElevationModel((String)this.demName, (String)this.demResamplingMethod);
                this.demNoDataValue = this.dem.getDescriptor().getNoDataValue();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.isElevationModelAvailable = true;
    }

    private synchronized void estimateBias() throws Exception {
        if (this.isBiasAvailable) {
            return;
        }
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)this.masterProduct, (Dimension)tileSize, (int)0);
        int numRandomTiles = Math.min(this.numGCPs, tileRectangles.length);
        final GeoCoding mGeoCoding = this.masterProduct.getGeoCoding();
        final GeoCoding sGeoCoding = this.slaveProduct.getGeoCoding();
        Rectangle[] randomTileArray = this.getRandomTiles(numRandomTiles, tileRectangles, mGeoCoding, sGeoCoding);
        final Band masterBand = this.getAmplitudeOrIntensityBand(this.masterProduct);
        final Band slaveBand = this.getAmplitudeOrIntensityBand(this.slaveProduct);
        StatusProgressMonitor status = new StatusProgressMonitor((float)numRandomTiles, "Estimating bias in azimuth and range shifts... ");
        int tileCnt = 0;
        ThreadManager threadManager = new ThreadManager();
        try {
            final ArrayList azBiasArray = new ArrayList(numRandomTiles);
            final ArrayList rgBiasArray = new ArrayList(numRandomTiles);
            for (final Rectangle tileRectangle : randomTileArray) {
                this.checkForCancellation();
                Thread worker = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                int x0 = tileRectangle.x;
                                int y0 = tileRectangle.y;
                                int w = tileRectangle.width;
                                int h = tileRectangle.height;
                                int xMax = x0 + w;
                                int yMax = y0 + h;
                                double[][] firstTermInAzShift = new double[h][w];
                                double[][] firstTermInRgShift = new double[h][w];
                                PixelPos mGCPPixelPos = new PixelPos((float)(x0 + w / 2), (float)(y0 + h / 2));
                                PixelPos sGCPPixelPos = new PixelPos();
                                double[] bias = new double[2];
                                DEMBasedCoregistrationOp.this.getSlaveGCPPixPos(mGeoCoding, sGeoCoding, mGCPPixelPos, sGCPPixelPos);
                                DEMBasedCoregistrationOp.this.computeFirstTermInAzRgShifts(x0, xMax, y0, yMax, firstTermInAzShift, firstTermInRgShift);
                                if (firstTermInAzShift[h / 2][w / 2] == DEMBasedCoregistrationOp.this.noDataValue || firstTermInRgShift[h / 2][w / 2] == DEMBasedCoregistrationOp.this.noDataValue) break block5;
                                DEMBasedCoregistrationOp.this.estimateBiasInAzRgShifts(x0, y0, w, h, masterBand, slaveBand, mGCPPixelPos, sGCPPixelPos, firstTermInAzShift, firstTermInRgShift, bias);
                                if (bias[0] == DEMBasedCoregistrationOp.this.noDataValue || bias[1] == DEMBasedCoregistrationOp.this.noDataValue) break block5;
                                List list = azBiasArray;
                                synchronized (list) {
                                    azBiasArray.add(bias[0]);
                                    rgBiasArray.add(bias[1]);
                                }
                            }
                            catch (Throwable e) {
                                OperatorUtils.catchOperatorException((String)"estimateBias", (Throwable)e);
                            }
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            double sumAzBias = 0.0;
            double sumRgBias = 0.0;
            for (int i = 0; i < azBiasArray.size(); ++i) {
                sumAzBias += ((Double)azBiasArray.get(i)).doubleValue();
                sumRgBias += ((Double)rgBiasArray.get(i)).doubleValue();
            }
            this.azBias = sumAzBias / (double)azBiasArray.size();
            this.rgBias = sumRgBias / (double)azBiasArray.size();
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"estimateBias", (Throwable)e);
        }
        this.isBiasAvailable = true;
    }

    private Rectangle[] getRandomTiles(int numRandomTiles, Rectangle[] tileRectangles, GeoCoding mGeoCoding, GeoCoding sGeoCoding) {
        ArrayList<Rectangle> validTileList = new ArrayList<Rectangle>();
        PixelPos sGCPPixelPos = new PixelPos();
        for (Rectangle rectangle : tileRectangles) {
            int xc = rectangle.x + rectangle.width / 2;
            int yc = rectangle.y + rectangle.height / 2;
            PixelPos mGCPPixelPos = new PixelPos((float)xc, (float)yc);
            if (!this.getSlaveGCPPixPos(mGeoCoding, sGeoCoding, mGCPPixelPos, sGCPPixelPos)) continue;
            validTileList.add(rectangle);
        }
        if (validTileList.size() < numRandomTiles) {
            throw new OperatorException("Cannot find " + numRandomTiles + " valid tiles for bis estimation.");
        }
        ArrayList<Rectangle> randomTileList = new ArrayList<Rectangle>(numRandomTiles);
        Random randomGenerator = new Random();
        int k = 0;
        while (k < numRandomTiles) {
            int randomInt = randomGenerator.nextInt(validTileList.size());
            Rectangle tileRectangle = (Rectangle)validTileList.get(randomInt);
            if (randomTileList.contains(tileRectangle)) continue;
            randomTileList.add(tileRectangle);
            ++k;
        }
        return randomTileList.toArray(new Rectangle[randomTileList.size()]);
    }

    private boolean getSlaveGCPPixPos(GeoCoding masterGeoCoding, GeoCoding slaveGeoCoding, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        GeoPos mGCPGeoPos = new GeoPos();
        masterGeoCoding.getGeoPos(mGCPPixelPos, mGCPGeoPos);
        slaveGeoCoding.getPixelPos(mGCPGeoPos, sGCPPixelPos);
        return sGCPPixelPos.x - (float)this.cHalfWindowWidth + 1.0f >= 0.0f && sGCPPixelPos.x + (float)this.cHalfWindowWidth <= (float)(this.slaveInfo.sourceImageWidth - 1) && sGCPPixelPos.y - (float)this.cHalfWindowHeight + 1.0f >= 0.0f && sGCPPixelPos.y + (float)this.cHalfWindowHeight <= (float)(this.slaveInfo.sourceImageHeight - 1);
    }

    private Band getAmplitudeOrIntensityBand(Product sourceProduct) {
        Band[] masterBands;
        for (Band band : masterBands = sourceProduct.getBands()) {
            if (!band.getUnit().contains("amplitude") && !band.getUnit().contains("intensity")) continue;
            return band;
        }
        return null;
    }

    private void estimateBiasInAzRgShifts(int x0, int y0, int w, int h, Band mBand, Band sBand, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos, double[][] firstTermInAzShift, double[][] firstTermInRgShift, double[] bias) {
        ProductData sData;
        if (mBand == null || sBand == null) {
            throw new OperatorException("Cannot find valid master or slave band for bias estimation.");
        }
        Rectangle mRectangle = new Rectangle(x0, y0, w, h);
        Rectangle sRectangle = new Rectangle(Math.max(0, (int)sGCPPixelPos.x - w / 2), Math.max(0, (int)sGCPPixelPos.y - h / 2), w, h);
        Tile mTile = this.getSourceTile((RasterDataNode)mBand, mRectangle);
        Tile sTile = this.getSourceTile((RasterDataNode)sBand, sRectangle);
        ProductData mData = mTile.getDataBuffer();
        CoarseRegistration coarseRegistration = new CoarseRegistration(this.cWindowWidth, this.cWindowHeight, this.rowUpSamplingFactor, this.colUpSamplingFactor, this.maxIteration, this.gcpTolerance, mTile, mData, sTile, sData = sTile.getDataBuffer(), this.slaveProduct.getSceneRasterWidth(), this.slaveProduct.getSceneRasterHeight());
        if (coarseRegistration.getCoarseSlaveGCPPosition(mGCPPixelPos, sGCPPixelPos)) {
            double estimatedAzShift = sGCPPixelPos.getY() - mGCPPixelPos.getY();
            double estimatedRgShift = sGCPPixelPos.getX() - mGCPPixelPos.getX();
            System.out.println("estimatedAzShift = " + estimatedAzShift + ", estimatedRgShift = " + estimatedRgShift);
            int mx = (int)mGCPPixelPos.x - x0;
            int my = (int)mGCPPixelPos.y - y0;
            bias[0] = estimatedAzShift - firstTermInAzShift[my][mx];
            bias[1] = estimatedRgShift - firstTermInRgShift[my][mx];
        } else {
            bias[0] = this.noDataValue;
            bias[1] = this.noDataValue;
        }
    }

    private void computeFirstTermInAzRgShifts(int x0, int xMax, int y0, int yMax, double[][] firstTermInAzShift, double[][] firstTermInRgShift) throws Exception {
        try {
            double[] latLonMinMax = new double[4];
            this.computeImageGeoBoundary(x0, xMax, y0, yMax, this.masterProduct, latLonMinMax);
            double delta = (double)this.dem.getDescriptor().getDegreeRes() / (double)this.dem.getDescriptor().getPixelRes();
            double extralat = 1.5 * delta + 0.16;
            double extralon = 1.5 * delta + 0.16;
            double latMin = latLonMinMax[0] - extralat;
            double latMax = latLonMinMax[1] + extralat;
            double lonMin = latLonMinMax[2] - extralon;
            double lonMax = latLonMinMax[3] + extralon;
            PixelPos upperLeft = this.dem.getIndex(new GeoPos((float)latMax, (float)lonMin));
            PixelPos lowerRight = this.dem.getIndex(new GeoPos((float)latMin, (float)lonMax));
            int latMaxIdx = (int)Math.floor(upperLeft.getY());
            int latMinIdx = (int)Math.ceil(lowerRight.getY());
            int lonMinIdx = (int)Math.floor(upperLeft.getX());
            int lonMaxIdx = (int)Math.ceil(lowerRight.getX());
            int numLines = latMinIdx - latMaxIdx + 1;
            int numPixels = lonMaxIdx - lonMinIdx;
            double[][] azIn = new double[numLines][numPixels];
            double[][] rgIn = new double[numLines][numPixels];
            double[][] rgOffset = new double[numLines][numPixels];
            double[][] azOffset = new double[numLines][numPixels];
            PositionData masterPosData = new PositionData();
            PositionData slavePosData = new PositionData();
            for (int l = 0; l < numLines; ++l) {
                for (int p = 0; p < numPixels; ++p) {
                    GeoPos gp = this.dem.getGeoPos(new PixelPos((float)(lonMinIdx + p), (float)(latMaxIdx + l)));
                    double lat = gp.lat;
                    double lon = gp.lon;
                    double alt = this.dem.getElevation(gp);
                    if (alt == (double)this.demNoDataValue || !this.getPosition(lat, lon, alt, this.masterInfo, masterPosData) || !this.getPosition(lat, lon, alt, this.slaveInfo, slavePosData)) {
                        azIn[l][p] = this.noDataValue;
                        rgIn[l][p] = this.noDataValue;
                        continue;
                    }
                    azIn[l][p] = masterPosData.azimuthIndex;
                    rgIn[l][p] = masterPosData.rangeIndex;
                    azOffset[l][p] = this.slaveInfo.prf * slavePosData.azimuthTime - this.masterInfo.prf * masterPosData.azimuthTime;
                    rgOffset[l][p] = this.slaveInfo.samplingRate * slavePosData.slantRangeTime - this.masterInfo.samplingRate * masterPosData.slantRangeTime;
                }
            }
            Window tileWindow = new Window((long)y0, (long)(yMax - 1), (long)x0, (long)(xMax - 1));
            double rgAzRatio = this.masterInfo.rangeSpacing / this.masterInfo.azimuthSpacing;
            double[][] azOffsetArray = TriangleUtils.gridDataLinear(azIn, rgIn, azOffset, tileWindow, rgAzRatio, 1, 1, this.noDataValue, 0);
            double[][] rgOffsetArray = TriangleUtils.gridDataLinear(azIn, rgIn, rgOffset, tileWindow, rgAzRatio, 1, 1, this.noDataValue, 0);
            for (int i = 0; i < azOffsetArray.length; ++i) {
                firstTermInAzShift[i] = (double[])azOffsetArray[i].clone();
                firstTermInRgShift[i] = (double[])rgOffsetArray[i].clone();
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeFirstTermInAzRgShifts", (Throwable)e);
        }
    }

    private void computeAzRgShifts(int x0, int xMax, int y0, int yMax, double[][] firstTermInAzShift, double[][] firstTermInRgShift, PixelPos[] slavePixPos) {
        int index = 0;
        for (int y = y0; y < yMax; ++y) {
            int yy = y - y0;
            for (int x = x0; x < xMax; ++x) {
                int xx = x - x0;
                if (firstTermInAzShift[yy][xx] == this.noDataValue || firstTermInRgShift[yy][xx] == this.noDataValue) {
                    slavePixPos[index++] = null;
                    continue;
                }
                double azShift = firstTermInAzShift[yy][xx] + this.azBias;
                double rgShift = firstTermInRgShift[yy][xx] + this.rgBias;
                slavePixPos[index++] = new PixelPos((float)((double)x + rgShift), (float)((double)y + azShift));
            }
        }
    }

    private void computeImageGeoBoundary(int xmin, int xmax, int ymin, int ymax, Product sourceProduct, double[] latLonMinMax) throws Exception {
        GeoCoding geoCoding = sourceProduct.getGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("Product does not contain a geocoding");
        }
        GeoPos geoPosFirstNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymin), null);
        GeoPos geoPosFirstFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymin), null);
        GeoPos geoPosLastNear = geoCoding.getGeoPos(new PixelPos((float)xmin, (float)ymax), null);
        GeoPos geoPosLastFar = geoCoding.getGeoPos(new PixelPos((float)xmax, (float)ymax), null);
        double[] lats = new double[]{geoPosFirstNear.getLat(), geoPosFirstFar.getLat(), geoPosLastNear.getLat(), geoPosLastFar.getLat()};
        double[] lons = new double[]{geoPosFirstNear.getLon(), geoPosFirstFar.getLon(), geoPosLastNear.getLon(), geoPosLastFar.getLon()};
        double latMin = 90.0;
        double latMax = -90.0;
        for (double lat : lats) {
            if (lat < latMin) {
                latMin = lat;
            }
            if (!(lat > latMax)) continue;
            latMax = lat;
        }
        double lonMin = 180.0;
        double lonMax = -180.0;
        for (double lon : lons) {
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (!(lon > lonMax)) continue;
            lonMax = lon;
        }
        latLonMinMax[0] = latMin;
        latLonMinMax[1] = latMax;
        latLonMinMax[2] = lonMin;
        latLonMinMax[3] = lonMax;
    }

    private boolean getPosition(double lat, double lon, double alt, ImageInfo imageInfo, PositionData data) {
        GeoUtils.geo2xyzWGS84((double)lat, (double)lon, (double)alt, (double[])data.earthPoint);
        double zeroDopplerTime = SARGeocoding.getZeroDopplerTime(imageInfo.firstLineUTC, imageInfo.lineTimeInterval, imageInfo.wavelength, data.earthPoint, imageInfo.orbit);
        if (zeroDopplerTime == -99999.0) {
            return false;
        }
        data.azimuthTime = zeroDopplerTime * 86400.0;
        data.azimuthIndex = (zeroDopplerTime - imageInfo.firstLineUTC) / imageInfo.lineTimeInterval;
        double slantRange = SARGeocoding.computeSlantRange(zeroDopplerTime, imageInfo.orbit, data.earthPoint, data.sensorPos);
        data.slantRangeTime = slantRange / 2.99792458E8;
        data.rangeIndex = !imageInfo.srgrFlag ? (slantRange - imageInfo.nearEdgeSlantRange) / imageInfo.rangeSpacing : SARGeocoding.computeRangeIndex(imageInfo.srgrFlag, imageInfo.sourceImageWidth, imageInfo.firstLineUTC, imageInfo.lastLineUTC, imageInfo.rangeSpacing, zeroDopplerTime, slantRange, imageInfo.nearEdgeSlantRange, imageInfo.srgrConvParams);
        if (!imageInfo.nearRangeOnLeft) {
            data.rangeIndex = (double)(imageInfo.sourceImageWidth - 1) - data.rangeIndex;
        }
        return true;
    }

    private double computeRangeAzimuthSpacingRatio(int w, int h, double[] latLonMinMax) throws Exception {
        double latMin = latLonMinMax[0];
        double latMax = latLonMinMax[1];
        double lonMin = latLonMinMax[2];
        double lonMax = latLonMinMax[3];
        double[] uL = new double[3];
        double[] uR = new double[3];
        double[] lL = new double[3];
        double[] lR = new double[3];
        GeoUtils.geo2xyzWGS84((double)latMax, (double)lonMin, (double)0.0, (double[])uL);
        GeoUtils.geo2xyzWGS84((double)latMax, (double)lonMax, (double)0.0, (double[])uR);
        GeoUtils.geo2xyzWGS84((double)latMin, (double)lonMin, (double)0.0, (double[])lL);
        GeoUtils.geo2xyzWGS84((double)latMin, (double)lonMax, (double)0.0, (double[])lR);
        double rangeSpacing = (this.norm(uL, uR) + this.norm(lL, lR)) / 2.0 / (double)(w - 1);
        double aziSpacing = (this.norm(uL, lL) + this.norm(uR, lR)) / 2.0 / (double)(h - 1);
        return rangeSpacing / aziSpacing;
    }

    private double norm(double[] p1, double[] p2) {
        return Math.sqrt((p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1]) + (p1[2] - p2[2]) * (p1[2] - p2[2]));
    }

    private static Rectangle getBoundingBox(PixelPos[] slavePixPos, int maxWidth, int maxHeight) {
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        for (PixelPos pixelsPos : slavePixPos) {
            if (pixelsPos == null) continue;
            int x = (int)Math.floor(pixelsPos.getX());
            int y = (int)Math.floor(pixelsPos.getY());
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        if (minX > maxX || minY > maxY) {
            return null;
        }
        minX = Math.max(minX - 4, 0);
        maxX = Math.min(maxX + 4, maxWidth - 1);
        minY = Math.max(minY - 4, 0);
        maxY = Math.min(maxY + 4, maxHeight - 1);
        return new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    public void resampleSourceBand(RasterDataNode sourceBand, Rectangle sourceRectangle, PixelPos[] slavePixPos, Tile targetTile, Resampling resampling) throws OperatorException {
        RasterDataNode targetBand = targetTile.getRasterDataNode();
        Rectangle targetRectangle = targetTile.getRectangle();
        ProductData trgBuffer = targetTile.getDataBuffer();
        float noDataValue = (float)targetBand.getGeophysicalNoDataValue();
        int tx0 = targetRectangle.x;
        int ty0 = targetRectangle.y;
        int txMax = tx0 + targetRectangle.width;
        int tyMax = ty0 + targetRectangle.height;
        Tile sourceTile = null;
        if (sourceRectangle != null) {
            sourceTile = this.getSourceTile(sourceBand, sourceRectangle);
        }
        if (sourceTile != null) {
            Product srcProduct = sourceBand.getProduct();
            int sourceRasterHeight = srcProduct.getSceneRasterHeight();
            int sourceRasterWidth = srcProduct.getSceneRasterWidth();
            Resampling.Index resamplingIndex = resampling.createIndex();
            ResamplingRaster resamplingRaster = new ResamplingRaster(sourceTile);
            int index = 0;
            for (int y = ty0; y < tyMax; ++y) {
                for (int x = tx0; x < txMax; ++x) {
                    PixelPos slavePixelPos;
                    int trgIndex = targetTile.getDataBufferIndex(x, y);
                    if (this.isSlavePixPosValid(slavePixelPos = slavePixPos[index++])) {
                        try {
                            resampling.computeIndex((double)slavePixelPos.x, (double)slavePixelPos.y, sourceRasterWidth, sourceRasterHeight, resamplingIndex);
                            double sample = resampling.resample((Resampling.Raster)resamplingRaster, resamplingIndex);
                            if (Double.isNaN(sample)) {
                                sample = noDataValue;
                            }
                            trgBuffer.setElemDoubleAt(trgIndex, sample);
                            continue;
                        }
                        catch (Exception e) {
                            throw new OperatorException(e.getMessage());
                        }
                    }
                    trgBuffer.setElemDoubleAt(trgIndex, (double)noDataValue);
                }
            }
            sourceTile.getDataBuffer().dispose();
        } else {
            TileIndex trgIndex = new TileIndex(targetTile);
            for (int y = ty0; y < tyMax; ++y) {
                trgIndex.calculateStride(y);
                for (int x = tx0; x < txMax; ++x) {
                    trgBuffer.setElemDoubleAt(trgIndex.getIndex(x), (double)noDataValue);
                }
            }
        }
    }

    private boolean isSlavePixPosValid(PixelPos slavePixPos) {
        return slavePixPos != null && slavePixPos.x >= 0.0f && slavePixPos.x < (float)this.slaveInfo.sourceImageWidth && slavePixPos.y >= 0.0f && slavePixPos.y < (float)this.slaveInfo.sourceImageHeight;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DEMBasedCoregistrationOp.class);
        }
    }

    private static class TriangleUtils {
        private TriangleUtils() {
        }

        public static double[][] gridDataLinear(double[][] x_in, double[][] y_in, double[][] z_in, Window window, double xyRatio, int xScale, int yScale, double nodata, int offset) throws Exception {
            FastDelaunayTriangulator FDT = TriangleUtils.triangulate(x_in, y_in, z_in, xyRatio, nodata);
            return TriangleUtils.interpolate(xyRatio, window, xScale, yScale, offset, nodata, FDT);
        }

        private static FastDelaunayTriangulator triangulate(double[][] x_in, double[][] y_in, double[][] z_in, double xyRatio, double nodata) throws Exception {
            ArrayList<Point> list = new ArrayList<Point>();
            GeometryFactory gf = new GeometryFactory();
            for (int i = 0; i < x_in.length; ++i) {
                for (int j = 0; j < x_in[0].length; ++j) {
                    if (x_in[i][j] == nodata || y_in[i][j] == nodata) continue;
                    list.add(gf.createPoint(new Coordinate(x_in[i][j], y_in[i][j] * xyRatio, z_in[i][j])));
                }
            }
            FastDelaunayTriangulator FDT = new FastDelaunayTriangulator();
            try {
                FDT.triangulate(list.iterator());
            }
            catch (TriangulationException te) {
                te.printStackTrace();
            }
            return FDT;
        }

        private static double[][] interpolate(double xyRatio, Window tileWindow, double xScale, double yScale, double offset, double nodata, FastDelaunayTriangulator FDT) {
            boolean zLoops = true;
            double x_min = tileWindow.linelo;
            double y_min = tileWindow.pixlo;
            double[] a = new double[1];
            double[] b = new double[1];
            double[] c = new double[1];
            double[] vx = new double[4];
            double[] vy = new double[4];
            double[][] griddedData = new double[(int)tileWindow.lines()][(int)tileWindow.pixels()];
            int nx = griddedData.length / 1;
            int ny = griddedData[0].length;
            for (double[] aGriddedData : griddedData) {
                Arrays.fill(aGriddedData, nodata);
            }
            long t4 = System.currentTimeMillis();
            for (Triangle triangle : FDT.triangles) {
                int zLoop;
                vx[0] = vx[3] = triangle.getA().x;
                vy[0] = vy[3] = triangle.getA().y / xyRatio;
                vx[1] = triangle.getB().x;
                vy[1] = triangle.getB().y / xyRatio;
                vx[2] = triangle.getC().x;
                vy[2] = triangle.getC().y / xyRatio;
                if (vx[0] == nodata || vx[1] == nodata || vx[2] == nodata || vy[0] == nodata || vy[1] == nodata || vy[2] == nodata) continue;
                double xp = Math.min(Math.min(vx[0], vx[1]), vx[2]);
                long i_min = TriangleUtils.coordToIndex(xp, x_min, xScale, offset);
                xp = Math.max(Math.max(vx[0], vx[1]), vx[2]);
                long i_max = TriangleUtils.coordToIndex(xp, x_min, xScale, offset);
                double yp = Math.min(Math.min(vy[0], vy[1]), vy[2]);
                long j_min = TriangleUtils.coordToIndex(yp, y_min, yScale, offset);
                yp = Math.max(Math.max(vy[0], vy[1]), vy[2]);
                long j_max = TriangleUtils.coordToIndex(yp, y_min, yScale, offset);
                if (i_max < 0L || i_min >= (long)nx || j_max < 0L || j_min >= (long)ny) continue;
                if (i_min < 0L) {
                    i_min = 0L;
                }
                if (i_max >= (long)nx) {
                    i_max = nx - 1;
                }
                if (j_min < 0L) {
                    j_min = 0L;
                }
                if (j_max >= (long)ny) {
                    j_max = ny - 1;
                }
                double xkj = vx[1] - vx[0];
                double ykj = vy[1] - vy[0];
                double xlj = vx[2] - vx[0];
                double ylj = vy[2] - vy[0];
                double f = 1.0 / (xkj * ylj - ykj * xlj);
                for (zLoop = 0; zLoop < 1; ++zLoop) {
                    double zj = triangle.getA().z;
                    double zk = triangle.getB().z;
                    double zl = triangle.getC().z;
                    double zkj = zk - zj;
                    double zlj = zl - zj;
                    a[zLoop] = -f * (ykj * zlj - zkj * ylj);
                    b[zLoop] = -f * (zkj * xlj - xkj * zlj);
                    c[zLoop] = -a[zLoop] * vx[1] - b[zLoop] * vy[1] + zk;
                }
                int i = (int)i_min;
                while ((long)i <= i_max) {
                    xp = TriangleUtils.indexToCoord(i, x_min, xScale, offset);
                    int j = (int)j_min;
                    while ((long)j <= j_max) {
                        yp = TriangleUtils.indexToCoord(j, y_min, yScale, offset);
                        if (TriangleUtils.pointInTriangle(vx, vy, xp, yp)) {
                            for (zLoop = 0; zLoop < 1; ++zLoop) {
                                griddedData[i][j] = a[zLoop] * xp + b[zLoop] * yp + c[zLoop];
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            long t5 = System.currentTimeMillis();
            return griddedData;
        }

        private static boolean pointInTriangle(double[] xt, double[] yt, double x, double y) {
            int iRet0 = (xt[2] - xt[0]) * (y - yt[0]) > (x - xt[0]) * (yt[2] - yt[0]) ? 1 : -1;
            int iRet1 = (xt[0] - xt[1]) * (y - yt[1]) > (x - xt[1]) * (yt[0] - yt[1]) ? 1 : -1;
            int iRet2 = (xt[1] - xt[2]) * (y - yt[2]) > (x - xt[2]) * (yt[1] - yt[2]) ? 1 : -1;
            return iRet0 > 0 && iRet1 > 0 && iRet2 > 0 || iRet0 < 0 && iRet1 < 0 && iRet2 < 0;
        }

        private static long coordToIndex(double coord, double coord0, double deltaCoord, double offset) {
            return TriangleUtils.irint((coord - coord0) / deltaCoord - offset);
        }

        private static double indexToCoord(long idx, double coord0, double deltaCoord, double offset) {
            return coord0 + (double)idx * deltaCoord + offset;
        }

        private static long irint(double coord) {
            return (long)TriangleUtils.rint(coord);
        }

        private static double rint(double coord) {
            return Math.floor(coord + 0.5);
        }
    }

    private static class ResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;
        private final boolean usesNoData;
        private final boolean scalingApplied;
        private final double noDataValue;
        private final double geophysicalNoDataValue;
        private final ProductData dataBuffer;

        public ResamplingRaster(Tile tile) {
            this.tile = tile;
            this.dataBuffer = tile.getDataBuffer();
            RasterDataNode rasterDataNode = tile.getRasterDataNode();
            this.usesNoData = rasterDataNode.isNoDataValueUsed();
            this.noDataValue = rasterDataNode.getNoDataValue();
            this.geophysicalNoDataValue = rasterDataNode.getGeophysicalNoDataValue();
            this.scalingApplied = rasterDataNode.isScalingApplied();
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) throws Exception {
            boolean allValid = true;
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    samples[i][j] = this.dataBuffer.getElemDoubleAt(this.tile.getDataBufferIndex(x[j], y[i]));
                    if (!this.usesNoData || (!this.scalingApplied || this.geophysicalNoDataValue != samples[i][j]) && this.noDataValue != samples[i][j]) continue;
                    samples[i][j] = Double.NaN;
                    allValid = false;
                }
            }
            return allValid;
        }
    }

    private static class PositionData {
        final double[] earthPoint = new double[3];
        final double[] sensorPos = new double[3];
        double azimuthIndex;
        double rangeIndex;
        double azimuthTime;
        double slantRangeTime;

        private PositionData() {
        }
    }

    private static class ImageInfo {
        public SARGeocoding.Orbit orbit = null;
        public double firstLineUTC = 0.0;
        public double lastLineUTC = 0.0;
        public double lineTimeInterval = 0.0;
        public double prf = 0.0;
        public double samplingRate = 0.0;
        public double nearEdgeSlantRange = 0.0;
        public double wavelength = 0.0;
        public double rangeSpacing = 0.0;
        public double azimuthSpacing = 0.0;
        public int sourceImageWidth = 0;
        public int sourceImageHeight = 0;
        public boolean nearRangeOnLeft = true;
        public boolean srgrFlag = false;
        public AbstractMetadata.SRGRCoefficientList[] srgrConvParams = null;

        public ImageInfo(Product sourceProduct, int polyDegree) throws Exception {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
            this.srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"srgr_flag");
            this.wavelength = SARUtils.getRadarFrequency(absRoot);
            this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
            this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
            this.firstLineUTC = absRoot.getAttributeUTC("first_line_time").getMJD();
            this.lastLineUTC = absRoot.getAttributeUTC("last_line_time").getMJD();
            this.lineTimeInterval = absRoot.getAttributeDouble("line_time_interval") / 86400.0;
            this.prf = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"pulse_repetition_frequency");
            this.samplingRate = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_sampling_rate") * 1000000.0;
            this.sourceImageWidth = sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = sourceProduct.getSceneRasterHeight();
            OrbitStateVector[] orbitStateVectors = AbstractMetadata.getOrbitStateVectors((MetadataElement)absRoot);
            this.orbit = new SARGeocoding.Orbit(orbitStateVectors, polyDegree, this.firstLineUTC, this.lineTimeInterval, this.sourceImageHeight);
            if (this.srgrFlag) {
                this.srgrConvParams = AbstractMetadata.getSRGRCoefficients((MetadataElement)absRoot);
            } else {
                this.nearEdgeSlantRange = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"slant_range_to_first_pixel");
            }
            TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)sourceProduct);
            this.nearRangeOnLeft = SARGeocoding.isNearRangeOnLeft(incidenceAngle, this.sourceImageWidth);
        }
    }
}

