/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dataio.dem.DEMFactory;
import org.esa.snap.gpf.OperatorUIUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class DEMBasedCoregistrationOpUI
extends BaseOperatorUI {
    private final JList mstBandList = new JList();
    private final JList slvBandList = new JList();
    private final JComboBox<String> demName = new JComboBox<String>(DEMFactory.getDEMNameList());
    private final JComboBox demResamplingMethod = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JComboBox resamplingType = new JComboBox<String>(ResamplingFactory.resamplingNames);
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("DEM No Data Value:");
    private static final String externalDEMStr = "External DEM";
    private Double extNoDataValue = 0.0;
    private final DialogUtils.TextAreaKeyListener textAreaKeyListener = new DialogUtils.TextAreaKeyListener();
    private final List<Integer> defaultMasterBandIndices = new ArrayList<Integer>(2);
    private final List<Integer> defaultSlaveBandIndices = new ArrayList<Integer>(2);
    private Product masterProduct = null;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.demName.addItem(externalDEMStr);
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (((String)DEMBasedCoregistrationOpUI.this.demName.getSelectedItem()).startsWith(DEMBasedCoregistrationOpUI.externalDEMStr)) {
                    DEMBasedCoregistrationOpUI.this.enableExternalDEM(true);
                } else {
                    DEMBasedCoregistrationOpUI.this.externalDEMFile.setText("");
                    DEMBasedCoregistrationOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(30);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = VisatApp.getApp().showFileOpenDialog("External DEM File", false, null);
                DEMBasedCoregistrationOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                DEMBasedCoregistrationOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                DEMBasedCoregistrationOpUI.this.externalDEMNoDataValue.setText(String.valueOf(DEMBasedCoregistrationOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMNoDataValue.addKeyListener((KeyListener)this.textAreaKeyListener);
        return new JScrollPane(panel);
    }

    public void initParameters() {
        String demNameParam = (String)this.paramMap.get("demName");
        if (demNameParam != null) {
            this.demName.setSelectedItem(DEMFactory.appendAutoDEM((String)demNameParam));
        }
        this.demResamplingMethod.setSelectedItem(this.paramMap.get("demResamplingMethod"));
        File extFile = (File)this.paramMap.get("externalDEMFile");
        if (extFile != null) {
            this.externalDEMFile.setText(extFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null && !this.textAreaKeyListener.isChangedByUser()) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
        }
        this.resamplingType.setSelectedItem(this.paramMap.get("resamplingType"));
    }

    private static List<Integer> getSelectedIndices(String[] allBandNames, String[] selBandNames, List<Integer> defaultIndices) {
        ArrayList<Integer> bandIndices = new ArrayList<Integer>(2);
        if (selBandNames != null && selBandNames.length > 0) {
            int i = 0;
            for (String bandName : allBandNames) {
                for (String selName : selBandNames) {
                    if (!bandName.equals(selName)) continue;
                    bandIndices.add(i);
                }
                ++i;
            }
        }
        if (bandIndices.isEmpty()) {
            return defaultIndices;
        }
        return bandIndices;
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
        this.paramMap.put("demResamplingMethod", this.demResamplingMethod.getSelectedItem());
        String extFileStr = this.externalDEMFile.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("externalDEMFile", new File(extFileStr));
            this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
        }
        this.paramMap.put("resamplingType", this.resamplingType.getSelectedItem());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile);
        gbc.gridx = 2;
        contentPane.add((Component)this.externalDEMBrowseButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"DEM Resampling Method:", (JComponent)this.demResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Type:", (JComponent)this.resamplingType);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void updateMasterSlaveSelections() {
        String[] bandNames = this.getBandNames();
        OperatorUIUtils.initParamList((JList)this.mstBandList, (String[])bandNames);
        OperatorUIUtils.initParamList((JList)this.slvBandList, (String[])bandNames);
        OperatorUIUtils.setSelectedListIndices((JList)this.mstBandList, DEMBasedCoregistrationOpUI.getSelectedIndices(bandNames, new String[0], this.defaultMasterBandIndices));
        OperatorUIUtils.setSelectedListIndices((JList)this.slvBandList, DEMBasedCoregistrationOpUI.getSelectedIndices(bandNames, new String[0], this.defaultSlaveBandIndices));
    }

    protected String[] getBandNames() {
        if (this.sourceProducts == null) {
            return new String[0];
        }
        if (this.masterProduct == null && this.sourceProducts.length > 0) {
            this.masterProduct = this.sourceProducts[0];
        }
        this.defaultMasterBandIndices.clear();
        this.defaultSlaveBandIndices.clear();
        if (this.sourceProducts.length > 1) {
            for (int i = 1; i < this.sourceProducts.length; ++i) {
                if (!this.sourceProducts[i].getDisplayName().equals(this.masterProduct.getDisplayName())) continue;
                this.masterProduct = null;
                return new String[0];
            }
        }
        ArrayList<String> bandNames = new ArrayList<String>(5);
        boolean masterBandsSelected = false;
        for (Product prod : this.sourceProducts) {
            if (this.sourceProducts.length > 1) {
                Band[] bands = prod.getBands();
                for (int i = 0; i < bands.length; ++i) {
                    Band band = bands[i];
                    bandNames.add(band.getName() + "::" + prod.getName());
                    int index = bandNames.size() - 1;
                    if (band instanceof VirtualBand) continue;
                    if (prod == this.masterProduct && !masterBandsSelected) {
                        Band qBand;
                        this.defaultMasterBandIndices.add(index);
                        if (band.getUnit() != null && band.getUnit().equals("real") && i + 1 < bands.length && (qBand = bands[i + 1]).getUnit() != null && qBand.getUnit().equals("imaginary")) {
                            this.defaultMasterBandIndices.add(index + 1);
                            bandNames.add(qBand.getName() + "::" + prod.getName());
                            ++i;
                        }
                        masterBandsSelected = true;
                        continue;
                    }
                    this.defaultSlaveBandIndices.add(index);
                }
                continue;
            }
            bandNames.addAll(Arrays.asList(prod.getBandNames()));
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        this.externalDEMBrowseButton.setVisible(flag);
    }
}

