/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import org.esa.nest.gpf.JointProbabilityState;
import org.esa.nest.gpf.ProbabilityState;

public abstract class Entropy {
    public static double LOG_BASE = 2.0;

    private Entropy() {
    }

    public static double calculateEntropy(double[] dataVector) {
        ProbabilityState state = new ProbabilityState(dataVector);
        double entropy = 0.0;
        entropy = state.probMap.values().stream().filter(prob -> prob > 0.0).map(prob -> prob * Math.log(prob)).reduce(entropy, (accumulator, _item) -> accumulator - _item);
        return entropy /= Math.log(LOG_BASE);
    }

    public static strictfp double calculateConditionalEntropy(double[] dataVector, double[] conditionVector) {
        JointProbabilityState state = new JointProbabilityState(dataVector, conditionVector);
        int numFirstStates = state.firstMaxVal;
        double condEntropy = 0.0;
        for (Integer key : state.jointProbMap.keySet()) {
            double jointValue = state.jointProbMap.get(key);
            double condValue = state.secondProbMap.get(key / numFirstStates);
            if (!(jointValue > 0.0) || !(condValue > 0.0)) continue;
            condEntropy -= jointValue * Math.log(jointValue / condValue);
        }
        return condEntropy /= Math.log(LOG_BASE);
    }

    public static double calculateJointEntropy(double[] firstVector, double[] secondVector) {
        JointProbabilityState state = new JointProbabilityState(firstVector, secondVector);
        double entropy = 0.0;
        entropy = state.jointProbMap.values().stream().filter(prob -> prob > 0.0).map(prob -> prob * Math.log(prob)).reduce(entropy, (accumulator, _item) -> accumulator - _item);
        return entropy /= Math.log(LOG_BASE);
    }
}

