/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;

public class GCPManager {
    private static GCPManager _instance = null;
    private final Map<String, ProductNodeGroup<Placemark>> bandGCPGroup = new HashMap<String, ProductNodeGroup<Placemark>>();

    private GCPManager() {
    }

    private String createKey(Band band) {
        return band.getProduct().getName() + '_' + band.getName();
    }

    public static GCPManager instance() {
        if (_instance == null) {
            _instance = new GCPManager();
        }
        return _instance;
    }

    public ProductNodeGroup<Placemark> getGcpGroup(Band band) {
        ProductNodeGroup gcpGroup = this.bandGCPGroup.get(this.createKey(band));
        if (gcpGroup == null) {
            gcpGroup = new ProductNodeGroup((ProductNode)band.getProduct(), "ground_control_points", true);
            this.bandGCPGroup.put(this.createKey(band), (ProductNodeGroup<Placemark>)gcpGroup);
        }
        return gcpGroup;
    }

    public void removeGcpGroup(Band band) {
        this.bandGCPGroup.remove(this.createKey(band));
    }

    public void removeAllGcpGroups() {
        this.bandGCPGroup.clear();
    }
}

