/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GcpDescriptor;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.resamp.ResamplingFactory;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.visat.toolviews.placemark.PlacemarkNameFactory;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.nest.dataio.dem.ElevationModelDescriptor;
import org.esa.nest.dataio.dem.ElevationModelRegistry;
import org.esa.nest.gpf.GCPManager;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.StackUtils;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.gpf.ThreadManager;
import org.esa.snap.gpf.TileIndex;
import org.esa.snap.util.MemUtils;

@OperatorMetadata(alias="GCP-Selection", category="SAR Processing/Coregistration", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Automatic Selection of Ground Control Points")
public class GCPSelectionOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The number of GCPs to use in a grid", interval="(10, *)", defaultValue="200", label="Number of GCPs")
    private int numGCPtoGenerate = 200;
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Coarse Registration Window Width")
    private String coarseRegistrationWindowWidth = "128";
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="128", label="Coarse Registration Window Height")
    private String coarseRegistrationWindowHeight = "128";
    @Parameter(valueSet={"2", "4", "8", "16"}, defaultValue="2", label="Row Interpolation Factor")
    private String rowInterpFactor = "2";
    @Parameter(valueSet={"2", "4", "8", "16"}, defaultValue="2", label="Column Interpolation Factor")
    private String columnInterpFactor = "2";
    @Parameter(description="The maximum number of iterations", interval="(1, 10]", defaultValue="10", label="Max Iterations")
    private int maxIteration = 10;
    @Parameter(description="Tolerance in slave GCP validation check", interval="(0, *)", defaultValue="0.5", label="GCP Tolerance")
    private double gcpTolerance = 0.5;
    @Parameter(defaultValue="true", label="Apply Fine Registration")
    private boolean applyFineRegistration = true;
    @Parameter(valueSet={"8", "16", "32", "64", "128", "256", "512"}, defaultValue="32", label="Fine Registration Window Width")
    private String fineRegistrationWindowWidth = "32";
    @Parameter(valueSet={"8", "16", "32", "64", "128", "256", "512"}, defaultValue="32", label="Fine Registration Window Height")
    private String fineRegistrationWindowHeight = "32";
    @Parameter(description="The coherence window size", interval="(1, 10]", defaultValue="3", label="Coherence Window Size")
    private int coherenceWindowSize = 3;
    @Parameter(description="The coherence threshold", interval="(0, *)", defaultValue="0.6", label="Coherence Threshold")
    private double coherenceThreshold = 0.6;
    @Parameter(description="Use sliding window for coherence calculation", defaultValue="false", label="Compute coherence with sliding window")
    private Boolean useSlidingWindow = false;
    private boolean useAllPolarimetricBands = false;
    private static final double coherenceFuncToler = 1.0E-5;
    private static final double coherenceValueToler = 0.01;
    @Parameter(defaultValue="false", label="Estimate Coarse Offset")
    private boolean computeOffset = false;
    @Parameter(defaultValue="false", label="Test GCPs are on land")
    private boolean onlyGCPsOnLand = false;
    private Band masterBand1 = null;
    private Band masterBand2 = null;
    private boolean complexCoregistration = false;
    private ProductNodeGroup<Placemark> masterGcpGroup = null;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private int cWindowWidth = 0;
    private int cWindowHeight = 0;
    private int rowUpSamplingFactor = 0;
    private int colUpSamplingFactor = 0;
    private int cHalfWindowWidth;
    private int cHalfWindowHeight;
    private int fWindowWidth = 0;
    private int fWindowHeight = 0;
    private static final int ITMAX = 200;
    private static final double TOL = 2.0E-4;
    private static final double GOLD = 1.618034;
    private static final double GLIMIT = 100.0;
    private static final double TINY = 1.0E-20;
    private static final double CGOLD = 0.381966;
    private static final double ZEPS = 1.0E-10;
    private static final double MaxInvalidPixelPercentage = 0.66;
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Band, Band> complexSrcMap = new HashMap<Band, Band>(10);
    private final Map<Band, Boolean> gcpsComputedMap = new HashMap<Band, Boolean>(10);
    private Band primarySlaveBand = null;
    private boolean collocatedStack = false;
    private ElevationModel dem = null;

    public void initialize() throws OperatorException {
        try {
            this.cWindowWidth = Integer.parseInt(this.coarseRegistrationWindowWidth);
            this.cWindowHeight = Integer.parseInt(this.coarseRegistrationWindowHeight);
            this.cHalfWindowWidth = this.cWindowWidth / 2;
            this.cHalfWindowHeight = this.cWindowHeight / 2;
            this.rowUpSamplingFactor = Integer.parseInt(this.rowInterpFactor);
            this.colUpSamplingFactor = Integer.parseInt(this.columnInterpFactor);
            double achievableAccuracy = 1.0 / (double)Math.max(this.rowUpSamplingFactor, this.colUpSamplingFactor);
            if (this.gcpTolerance < achievableAccuracy) {
                throw new OperatorException("The achievable accuracy with current interpolation factors is " + achievableAccuracy + ", GCP Tolerance is below it.");
            }
            this.masterBand1 = this.sourceProduct.getBandAt(0);
            if (this.masterBand1.getUnit() != null && this.masterBand1.getUnit().equals("real") && this.sourceProduct.getNumBands() > 1) {
                this.masterBand2 = this.sourceProduct.getBandAt(1);
                this.complexCoregistration = true;
            }
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.getCollocatedStackFlag();
            this.createTargetProduct();
            GCPManager.instance().removeAllGcpGroups();
            this.masterGcpGroup = GCPManager.instance().getGcpGroup(this.masterBand1);
            if (this.masterGcpGroup.getNodeCount() <= 0) {
                GCPSelectionOp.addGCPGrid(this.sourceImageWidth, this.sourceImageHeight, this.numGCPtoGenerate, this.masterGcpGroup, this.targetProduct.getGeoCoding());
            }
            if (this.complexCoregistration && this.applyFineRegistration) {
                this.fWindowWidth = Integer.parseInt(this.fineRegistrationWindowWidth);
                this.fWindowHeight = Integer.parseInt(this.fineRegistrationWindowHeight);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void addGCPGrid(int width, int height, int numPins, ProductNodeGroup<Placemark> group, GeoCoding targetGeoCoding) {
        float ratio = (float)width / (float)height;
        float n = (float)Math.sqrt((float)numPins / ratio);
        float m = ratio * n;
        float spacingX = (float)width / m;
        float spacingY = (float)height / n;
        GcpDescriptor gcpDescriptor = GcpDescriptor.getInstance();
        group.removeAll();
        int pinNumber = group.getNodeCount() + 1;
        for (float y = spacingY / 2.0f; y < (float)height; y += spacingY) {
            for (float x = spacingX / 2.0f; x < (float)width; x += spacingX) {
                String name = PlacemarkNameFactory.createName((PlacemarkDescriptor)gcpDescriptor, (int)pinNumber);
                String label = PlacemarkNameFactory.createLabel((PlacemarkDescriptor)gcpDescriptor, (int)pinNumber, (boolean)true);
                Placemark newPin = Placemark.createPointPlacemark((PlacemarkDescriptor)gcpDescriptor, (String)name, (String)label, (String)"", (PixelPos)new PixelPos((float)((int)x), (float)((int)y)), null, (GeoCoding)targetGeoCoding);
                group.add((ProductNode)newPin);
                ++pinNumber;
            }
        }
    }

    private void getCollocatedStackFlag() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        MetadataAttribute attr = absRoot.getAttribute("collocated_stack");
        if (attr == null) {
            this.collocatedStack = false;
        } else {
            this.collocatedStack = true;
            absRoot.removeAttribute(attr);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        String[] masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
        int numSrcBands = this.sourceProduct.getNumBands();
        boolean oneSlaveProcessed = false;
        for (int i = 0; i < numSrcBands; ++i) {
            Band srcBand = this.sourceProduct.getBandAt(i);
            Band targetBand = this.targetProduct.addBand(srcBand.getName(), srcBand.getDataType());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
            this.sourceRasterMap.put(targetBand, srcBand);
            this.gcpsComputedMap.put(srcBand, false);
            if (srcBand == this.masterBand1 || srcBand == this.masterBand2 || oneSlaveProcessed || StringUtils.contains((String[])masterBandNames, (String)srcBand.getName())) {
                targetBand.setSourceImage(srcBand.getSourceImage());
            } else {
                String unit = srcBand.getUnit();
                if (!oneSlaveProcessed && unit != null && !unit.contains("imaginary")) {
                    oneSlaveProcessed = true;
                    this.primarySlaveBand = srcBand;
                    MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
                    AbstractMetadata.addAbstractedAttribute((MetadataElement)absRoot, (String)"processed_slave", (int)41, (String)"", (String)"");
                    absRoot.setAttributeString("processed_slave", this.primarySlaveBand.getName());
                }
            }
            if (!this.complexCoregistration || srcBand.getUnit() == null || !srcBand.getUnit().equals("real") || i + 1 >= numSrcBands) continue;
            this.complexSrcMap.put(srcBand, this.sourceProduct.getBandAt(i + 1));
        }
    }

    private synchronized void createDEM() {
        if (this.dem != null) {
            return;
        }
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor("SRTM 3Sec");
        if (demDescriptor.isInstallingDem()) {
            throw new OperatorException("The DEM is currently being installed.");
        }
        this.dem = demDescriptor.createDem(ResamplingFactory.createResampling((String)"NEAREST_NEIGHBOUR"));
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band slaveBand;
            if (this.onlyGCPsOnLand && this.dem == null) {
                this.createDEM();
            }
            String[] masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
            HashMap<String, Band> singleSlvBandMap = new HashMap<String, Band>();
            HashMap<Band, Band> bandList = new HashMap<Band, Band>();
            for (Band targetBand : this.targetProduct.getBands()) {
                String unit;
                slaveBand = this.sourceRasterMap.get(targetBand);
                if (this.gcpsComputedMap.get(slaveBand).booleanValue()) {
                    bandList.put(targetBand, this.primarySlaveBand);
                    break;
                }
                if (slaveBand == this.masterBand1 || slaveBand == this.masterBand2 || StringUtils.contains((String[])masterBandNames, (String)slaveBand.getName())) continue;
                if (this.collocatedStack && !this.useAllPolarimetricBands) {
                    String mstPol = OperatorUtils.getPolarizationFromBandName((String)this.masterBand1.getName());
                    String slvProductName = StackUtils.getSlaveProductName((Product)this.targetProduct, (Band)targetBand, (String)mstPol);
                    if (slvProductName == null || singleSlvBandMap.get(slvProductName) != null) continue;
                    singleSlvBandMap.put(slvProductName, targetBand);
                }
                if ((unit = slaveBand.getUnit()) != null && (unit.contains("imaginary") || unit.contains("bit"))) continue;
                bandList.put(targetBand, slaveBand);
            }
            int bandCnt = 0;
            Band firstTargetBand = null;
            for (Band targetBand : bandList.keySet()) {
                Tile targetTile;
                slaveBand = (Band)bandList.get(targetBand);
                if (this.collocatedStack || !this.collocatedStack && ++bandCnt == 1) {
                    String bandCountStr = bandCnt + " of " + bandList.size();
                    if (this.complexCoregistration) {
                        this.computeSlaveGCPs(slaveBand, this.complexSrcMap.get(slaveBand), targetBand, bandCountStr);
                    } else {
                        this.computeSlaveGCPs(slaveBand, null, targetBand, bandCountStr);
                    }
                    if (bandCnt == 1) {
                        firstTargetBand = targetBand;
                    }
                } else {
                    this.copyFirstTargetBandGCPs(firstTargetBand, targetBand);
                }
                if (slaveBand != this.primarySlaveBand || (targetTile = targetTileMap.get(targetBand)) == null) continue;
                targetTile.setRawSamples(this.getSourceTile((RasterDataNode)slaveBand, targetRectangle).getRawSamples());
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void computeSlaveGCPs(final Band slaveBand, final Band slaveBand2, Band targetBand, String bandCountStr) throws OperatorException {
        if (this.gcpsComputedMap.get(slaveBand).booleanValue()) {
            return;
        }
        this.gcpsComputedMap.put(slaveBand, true);
        try {
            final ProductNodeGroup<Placemark> targetGCPGroup = GCPManager.instance().getGcpGroup(targetBand);
            final GeoCoding tgtGeoCoding = this.targetProduct.getGeoCoding();
            int[] offset = new int[2];
            if (this.computeOffset) {
                this.determiningImageOffset(slaveBand, slaveBand2, offset);
            }
            ThreadManager threadManager = new ThreadManager();
            int numberOfMasterGCPs = this.masterGcpGroup.getNodeCount();
            StatusProgressMonitor status = new StatusProgressMonitor((float)numberOfMasterGCPs, "Cross Correlating " + bandCountStr + ' ' + slaveBand.getName() + "... ");
            for (int i = 0; i < numberOfMasterGCPs; ++i) {
                this.checkForCancellation();
                final Placemark mPin = (Placemark)this.masterGcpGroup.get(i);
                if (this.checkMasterGCPValidity(mPin)) {
                    final GeoPos mGCPGeoPos = mPin.getGeoPos();
                    final PixelPos mGCPPixelPos = mPin.getPixelPos();
                    final PixelPos sGCPPixelPos = new PixelPos(mPin.getPixelPos().x + (float)offset[0], mPin.getPixelPos().y + (float)offset[1]);
                    if (!this.checkSlaveGCPValidity(sGCPPixelPos)) continue;
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            boolean getSlaveGCP = GCPSelectionOp.this.getCoarseSlaveGCPPosition(slaveBand, slaveBand2, mGCPPixelPos, sGCPPixelPos);
                            if (getSlaveGCP && GCPSelectionOp.this.complexCoregistration && GCPSelectionOp.this.applyFineRegistration) {
                                getSlaveGCP = GCPSelectionOp.this.getFineSlaveGCPPosition(slaveBand, slaveBand2, mGCPPixelPos, sGCPPixelPos);
                            }
                            if (getSlaveGCP) {
                                Placemark sPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)mPin.getName(), (String)mPin.getLabel(), (String)mPin.getDescription(), (PixelPos)sGCPPixelPos, (GeoPos)mGCPGeoPos, (GeoCoding)tgtGeoCoding);
                                this.addPlacemark(sPin);
                            }
                        }

                        private synchronized void addPlacemark(Placemark pin) {
                            targetGCPGroup.add((ProductNode)pin);
                        }
                    };
                    threadManager.add(worker);
                }
                status.worked(i);
            }
            threadManager.finish();
            MemUtils.tileCacheFreeOldTiles();
            status.done();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " computeSlaveGCPs "), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determiningImageOffset(final Band slaveBand1, final Band slaveBand2, int[] offset) {
        try {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            double groundRangeSpacing = absRoot.getAttributeDouble("range_spacing", 1.0);
            double azimuthSpacing = absRoot.getAttributeDouble("azimuth_spacing", 1.0);
            boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)absRoot, (String)"srgr_flag");
            if (!srgrFlag) {
                TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)this.sourceProduct);
                double incidenceAngleAtCentreRangePixel = incidenceAngle.getPixelFloat((float)this.sourceImageWidth / 2.0f, (float)this.sourceImageHeight / 2.0f);
                groundRangeSpacing /= Math.sin(incidenceAngleAtCentreRangePixel * (Math.PI / 180));
            }
            final int nRgLooks = Math.max(1, this.sourceImageWidth / 2048);
            final int nAzLooks = Math.max(1, (int)((double)nRgLooks * groundRangeSpacing / azimuthSpacing + 0.5));
            int targetImageWidth = this.sourceImageWidth / nRgLooks;
            int targetImageHeight = this.sourceImageHeight / nAzLooks;
            final int windowWidth = (int)Math.pow(2.0, (int)(Math.log10(targetImageWidth) / Math.log10(2.0)));
            int windowHeight = (int)Math.pow(2.0, (int)(Math.log10(targetImageHeight) / Math.log10(2.0)));
            final double[] mI = new double[windowWidth * windowHeight];
            final double[] sI = new double[windowWidth * windowHeight];
            int tileCountX = 4;
            int tileCountY = 4;
            int tileWidth = windowWidth / 4;
            int tileHeight = windowHeight / 4;
            Rectangle[] tileRectangles = new Rectangle[16];
            int index = 0;
            for (int tileY = 0; tileY < 4; ++tileY) {
                int ypos = tileY * tileHeight;
                for (int tileX = 0; tileX < 4; ++tileX) {
                    Rectangle rectangle = new Rectangle(tileX * tileWidth, ypos, tileWidth, tileHeight);
                    tileRectangles[index++] = rectangle;
                }
            }
            final StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing offset... ");
            boolean tileCnt = false;
            ThreadManager threadManager = new ThreadManager();
            try {
                for (final Rectangle rectangle : tileRectangles) {
                    this.checkForCancellation();
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            int xStart = x0 * nRgLooks;
                            int yStart = y0 * nAzLooks;
                            int xEnd = xMax * nRgLooks;
                            int yEnd = yMax * nAzLooks;
                            Rectangle srcRect = new Rectangle(xStart, yStart, xEnd - xStart, yEnd - yStart);
                            Tile mstTile1 = GCPSelectionOp.this.getSourceTile((RasterDataNode)GCPSelectionOp.this.masterBand1, srcRect);
                            ProductData mstData1 = mstTile1.getDataBuffer();
                            TileIndex mstIndex = new TileIndex(mstTile1);
                            Tile slvTile1 = GCPSelectionOp.this.getSourceTile((RasterDataNode)slaveBand1, srcRect);
                            ProductData slvData1 = slvTile1.getDataBuffer();
                            TileIndex slvIndex = new TileIndex(slvTile1);
                            ProductData mstData2 = null;
                            ProductData slvData2 = null;
                            if (GCPSelectionOp.this.complexCoregistration) {
                                mstData2 = GCPSelectionOp.this.getSourceTile((RasterDataNode)GCPSelectionOp.this.masterBand2, srcRect).getDataBuffer();
                                slvData2 = GCPSelectionOp.this.getSourceTile((RasterDataNode)slaveBand2, srcRect).getDataBuffer();
                            }
                            double rgAzLooks = nRgLooks * nAzLooks;
                            for (int y = y0; y < yMax; ++y) {
                                int yByWidth = y * windowWidth;
                                int y1 = y * nAzLooks;
                                int y2 = y1 + nAzLooks;
                                for (int x = x0; x < xMax; ++x) {
                                    int x1 = x * nRgLooks;
                                    int x2 = x1 + nRgLooks;
                                    mI[yByWidth + x] = GCPSelectionOp.this.getMeanValue(x1, x2, y1, y2, mstData1, mstData2, mstIndex, rgAzLooks);
                                    sI[yByWidth + x] = GCPSelectionOp.this.getMeanValue(x1, x2, y1, y2, slvData1, slvData2, slvIndex, rgAzLooks);
                                }
                            }
                            status.workedOne();
                        }
                    };
                    threadManager.add(worker);
                }
                threadManager.finish();
            }
            catch (Throwable throwable) {
                OperatorUtils.catchOperatorException((String)"GCPSelectionOp", (Throwable)throwable);
            }
            finally {
                status.done();
            }
            RenderedImage renderedImage = GCPSelectionOp.createRenderedImage(mI, windowWidth, windowHeight);
            PlanarImage masterSpectrum = GCPSelectionOp.dft(renderedImage);
            RenderedImage slaveImage = GCPSelectionOp.createRenderedImage(sI, windowWidth, windowHeight);
            PlanarImage slaveSpectrum = GCPSelectionOp.dft(slaveImage);
            PlanarImage conjugateSlaveSpectrum = GCPSelectionOp.conjugate(slaveSpectrum);
            PlanarImage crossSpectrum = GCPSelectionOp.multiplyComplex(masterSpectrum, conjugateSlaveSpectrum);
            PlanarImage correlatedImage = GCPSelectionOp.idft((RenderedImage)crossSpectrum);
            PlanarImage crossCorrelatedImage = GCPSelectionOp.magnitude(correlatedImage);
            int w = crossCorrelatedImage.getWidth();
            int h = crossCorrelatedImage.getHeight();
            Raster idftData = crossCorrelatedImage.getData();
            double[] real = idftData.getSamples(0, 0, w, h, 0, (double[])null);
            int peakRow = 0;
            int peakCol = 0;
            double peak = 0.0;
            for (int r = 0; r < h; ++r) {
                for (int c = 0; c < w; ++c) {
                    int s;
                    if (r >= h / 4 && r <= h * 3 / 4 || c >= w / 4 && c <= w * 3 / 4 || !(peak < real[s = r * w + c])) continue;
                    peak = real[s];
                    peakRow = r;
                    peakCol = c;
                }
            }
            offset[1] = peakRow <= h / 2 ? -peakRow * nAzLooks : (h - peakRow) * nAzLooks;
            offset[0] = peakCol <= w / 2 ? -peakCol * nRgLooks : (w - peakCol) * nRgLooks;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getCoarseSlaveGCPPosition "), (Throwable)e);
        }
    }

    private double getMeanValue(int xStart, int xEnd, int yStart, int yEnd, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, double rgAzLooks) {
        double meanValue = 0.0;
        if (this.complexCoregistration) {
            for (int y = yStart; y < yEnd; ++y) {
                srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    int idx = srcIndex.getIndex(x);
                    double v1 = srcData1.getElemDoubleAt(idx);
                    double v2 = srcData2.getElemDoubleAt(idx);
                    meanValue += v1 * v1 + v2 * v2;
                }
            }
        } else {
            for (int y = yStart; y < yEnd; ++y) {
                srcIndex.calculateStride(y);
                for (int x = xStart; x < xEnd; ++x) {
                    meanValue += srcData1.getElemDoubleAt(srcIndex.getIndex(x));
                }
            }
        }
        return meanValue / rgAzLooks;
    }

    private void copyFirstTargetBandGCPs(Band firstTargetBand, Band targetBand) {
        ProductNodeGroup<Placemark> firstTargetBandGcpGroup = GCPManager.instance().getGcpGroup(firstTargetBand);
        ProductNodeGroup<Placemark> currentTargetBandGCPGroup = GCPManager.instance().getGcpGroup(targetBand);
        int numberOfGCPs = firstTargetBandGcpGroup.getNodeCount();
        for (int i = 0; i < numberOfGCPs; ++i) {
            currentTargetBandGCPGroup.add(firstTargetBandGcpGroup.get(i));
        }
    }

    private boolean checkMasterGCPValidity(Placemark mPin) throws Exception {
        double alt;
        PixelPos pixelPos = mPin.getPixelPos();
        if (this.onlyGCPsOnLand && (alt = this.dem.getElevation(mPin.getGeoPos())) == (double)this.dem.getDescriptor().getNoDataValue()) {
            return false;
        }
        return pixelPos.x - (float)this.cHalfWindowWidth + 1.0f >= 0.0f && pixelPos.x + (float)this.cHalfWindowWidth <= (float)(this.sourceImageWidth - 1) && pixelPos.y - (float)this.cHalfWindowHeight + 1.0f >= 0.0f && pixelPos.y + (float)this.cHalfWindowHeight <= (float)(this.sourceImageHeight - 1);
    }

    private boolean checkSlaveGCPValidity(PixelPos pixelPos) {
        return pixelPos.x - (float)this.cHalfWindowWidth + 1.0f >= 0.0f && pixelPos.x + (float)this.cHalfWindowWidth <= (float)(this.sourceImageWidth - 1) && pixelPos.y - (float)this.cHalfWindowHeight + 1.0f >= 0.0f && pixelPos.y + (float)this.cHalfWindowHeight <= (float)(this.sourceImageHeight - 1);
    }

    private boolean getCoarseSlaveGCPPosition(Band slaveBand, Band slaveBand2, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            double[] mI = new double[this.cWindowWidth * this.cWindowHeight];
            double[] sI = new double[this.cWindowWidth * this.cWindowHeight];
            boolean getMISuccess = this.getMasterImagette(mGCPPixelPos, mI);
            if (!getMISuccess) {
                return false;
            }
            double rowShift = this.gcpTolerance + 1.0;
            double colShift = this.gcpTolerance + 1.0;
            int numIter = 0;
            while (Math.abs(rowShift) >= this.gcpTolerance || Math.abs(colShift) >= this.gcpTolerance) {
                if (numIter >= this.maxIteration) {
                    return false;
                }
                if (!this.checkSlaveGCPValidity(sGCPPixelPos)) {
                    return false;
                }
                boolean getSISuccess = this.getSlaveImagette(slaveBand, slaveBand2, sGCPPixelPos, sI);
                if (!getSISuccess) {
                    return false;
                }
                double[] shift = new double[]{0.0, 0.0};
                if (!this.getSlaveGCPShift(shift, mI, sI)) {
                    return false;
                }
                rowShift = shift[0];
                colShift = shift[1];
                sGCPPixelPos.x += (float)colShift;
                sGCPPixelPos.y += (float)rowShift;
                ++numIter;
            }
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getCoarseSlaveGCPPosition "), (Throwable)e);
            return false;
        }
    }

    private boolean getMasterImagette(PixelPos gcpPixelPos, double[] mI) throws OperatorException {
        int x0 = (int)gcpPixelPos.x;
        int y0 = (int)gcpPixelPos.y;
        int xul = x0 - this.cHalfWindowWidth + 1;
        int yul = y0 - this.cHalfWindowHeight + 1;
        Rectangle masterImagetteRectangle = new Rectangle(xul, yul, this.cWindowWidth, this.cWindowHeight);
        try {
            Tile masterImagetteRaster1 = this.getSourceTile((RasterDataNode)this.masterBand1, masterImagetteRectangle);
            ProductData masterData1 = masterImagetteRaster1.getDataBuffer();
            double noDataValue1 = this.masterBand1.getNoDataValue();
            ProductData masterData2 = null;
            double noDataValue2 = 0.0;
            if (this.complexCoregistration) {
                Tile masterImagetteRaster2 = this.getSourceTile((RasterDataNode)this.masterBand2, masterImagetteRectangle);
                masterData2 = masterImagetteRaster2.getDataBuffer();
                noDataValue2 = this.masterBand2.getNoDataValue();
            }
            TileIndex mstIndex = new TileIndex(masterImagetteRaster1);
            int k = 0;
            int numInvalidPixels = 0;
            for (int j = 0; j < this.cWindowHeight; ++j) {
                int offset = mstIndex.calculateStride(yul + j);
                for (int i = 0; i < this.cWindowWidth; ++i) {
                    int index = xul + i - offset;
                    if (this.complexCoregistration) {
                        double v1 = masterData1.getElemDoubleAt(index);
                        double v2 = masterData2.getElemDoubleAt(index);
                        if (v1 == noDataValue1 && v2 == noDataValue2) {
                            ++numInvalidPixels;
                        }
                        mI[k++] = v1 * v1 + v2 * v2;
                        continue;
                    }
                    double v = masterData1.getElemDoubleAt(index);
                    if (v == noDataValue1) {
                        ++numInvalidPixels;
                    }
                    mI[k++] = v;
                }
            }
            masterData1.dispose();
            if (masterData2 != null) {
                masterData2.dispose();
            }
            return !((double)numInvalidPixels > 0.66 * (double)this.cWindowHeight * (double)this.cWindowWidth);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getMasterImagette", (Throwable)e);
            return false;
        }
    }

    private boolean getSlaveImagette(Band slaveBand1, Band slaveBand2, PixelPos gcpPixelPos, double[] sI) throws OperatorException {
        double xx = gcpPixelPos.x;
        double yy = gcpPixelPos.y;
        int xul = (int)xx - this.cHalfWindowWidth;
        int yul = (int)yy - this.cHalfWindowHeight;
        Rectangle slaveImagetteRectangle = new Rectangle(xul, yul, this.cWindowWidth + 3, this.cWindowHeight + 3);
        int k = 0;
        try {
            Tile slaveImagetteRaster1 = this.getSourceTile((RasterDataNode)slaveBand1, slaveImagetteRectangle);
            ProductData slaveData1 = slaveImagetteRaster1.getDataBuffer();
            double noDataValue1 = slaveBand1.getNoDataValue();
            Tile slaveImagetteRaster2 = null;
            ProductData slaveData2 = null;
            double noDataValue2 = 0.0;
            if (this.complexCoregistration) {
                slaveImagetteRaster2 = this.getSourceTile((RasterDataNode)slaveBand2, slaveImagetteRectangle);
                slaveData2 = slaveImagetteRaster2.getDataBuffer();
                noDataValue2 = slaveBand2.getNoDataValue();
            }
            TileIndex index0 = new TileIndex(slaveImagetteRaster1);
            TileIndex index1 = new TileIndex(slaveImagetteRaster1);
            int numInvalidPixels = 0;
            for (int j = 0; j < this.cWindowHeight; ++j) {
                double y = yy - (double)this.cHalfWindowHeight + (double)j + 1.0;
                int y0 = (int)y;
                int y1 = y0 + 1;
                int offset0 = index0.calculateStride(y0);
                int offset1 = index1.calculateStride(y1);
                double wy = y - (double)y0;
                for (int i = 0; i < this.cWindowWidth; ++i) {
                    double x = xx - (double)this.cHalfWindowWidth + (double)i + 1.0;
                    int x0 = (int)x;
                    int x1 = x0 + 1;
                    double wx = x - (double)x0;
                    int x00 = x0 - offset0;
                    int x01 = x0 - offset1;
                    int x10 = x1 - offset0;
                    int x11 = x1 - offset1;
                    if (this.complexCoregistration) {
                        double v1 = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData1.getElemDoubleAt(x00), (double)slaveData1.getElemDoubleAt(x01), (double)slaveData1.getElemDoubleAt(x10), (double)slaveData1.getElemDoubleAt(x11));
                        double v2 = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData2.getElemDoubleAt(x00), (double)slaveData2.getElemDoubleAt(x01), (double)slaveData2.getElemDoubleAt(x10), (double)slaveData2.getElemDoubleAt(x11));
                        if (v1 == noDataValue1 && v2 == noDataValue2) {
                            ++numInvalidPixels;
                        }
                        sI[k] = v1 * v1 + v2 * v2;
                    } else {
                        double v = MathUtils.interpolate2D((double)wy, (double)wx, (double)slaveData1.getElemDoubleAt(x00), (double)slaveData1.getElemDoubleAt(x01), (double)slaveData1.getElemDoubleAt(x10), (double)slaveData1.getElemDoubleAt(x11));
                        if (v == noDataValue1) {
                            ++numInvalidPixels;
                        }
                        sI[k] = v;
                    }
                    ++k;
                }
            }
            slaveData1.dispose();
            if (slaveData2 != null) {
                slaveData2.dispose();
            }
            return !((double)numInvalidPixels > 0.66 * (double)this.cWindowHeight * (double)this.cWindowWidth);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"getSlaveImagette", (Throwable)e);
            return false;
        }
    }

    private boolean getSlaveGCPShift(double[] shift, double[] mI, double[] sI) {
        try {
            PlanarImage crossCorrelatedImage = this.computeCrossCorrelatedImage(mI, sI);
            int w = crossCorrelatedImage.getWidth();
            int h = crossCorrelatedImage.getHeight();
            Raster idftData = crossCorrelatedImage.getData();
            double[] real = idftData.getSamples(0, 0, w, h, 0, (double[])null);
            int peakRow = 0;
            int peakCol = 0;
            double peak = real[0];
            for (int r = 0; r < h; ++r) {
                for (int c = 0; c < w; ++c) {
                    int k = r * w + c;
                    if (!(real[k] > peak)) continue;
                    peak = real[k];
                    peakRow = r;
                    peakCol = c;
                }
            }
            shift[0] = peakRow <= h / 2 ? (double)(-peakRow) / (double)this.rowUpSamplingFactor : (double)(h - peakRow) / (double)this.rowUpSamplingFactor;
            shift[1] = peakCol <= w / 2 ? (double)(-peakCol) / (double)this.colUpSamplingFactor : (double)(w - peakCol) / (double)this.colUpSamplingFactor;
            return true;
        }
        catch (Throwable t) {
            System.out.println("getSlaveGCPShift failed " + t.getMessage());
            return false;
        }
    }

    private PlanarImage computeCrossCorrelatedImage(double[] mI, double[] sI) {
        RenderedImage masterImage = GCPSelectionOp.createRenderedImage(mI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage masterSpectrum = GCPSelectionOp.dft(masterImage);
        RenderedImage slaveImage = GCPSelectionOp.createRenderedImage(sI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage slaveSpectrum = GCPSelectionOp.dft(slaveImage);
        PlanarImage conjugateSlaveSpectrum = GCPSelectionOp.conjugate(slaveSpectrum);
        PlanarImage crossSpectrum = GCPSelectionOp.multiplyComplex(masterSpectrum, conjugateSlaveSpectrum);
        RenderedImage upsampledCrossSpectrum = this.upsampling(crossSpectrum);
        PlanarImage correlatedImage = GCPSelectionOp.idft(upsampledCrossSpectrum);
        return GCPSelectionOp.magnitude(correlatedImage);
    }

    private static RenderedImage createRenderedImage(double[] array, int w, int h) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)w, (int)h, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferDouble dataBuffer = new DataBufferDouble(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, new Hashtable());
    }

    private static PlanarImage dft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_NONE);
        pb.add(DFTDescriptor.REAL_TO_COMPLEX);
        return JAI.create((String)"dft", (ParameterBlock)pb, null);
    }

    private static PlanarImage idft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_DIMENSIONS);
        pb.add(DFTDescriptor.COMPLEX_TO_COMPLEX);
        return JAI.create((String)"idft", (ParameterBlock)pb, null);
    }

    private static PlanarImage conjugate(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"conjugate", (ParameterBlock)pb, null);
    }

    private static PlanarImage multiplyComplex(PlanarImage image1, PlanarImage image2) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image1);
        pb.addSource(image2);
        return JAI.create((String)"MultiplyComplex", (ParameterBlock)pb, null);
    }

    private RenderedImage upsampling(PlanarImage image) {
        int topPad;
        int leftPad;
        int w = image.getWidth();
        int h = image.getHeight();
        int newWidth = this.rowUpSamplingFactor * w;
        int newHeight = this.colUpSamplingFactor * h;
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(image);
        pb1.add(w / 2);
        pb1.add(h / 2);
        RenderedOp shiftedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb1, null);
        ParameterBlock pb2 = new ParameterBlock();
        int rightPad = leftPad = (newWidth - w) / 2;
        int bottomPad = topPad = (newHeight - h) / 2;
        pb2.addSource(shiftedImage);
        pb2.add(leftPad);
        pb2.add(rightPad);
        pb2.add(topPad);
        pb2.add(bottomPad);
        pb2.add(BorderExtender.createInstance((int)0));
        RenderedOp zeroPaddedImage = JAI.create((String)"border", (ParameterBlock)pb2);
        ParameterBlock pb3 = new ParameterBlock();
        pb3.addSource(zeroPaddedImage);
        pb3.add(1.0f * (float)leftPad);
        pb3.add(1.0f * (float)topPad);
        RenderedOp zeroBorderedImage = JAI.create((String)"translate", (ParameterBlock)pb3, null);
        ParameterBlock pb4 = new ParameterBlock();
        pb4.addSource(zeroBorderedImage);
        pb4.add(newWidth / 2);
        pb4.add(newHeight / 2);
        RenderedOp shiftedZeroPaddedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb4, null);
        return shiftedZeroPaddedImage;
    }

    private static PlanarImage magnitude(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"magnitude", (ParameterBlock)pb, null);
    }

    private static double getMean(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        RenderedOp meanImage = JAI.create((String)"mean", (ParameterBlock)pb, null);
        double[] mean = (double[])meanImage.getProperty("mean");
        return mean[0];
    }

    private static double getMax(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        return extrema[1][0];
    }

    private static void outputRealImage(double[] I) {
        for (double v : I) {
            System.out.print(v + ",");
        }
        System.out.println();
    }

    private static void outputComplexImage(PlanarImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        Raster dftData = image.getData();
        double[] real = dftData.getSamples(0, 0, w, h, 0, (double[])null);
        double[] imag = dftData.getSamples(0, 0, w, h, 1, (double[])null);
        System.out.println("Real part:");
        for (double v : real) {
            System.out.print(v + ", ");
        }
        System.out.println();
        System.out.println("Imaginary part:");
        for (double v : imag) {
            System.out.print(v + ", ");
        }
        System.out.println();
    }

    public void setTestParameters(String windowWidth, String windowHeight, String rowUpSamplingFactor, String colUpSamplingFactor, int maxIter, double tolerance) {
        this.coarseRegistrationWindowWidth = windowWidth;
        this.coarseRegistrationWindowHeight = windowHeight;
        this.rowInterpFactor = rowUpSamplingFactor;
        this.columnInterpFactor = colUpSamplingFactor;
        this.maxIteration = maxIter;
        this.gcpTolerance = tolerance;
    }

    private static void outputRealImage(double[][] I) {
        int row = I.length;
        int col = I[0].length;
        for (double[] aI : I) {
            for (int c = 0; c < col; ++c) {
                System.out.print(aI[c] + ",");
            }
        }
        System.out.println();
    }

    private boolean getFineSlaveGCPPosition(Band slaveBand1, Band slaveBand2, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        try {
            ComplexCoregData complexData = new ComplexCoregData(this.coherenceWindowSize, 1.0E-5, 0.01, this.fWindowWidth, this.fWindowHeight, this.useSlidingWindow);
            this.getComplexMasterImagette(complexData, mGCPPixelPos);
            this.getInitialComplexSlaveImagette(complexData, slaveBand1, slaveBand2, sGCPPixelPos);
            double[] p = new double[]{sGCPPixelPos.x, sGCPPixelPos.y};
            double coherence = GCPSelectionOp.powell(complexData, p);
            complexData.dispose();
            if (1.0 - coherence < this.coherenceThreshold) {
                return false;
            }
            sGCPPixelPos.x = (float)p[0];
            sGCPPixelPos.y = (float)p[1];
            return true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getFineSlaveGCPPosition "), (Throwable)e);
            return false;
        }
    }

    private void getComplexMasterImagette(ComplexCoregData compleData, PixelPos gcpPixelPos) {
        ComplexCoregData.access$702(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        ComplexCoregData.access$1002(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        int x0 = (int)gcpPixelPos.x;
        int y0 = (int)gcpPixelPos.y;
        int xul = x0 - compleData.fHalfWindowWidth + 1;
        int yul = y0 - compleData.fHalfWindowHeight + 1;
        Rectangle masterImagetteRectangle = new Rectangle(xul, yul, compleData.fWindowWidth, compleData.fWindowHeight);
        Tile masterImagetteRaster1 = this.getSourceTile((RasterDataNode)this.masterBand1, masterImagetteRectangle);
        Tile masterImagetteRaster2 = this.getSourceTile((RasterDataNode)this.masterBand2, masterImagetteRectangle);
        ProductData masterData1 = masterImagetteRaster1.getDataBuffer();
        ProductData masterData2 = masterImagetteRaster2.getDataBuffer();
        TileIndex index = new TileIndex(masterImagetteRaster1);
        double[][] mIIdata = compleData.mII;
        double[][] mIQdata = compleData.mIQ;
        for (int j = 0; j < compleData.fWindowHeight; ++j) {
            index.calculateStride(yul + j);
            for (int i = 0; i < compleData.fWindowWidth; ++i) {
                int idx = index.getIndex(xul + i);
                mIIdata[j][i] = masterData1.getElemDoubleAt(idx);
                mIQdata[j][i] = masterData2.getElemDoubleAt(idx);
            }
        }
        masterData1.dispose();
        masterData2.dispose();
    }

    private void getInitialComplexSlaveImagette(ComplexCoregData compleData, Band slaveBand1, Band slaveBand2, PixelPos sGCPPixelPos) {
        ComplexCoregData.access$1302(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        ComplexCoregData.access$1402(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        int x0 = (int)((double)sGCPPixelPos.x + 0.5);
        int y0 = (int)((double)sGCPPixelPos.y + 0.5);
        compleData.point0[0] = sGCPPixelPos.x;
        compleData.point0[1] = sGCPPixelPos.y;
        int xul = x0 - compleData.fHalfWindowWidth + 1;
        int yul = y0 - compleData.fHalfWindowHeight + 1;
        Rectangle slaveImagetteRectangle = new Rectangle(xul, yul, compleData.fWindowWidth, compleData.fWindowHeight);
        Tile slaveImagetteRaster1 = this.getSourceTile((RasterDataNode)slaveBand1, slaveImagetteRectangle);
        Tile slaveImagetteRaster2 = this.getSourceTile((RasterDataNode)slaveBand2, slaveImagetteRectangle);
        ProductData slaveData1 = slaveImagetteRaster1.getDataBuffer();
        ProductData slaveData2 = slaveImagetteRaster2.getDataBuffer();
        TileIndex index = new TileIndex(slaveImagetteRaster1);
        double[][] sII0data = compleData.sII0;
        double[][] sIQ0data = compleData.sIQ0;
        for (int j = 0; j < compleData.fWindowHeight; ++j) {
            index.calculateStride(yul + j);
            for (int i = 0; i < compleData.fWindowWidth; ++i) {
                int idx = index.getIndex(xul + i);
                sII0data[j][i] = slaveData1.getElemDoubleAt(idx);
                sIQ0data[j][i] = slaveData2.getElemDoubleAt(idx);
            }
        }
        slaveData1.dispose();
        slaveData2.dispose();
    }

    private static double computeCoherence(ComplexCoregData complexData, double[] point) {
        double xShift = Math.abs(complexData.point0[0] - point[0]);
        double yShift = Math.abs(complexData.point0[1] - point[1]);
        if (xShift >= 0.5 || yShift >= 0.5) {
            return 1.0;
        }
        GCPSelectionOp.getComplexSlaveImagette(complexData, point);
        double coherence = 0.0;
        if (complexData.useSlidingWindow) {
            int maxR = complexData.fWindowHeight - complexData.coherenceWindowSize;
            int maxC = complexData.fWindowWidth - complexData.coherenceWindowSize;
            for (int r = 0; r <= maxR; ++r) {
                for (int c = 0; c <= maxC; ++c) {
                    coherence += GCPSelectionOp.getCoherence(complexData, r, c, complexData.coherenceWindowSize, complexData.coherenceWindowSize);
                }
            }
            coherence /= (double)((maxR + 1) * (maxC + 1));
        } else {
            coherence = GCPSelectionOp.getCoherence(complexData, 0, 0, complexData.fWindowWidth, complexData.fWindowHeight);
        }
        return 1.0 - coherence;
    }

    private static double computeCoherence(ComplexCoregData compleData, double a, double[] p, double[] d) {
        double[] point = new double[]{p[0] + a * d[0], p[1] + a * d[1]};
        return GCPSelectionOp.computeCoherence(compleData, point);
    }

    private static void getComplexSlaveImagette(ComplexCoregData compleData, double[] point) {
        ComplexCoregData.access$1702(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        ComplexCoregData.access$1802(compleData, new double[compleData.fWindowHeight][compleData.fWindowWidth]);
        double[][] sII0data = compleData.sII0;
        double[][] sIQ0data = compleData.sIQ0;
        double[][] sIIdata = compleData.sII;
        double[][] sIQdata = compleData.sIQ;
        int x0 = (int)(compleData.point0[0] + 0.5);
        int y0 = (int)(compleData.point0[1] + 0.5);
        double xShift = (double)x0 - point[0];
        double yShift = (double)y0 - point[1];
        double[] rowArray = new double[compleData.fTwoWindowWidth];
        double[] rowPhaseArray = new double[compleData.fTwoWindowWidth];
        DoubleFFT_1D row_fft = new DoubleFFT_1D(compleData.fWindowWidth);
        int signalLength = rowArray.length / 2;
        GCPSelectionOp.computeShiftPhaseArray(xShift, signalLength, rowPhaseArray);
        for (int r = 0; r < compleData.fWindowHeight; ++r) {
            int c;
            int k = 0;
            double[] sII = sII0data[r];
            double[] sIQ = sIQ0data[r];
            for (c = 0; c < compleData.fWindowWidth; ++c) {
                rowArray[k++] = sII[c];
                rowArray[k++] = sIQ[c];
            }
            row_fft.complexForward(rowArray);
            GCPSelectionOp.multiplySpectrumByShiftFactor(rowArray, rowPhaseArray);
            row_fft.complexInverse(rowArray, true);
            for (c = 0; c < compleData.fWindowWidth; ++c) {
                sIIdata[r][c] = rowArray[2 * c];
                sIQdata[r][c] = rowArray[2 * c + 1];
            }
        }
        double[] colArray = new double[compleData.fTwoWindowHeight];
        double[] colPhaseArray = new double[compleData.fTwoWindowHeight];
        DoubleFFT_1D col_fft = new DoubleFFT_1D(compleData.fWindowHeight);
        signalLength = colArray.length / 2;
        GCPSelectionOp.computeShiftPhaseArray(yShift, signalLength, colPhaseArray);
        for (int c = 0; c < compleData.fWindowWidth; ++c) {
            int r;
            int k = 0;
            for (r = 0; r < compleData.fWindowHeight; ++r) {
                colArray[k++] = sIIdata[r][c];
                colArray[k++] = sIQdata[r][c];
            }
            col_fft.complexForward(colArray);
            GCPSelectionOp.multiplySpectrumByShiftFactor(colArray, colPhaseArray);
            col_fft.complexInverse(colArray, true);
            for (r = 0; r < compleData.fWindowHeight; ++r) {
                sIIdata[r][c] = colArray[2 * r];
                sIQdata[r][c] = colArray[2 * r + 1];
            }
        }
    }

    private static void computeShiftPhaseArray(double shift, int signalLength, double[] phaseArray) {
        double phase = Math.PI * -2 * shift / (double)signalLength;
        int halfSignalLength = (int)((double)signalLength * 0.5 + 0.5);
        for (int k = 0; k < signalLength; ++k) {
            double phaseK = k < halfSignalLength ? phase * (double)k : phase * (double)(k - signalLength);
            int k2 = k * 2;
            phaseArray[k2] = Math.cos(phaseK);
            phaseArray[k2 + 1] = Math.sin(phaseK);
        }
    }

    private static void multiplySpectrumByShiftFactor(double[] array, double[] phaseArray) {
        int signalLength = array.length / 2;
        for (int k = 0; k < signalLength; ++k) {
            int k2 = k * 2;
            double c = phaseArray[k2];
            double s = phaseArray[k2 + 1];
            double real = array[k2];
            double imag = array[k2 + 1];
            array[k2] = real * c - imag * s;
            array[k2 + 1] = real * s + imag * c;
        }
    }

    private static double getCoherence(ComplexCoregData compleData, int row, int col, int coherenceWindowWidth, int coherenceWindowHeight) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double[][] mIIdata = compleData.mII;
        double[][] mIQdata = compleData.mIQ;
        double[][] sIIdata = compleData.sII;
        double[][] sIQdata = compleData.sIQ;
        for (int r = 0; r < coherenceWindowHeight; ++r) {
            int rIdx = row + r;
            double[] mII = mIIdata[rIdx];
            double[] mIQ = mIQdata[rIdx];
            double[] sII = sIIdata[rIdx];
            double[] sIQ = sIQdata[rIdx];
            for (int c = 0; c < coherenceWindowWidth; ++c) {
                int cIdx = col + c;
                double mr = mII[cIdx];
                double mi = mIQ[cIdx];
                double sr = sII[cIdx];
                double si = sIQ[cIdx];
                sum1 += mr * sr + mi * si;
                sum2 += mi * sr - mr * si;
                sum3 += mr * mr + mi * mi;
                sum4 += sr * sr + si * si;
            }
        }
        return Math.sqrt(sum1 * sum1 + sum2 * sum2) / Math.sqrt(sum3 * sum4);
    }

    private static double powell(ComplexCoregData complexData, double[] p) {
        double[][] directions = new double[][]{{0.0, 1.0}, {1.0, 0.0}};
        double fp = GCPSelectionOp.computeCoherence(complexData, p);
        double[] p0 = new double[]{p[0], p[1]};
        double[] currentDirection = new double[]{0.0, 0.0};
        for (int iter = 0; iter < 200; ++iter) {
            double d2;
            double d1;
            p0[0] = p[0];
            p0[1] = p[1];
            double fp0 = fp;
            int imax = 0;
            double maxDecrement = 0.0;
            for (int i = 0; i < 2; ++i) {
                currentDirection[0] = directions[i][0];
                currentDirection[1] = directions[i][1];
                double fpc = fp;
                double decrement = Math.abs(fpc - (fp = GCPSelectionOp.linmin(complexData, p, currentDirection)));
                if (!(decrement > maxDecrement)) continue;
                maxDecrement = decrement;
                imax = i;
            }
            if (Math.abs(fp0 - fp) < complexData.coherenceFuncToler) {
                return fp;
            }
            if (Math.sqrt((p0[0] - p[0]) * (p0[0] - p[0]) + (p0[1] - p[1]) * (p0[1] - p[1])) < complexData.coherenceValueToler) {
                return fp;
            }
            double[] averageDirection = new double[]{p[0] - p0[0], p[1] - p0[1]};
            double norm = Math.sqrt(averageDirection[0] * averageDirection[0] + averageDirection[1] * averageDirection[1]);
            int j = 0;
            while (j < 2) {
                int n = j++;
                averageDirection[n] = averageDirection[n] / norm;
            }
            double fpe = GCPSelectionOp.linmin(complexData, p, averageDirection);
            if (!(fpe < fp0) || !(2.0 * (fp0 - 2.0 * fp + fpe) * (d1 = (fp0 - fp - maxDecrement) * (fp0 - fp - maxDecrement)) < maxDecrement * (d2 = (fp0 - fpe) * (fp0 - fpe)))) continue;
            for (int j2 = 0; j2 < 2; ++j2) {
                directions[imax][j2] = directions[1][j2];
                directions[1][j2] = averageDirection[j2];
            }
        }
        return fp;
    }

    private static double linmin(ComplexCoregData complexData, double[] p, double[] xi) {
        double[] bracketPoints = new double[]{0.0, 0.02, 0.0};
        GCPSelectionOp.mnbrak(complexData, bracketPoints, p, xi);
        return GCPSelectionOp.brent(complexData, bracketPoints, p, xi);
    }

    private static void mnbrak(ComplexCoregData complexData, double[] bracketPoints, double[] p, double[] xi) {
        double ax = bracketPoints[0];
        double bx = bracketPoints[1];
        double fa = GCPSelectionOp.computeCoherence(complexData, ax, p, xi);
        double fb = GCPSelectionOp.computeCoherence(complexData, bx, p, xi);
        if (fb > fa) {
            double tmp = ax;
            ax = bx;
            bx = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        double cx = bx + 1.618034 * (bx - ax);
        double fc = GCPSelectionOp.computeCoherence(complexData, cx, p, xi);
        while (fb > fc) {
            double fu;
            double r = (bx - ax) * (fb - fc);
            double q = (bx - cx) * (fb - fa);
            double u = bx - ((bx - cx) * q - (bx - ax) * r) / (2.0 * GCPSelectionOp.sign(Math.max(Math.abs(q - r), 1.0E-20), q - r));
            double ulim = bx + 100.0 * (cx - bx);
            if ((bx - u) * (u - cx) > 0.0) {
                fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
                if (fu < fc) {
                    ax = bx;
                    bx = u;
                    break;
                }
                if (fu > fb) {
                    cx = u;
                    break;
                }
                u = cx + 1.618034 * (cx - bx);
                fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
            } else if ((cx - u) * (u - ulim) > 0.0) {
                fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
                if (fu < fc) {
                    bx = cx;
                    cx = u;
                    u = cx + 1.618034 * (cx - bx);
                    fb = fc;
                    fc = fu;
                    fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
                }
            } else if ((u - ulim) * (ulim - cx) >= 0.0) {
                u = ulim;
                fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
            } else {
                u = cx + 1.618034 * (cx - bx);
                fu = GCPSelectionOp.computeCoherence(complexData, u, p, xi);
            }
            ax = bx;
            bx = cx;
            cx = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        bracketPoints[0] = ax;
        bracketPoints[1] = bx;
        bracketPoints[2] = cx;
    }

    private static double brent(ComplexCoregData complexData, double[] bracketPoints, double[] pp, double[] xi) {
        double fw;
        int maxNumIterations = 100;
        double ax = bracketPoints[0];
        double bx = bracketPoints[1];
        double cx = bracketPoints[2];
        double d = 0.0;
        double u = 0.0;
        double e = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double x = bx;
        double w = bx;
        double v = bx;
        double fv = fw = GCPSelectionOp.computeCoherence(complexData, x, pp, xi);
        double fx = fw;
        for (int iter = 0; iter < 100; ++iter) {
            double xm = 0.5 * (a + b);
            double tol1 = 2.0E-4 * Math.abs(x) + 1.0E-10;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                xi[0] = xi[0] * x;
                xi[1] = xi[1] * x;
                pp[0] = pp[0] + xi[0];
                pp[1] = pp[1] + xi[1];
                return fx;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    e = x >= xm ? a - x : b - x;
                    d = 0.381966 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = GCPSelectionOp.sign(tol1, xm - x);
                    }
                }
            } else {
                e = x >= xm ? a - x : b - x;
                d = 0.381966 * e;
            }
            u = Math.abs(d) >= tol1 ? x + d : x + GCPSelectionOp.sign(tol1, d);
            double fu = GCPSelectionOp.computeCoherence(complexData, u, pp, xi);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                w = u;
                fv = fw;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
        }
        System.out.println("Too many iterations in brent");
        return -1.0;
    }

    private static double sign(double a, double b) {
        if (b >= 0.0) {
            return a;
        }
        return -a;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GCPSelectionOp.class);
        }
    }

    private static class ComplexCoregData {
        private double[][] mII = null;
        private double[][] mIQ = null;
        private double[][] sII = null;
        private double[][] sIQ = null;
        private double[][] sII0 = null;
        private double[][] sIQ0 = null;
        final double[] point0 = new double[2];
        private final int coherenceWindowSize;
        private final double coherenceFuncToler;
        private final double coherenceValueToler;
        private final int fWindowWidth;
        private final int fWindowHeight;
        private final int fHalfWindowWidth;
        private final int fHalfWindowHeight;
        private final int fTwoWindowWidth;
        private final int fTwoWindowHeight;
        private final boolean useSlidingWindow;

        ComplexCoregData(int coherenceWindowSize, double coherenceFuncToler, double coherenceValueToler, int fWindowWidth, int fWindowHeight, boolean useSlidingWindow) {
            this.coherenceWindowSize = coherenceWindowSize;
            this.coherenceFuncToler = coherenceFuncToler;
            this.coherenceValueToler = coherenceValueToler;
            this.fWindowWidth = fWindowWidth;
            this.fWindowHeight = fWindowHeight;
            this.fHalfWindowWidth = fWindowWidth / 2;
            this.fHalfWindowHeight = fWindowHeight / 2;
            this.fTwoWindowWidth = fWindowWidth * 2;
            this.fTwoWindowHeight = fWindowHeight * 2;
            this.useSlidingWindow = useSlidingWindow;
        }

        void dispose() {
            this.mII = null;
            this.mIQ = null;
            this.sII = null;
            this.sIQ = null;
            this.sII0 = null;
            this.sIQ0 = null;
        }

        static /* synthetic */ double[][] access$702(ComplexCoregData x0, double[][] x1) {
            x0.mII = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$1002(ComplexCoregData x0, double[][] x1) {
            x0.mIQ = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$1302(ComplexCoregData x0, double[][] x1) {
            x0.sII0 = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$1402(ComplexCoregData x0, double[][] x1) {
            x0.sIQ0 = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$1702(ComplexCoregData x0, double[][] x1) {
            x0.sII = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$1802(ComplexCoregData x0, double[][] x1) {
            x0.sIQ = x1;
            return x1;
        }
    }
}

