/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.AppContext;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class GCPSelectionOpUI
extends BaseOperatorUI {
    private final JComboBox coarseRegistrationWindowWidth = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JComboBox coarseRegistrationWindowHeight = new JComboBox<String>(new String[]{"32", "64", "128", "256", "512", "1024", "2048"});
    private final JComboBox rowInterpFactor = new JComboBox<String>(new String[]{"2", "4", "8", "16"});
    private final JComboBox columnInterpFactor = new JComboBox<String>(new String[]{"2", "4", "8", "16"});
    private final JTextField numGCPtoGenerate = new JTextField("");
    private final JTextField maxIteration = new JTextField("");
    private final JTextField gcpTolerance = new JTextField("");
    final JCheckBox applyFineRegistrationCheckBox = new JCheckBox("Apply Fine Registration");
    private final JComboBox fineRegistrationWindowWidth = new JComboBox<String>(new String[]{"8", "16", "32", "64", "128", "256", "512"});
    private final JComboBox fineRegistrationWindowHeight = new JComboBox<String>(new String[]{"8", "16", "32", "64", "128", "256", "512"});
    private final JTextField coherenceWindowSize = new JTextField("");
    private final JTextField coherenceThreshold = new JTextField("");
    private final JRadioButton useSlidingWindow = new JRadioButton("Compute Coherence with Sliding Window");
    private boolean isComplex = false;
    private boolean applyFineRegistration = true;
    final JCheckBox computeOffsetCheckBox = new JCheckBox("Estimate Coarse Offset");
    private boolean computeOffset = false;
    final JCheckBox onlyGCPsOnLandCheckBox = new JCheckBox("Test GCPs are on land");
    private boolean onlyGCPsOnLand = false;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.applyFineRegistrationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GCPSelectionOpUI.this.applyFineRegistration = e.getStateChange() == 1;
                GCPSelectionOpUI.this.enableComplexFields();
            }
        });
        this.computeOffsetCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GCPSelectionOpUI.this.computeOffset = e.getStateChange() == 1;
            }
        });
        this.onlyGCPsOnLandCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GCPSelectionOpUI.this.onlyGCPsOnLand = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        this.numGCPtoGenerate.setText(String.valueOf(this.paramMap.get("numGCPtoGenerate")));
        this.coarseRegistrationWindowWidth.setSelectedItem(this.paramMap.get("coarseRegistrationWindowWidth"));
        this.coarseRegistrationWindowHeight.setSelectedItem(this.paramMap.get("coarseRegistrationWindowHeight"));
        this.rowInterpFactor.setSelectedItem(this.paramMap.get("rowInterpFactor"));
        this.columnInterpFactor.setSelectedItem(this.paramMap.get("columnInterpFactor"));
        this.maxIteration.setText(String.valueOf(this.paramMap.get("maxIteration")));
        this.gcpTolerance.setText(String.valueOf(this.paramMap.get("gcpTolerance")));
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            this.isComplex = OperatorUtils.isComplex((Product)this.sourceProducts[0]);
        }
        if (this.isComplex) {
            this.applyFineRegistration = (Boolean)this.paramMap.get("applyFineRegistration");
            this.applyFineRegistrationCheckBox.setSelected(this.applyFineRegistration);
            this.fineRegistrationWindowWidth.setSelectedItem(this.paramMap.get("fineRegistrationWindowWidth"));
            this.fineRegistrationWindowHeight.setSelectedItem(this.paramMap.get("fineRegistrationWindowHeight"));
            this.coherenceWindowSize.setText(String.valueOf(this.paramMap.get("coherenceWindowSize")));
            this.coherenceThreshold.setText(String.valueOf(this.paramMap.get("coherenceThreshold")));
        }
        this.enableComplexFields();
        Boolean offsetValue = (Boolean)this.paramMap.get("computeOffset");
        if (offsetValue != null) {
            this.computeOffset = offsetValue;
        }
        this.computeOffsetCheckBox.setSelected(this.computeOffset);
        Boolean gcpOnLandValue = (Boolean)this.paramMap.get("onlyGCPsOnLand");
        if (gcpOnLandValue != null) {
            this.onlyGCPsOnLand = gcpOnLandValue;
        }
        this.onlyGCPsOnLandCheckBox.setSelected(this.onlyGCPsOnLand);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("numGCPtoGenerate", Integer.parseInt(this.numGCPtoGenerate.getText()));
        this.paramMap.put("coarseRegistrationWindowWidth", this.coarseRegistrationWindowWidth.getSelectedItem());
        this.paramMap.put("coarseRegistrationWindowHeight", this.coarseRegistrationWindowHeight.getSelectedItem());
        this.paramMap.put("rowInterpFactor", this.rowInterpFactor.getSelectedItem());
        this.paramMap.put("columnInterpFactor", this.columnInterpFactor.getSelectedItem());
        this.paramMap.put("maxIteration", Integer.parseInt(this.maxIteration.getText()));
        this.paramMap.put("gcpTolerance", Double.parseDouble(this.gcpTolerance.getText()));
        if (this.isComplex) {
            this.paramMap.put("applyFineRegistration", this.applyFineRegistration);
            if (this.applyFineRegistration) {
                this.paramMap.put("fineRegistrationWindowWidth", this.fineRegistrationWindowWidth.getSelectedItem());
                this.paramMap.put("fineRegistrationWindowHeight", this.fineRegistrationWindowHeight.getSelectedItem());
                this.paramMap.put("coherenceThreshold", Double.parseDouble(this.coherenceThreshold.getText()));
                if (this.useSlidingWindow.isSelected()) {
                    this.paramMap.put("useSlidingWindow", true);
                    this.paramMap.put("coherenceWindowSize", Integer.parseInt(this.coherenceWindowSize.getText()));
                } else {
                    this.paramMap.put("useSlidingWindow", false);
                }
            }
        }
        this.paramMap.put("computeOffset", this.computeOffset);
        this.paramMap.put("onlyGCPsOnLand", this.onlyGCPsOnLand);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Number of GCPs:", (JComponent)this.numGCPtoGenerate);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Coarse Registration Window Width:", (JComponent)this.coarseRegistrationWindowWidth);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Coarse Registration Window Height:", (JComponent)this.coarseRegistrationWindowHeight);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Row Interpolation Factor:", (JComponent)this.rowInterpFactor);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Column Interpolation Factor:", (JComponent)this.columnInterpFactor);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Max Iterations:", (JComponent)this.maxIteration);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"GCP Tolerance:", (JComponent)this.gcpTolerance);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.applyFineRegistrationCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Coherence Window Size:", (JComponent)this.coherenceWindowSize);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Coherence Threshold:", (JComponent)this.coherenceThreshold);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Fine Registration Window Width:", (JComponent)this.fineRegistrationWindowWidth);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Fine Registration Window Height:", (JComponent)this.fineRegistrationWindowHeight);
        ++gbc.gridy;
        gbc.gridx = 0;
        contentPane.add((Component)this.useSlidingWindow, gbc);
        this.enableComplexFields();
        this.useSlidingWindow.setSelected(true);
        this.useSlidingWindow.setActionCommand("Use Sliding Window:");
        RadioListener myListener = new RadioListener();
        this.useSlidingWindow.addActionListener(myListener);
        ++gbc.gridy;
        contentPane.add((Component)this.computeOffsetCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.onlyGCPsOnLandCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableComplexFields() {
        this.applyFineRegistrationCheckBox.setEnabled(this.isComplex);
        this.fineRegistrationWindowWidth.setEnabled(this.isComplex && this.applyFineRegistration);
        this.fineRegistrationWindowHeight.setEnabled(this.isComplex && this.applyFineRegistration);
        this.coherenceWindowSize.setEnabled(this.isComplex && this.applyFineRegistration);
        this.coherenceThreshold.setEnabled(this.isComplex && this.applyFineRegistration);
        this.useSlidingWindow.setEnabled(this.isComplex && this.applyFineRegistration);
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GCPSelectionOpUI.this.useSlidingWindow.isSelected()) {
                GCPSelectionOpUI.this.coherenceWindowSize.setEditable(true);
            } else {
                GCPSelectionOpUI.this.coherenceWindowSize.setEditable(false);
            }
        }
    }
}

