/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.image.BufferedImage;
import org.esa.beam.framework.datamodel.ProductData;

public class HaarWaveletTransform {
    private final int size;
    private final int sizeSqr;
    private int[] buffer = null;
    private int iterations;
    private int fractionalBits;

    public HaarWaveletTransform(int size) {
        this(size, -1, -1);
    }

    public HaarWaveletTransform(int size, int iterations, int fractionalBits) {
        if (size <= 0) {
            throw new IllegalArgumentException("size not strictly positive");
        }
        if (size > 4096) {
            throw new IllegalArgumentException("size too large to support int size arithmetic");
        }
        this.size = size;
        this.sizeSqr = size * size;
        this.setIterations(iterations);
        this.setFractionalBits(fractionalBits);
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getFractionalBits() {
        return this.fractionalBits;
    }

    public void setIterations(int iterations) {
        if (iterations < 0) {
            iterations = Integer.numberOfTrailingZeros(this.size);
        }
        if (1 << iterations > this.size) {
            throw new IllegalArgumentException("too many iterations for size");
        }
        this.iterations = iterations;
    }

    public void setFractionalBits(int fractionalBits) {
        if (fractionalBits < 0) {
            fractionalBits = this.iterations << 1;
        }
        if (fractionalBits > 23) {
            throw new IllegalArgumentException("fractionalBits exceeds 23, the largest storable in an int");
        }
        this.fractionalBits = fractionalBits;
    }

    public int[] filter(ProductData[] values, int[] filter) {
        int i;
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        if (filter == null) {
            filter = new int[this.sizeSqr];
        } else if (filter.length != this.sizeSqr) {
            throw new IllegalArgumentException("filter array incorrect length");
        }
        if (this.buffer == null) {
            this.buffer = new int[this.sizeSqr];
        }
        for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < this.size; ++j) {
                filter[i] = values[i].getElemIntAt(j) & 0xFF;
            }
        }
        for (i = 0; i < this.iterations; ++i) {
            int length = this.size >> i;
            int[] s = filter;
            int hOffset = length >> 1;
            for (int y = 0; y < length; ++y) {
                int sIndex;
                int tIndex = sIndex = y * this.size;
                for (int x = 0; x < length; x += 2) {
                    int a = s[sIndex];
                    int b = s[sIndex + 1];
                    sIndex += 2;
                    ++tIndex;
                }
            }
            s = this.buffer;
            int vOffset = (length >> 1) * this.size;
            for (int x = 0; x < length; ++x) {
                int tIndex;
                int sIndex = tIndex = x;
                for (int y = 0; y < length; y += 2) {
                    int a = s[sIndex];
                    int b = s[sIndex + this.size];
                    sIndex += this.size << 1;
                    tIndex += this.size;
                }
            }
            length <<= 1;
        }
        this.normalize(filter);
        return filter;
    }

    public byte[] invert(int[] filter, byte[] values) {
        int i;
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        if (filter.length != this.sizeSqr) {
            throw new IllegalArgumentException("filter array incorrect length");
        }
        if (values == null) {
            values = new byte[this.sizeSqr];
        } else if (values.length != this.sizeSqr) {
            throw new IllegalArgumentException("values array incorrect length");
        }
        if (this.buffer == null) {
            this.buffer = new int[this.sizeSqr];
        }
        for (i = this.iterations - 1; i >= 0; --i) {
            int length = this.size >> i;
            int[] s = filter;
            int[] t = this.buffer;
            int vOffset = (length >> 1) * this.size;
            for (int x = 0; x < length; ++x) {
                int tIndex;
                int sIndex = tIndex = x;
                for (int y = 0; y < length; y += 2) {
                    int a = s[sIndex];
                    int b = s[sIndex + vOffset];
                    t[tIndex] = a + b;
                    t[tIndex + this.size] = a - b;
                    sIndex += this.size;
                    tIndex += this.size << 1;
                }
            }
            s = this.buffer;
            t = filter;
            int hOffset = length >> 1;
            for (int y = 0; y < length; ++y) {
                int sIndex;
                int tIndex = sIndex = y * this.size;
                for (int x = 0; x < length; x += 2) {
                    int a = s[sIndex];
                    int b = s[sIndex + hOffset];
                    t[tIndex] = a + b;
                    t[tIndex + 1] = a - b;
                    ++sIndex;
                    tIndex += 2;
                }
            }
            length >>= 1;
        }
        for (i = 0; i < values.length; ++i) {
            int value = filter[i] >> this.fractionalBits;
            if (value > 255) {
                value = 255;
            } else if (value < 0) {
                value = 0;
            }
            values[i] = (byte)value;
        }
        return values;
    }

    public BufferedImage filterToImage(int[] filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        if (filter.length != this.sizeSqr) {
            throw new IllegalArgumentException("filter array incorrect length");
        }
        byte[] data = new byte[filter.length];
        int shift = this.fractionalBits + 1;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(128 + (filter[i] >> shift));
        }
        BufferedImage image = new BufferedImage(this.size, this.size, 10);
        image.getWritableTile(0, 0).setDataElements(0, 0, this.size, this.size, data);
        image.releaseWritableTile(0, 0);
        return image;
    }

    public BufferedImage valuesToImage(byte[] values) {
        if (values == null) {
            throw new IllegalArgumentException("null values");
        }
        if (values.length != this.sizeSqr) {
            throw new IllegalArgumentException("values array incorrect length");
        }
        BufferedImage image = new BufferedImage(this.size, this.size, 10);
        image.getWritableTile(0, 0).setDataElements(0, 0, this.size, this.size, values);
        image.releaseWritableTile(0, 0);
        return image;
    }

    private void normalize(int[] filter) {
        int shiftD = -2;
        int shiftY = (this.iterations << 1) - this.fractionalBits;
        int nextY = this.size >> this.iterations - 1;
        for (int y = 0; y < this.size; ++y) {
            if (y == nextY) {
                shiftY += shiftD;
                nextY <<= 1;
            }
            int i = y * this.size;
            int nextX = nextY;
            int shiftX = shiftY;
            for (int x = 0; x < this.size; ++x) {
                if (x == nextX) {
                    shiftX += shiftD;
                    nextX <<= 1;
                }
                if (shiftX > 0) {
                    int n = i;
                    filter[n] = filter[n] >> shiftX;
                } else if (shiftX < 0) {
                    int n = i;
                    filter[n] = filter[n] << -shiftX;
                }
                ++i;
            }
        }
    }
}

