/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.nest.gpf.HaarWaveletTransform;
import org.esa.nest.math.Transform;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.exceptions.JWaveFailure;
import org.esa.nest.math.transforms.BasicTransform;
import org.esa.nest.math.transforms.DiscreteFourierTransform;
import org.esa.nest.math.transforms.FastWaveletTransform;
import org.esa.nest.math.transforms.WaveletPacketTransform;
import org.esa.nest.math.transforms.wavelets.Haar1;
import org.esa.nest.math.transforms.wavelets.Wavelet;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet1;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies2;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies3;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies4;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre1;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre2;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre3;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.gpf.ThreadManager;
import org.esa.snap.gpf.TileIndex;
import org.esa.snap.util.ResourceUtils;

@OperatorMetadata(alias="Principle-Components", description="Principle Component Analysis", category="Classification/Primitive Features")
public class HaarWaveletTransformOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    String waveletTypeList = "Haar1, Daubechies2, Daubechies4, Legendre1";
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"DFT", "FWT", "WPT", "DWT"}, defaultValue="DFT", label="Transform Type:")
    private final String transformType = "DFT";
    @Parameter(valueSet={"Haar1", "Daubechies2", "Daubechies4", "Legendre1"}, defaultValue="Haar1", label="Wavelet Type:")
    private final String waveletType = "haar02";
    @Parameter(description="The number of steps forward and reverse; optional", interval="(0, 1000]", defaultValue="10", label="Number Of Steps")
    private int noOfSteps = 10;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean statsCalculated = false;
    private int numOfPixels = 0;
    private int numOfSourceBands = 0;
    public static final String DFT = "DFT";
    public static final String FWT = "FWT";
    private static final String WPT = "WPT";
    private static final String DWT = "DWT";
    private double totalEigenvalues;
    private boolean pcaImageComputed = false;
    private double[][] eigenVectorMatrices = null;
    private double[] eigenValues = null;
    private double[] minPCA = null;
    private HaarWaveletTransform haar = null;
    private Transform t;
    Wavelet wavelet;
    BasicTransform bWave;
    private int halfFilterSize = 0;
    private int filterSize = 5;

    public Transform getT() {
        return this.t;
    }

    public HaarWaveletTransformOp() {
        try {
            this.setInitialValues();
        }
        catch (JWaveFailure ex) {
            Logger.getLogger(HaarWaveletTransformOp.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.t = new Transform(this.bWave);
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    public void initialize() throws OperatorException {
        try {
            if (DFT.equals(FWT) && this.noOfSteps > this.sourceBandNames.length) {
                throw new OperatorException("The number of eigenvalues should not be greater than the number of selected bands");
            }
            this.getSourceImageDimension();
            this.createTargetProduct();
            this.addSelectedBands();
        }
        catch (OperatorException e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void setRefinedLeeParameters() {
        this.filterSize = 5;
        this.halfFilterSize = this.filterSize / 2;
    }

    private void setInitialValues() throws JWaveFailure {
        if ("haar02".equalsIgnoreCase("haar02")) {
            this.wavelet = new Haar1();
        } else if ("haar02".equalsIgnoreCase("lege02")) {
            this.wavelet = new Legendre1();
        } else if ("haar02".equalsIgnoreCase("daub02")) {
            this.wavelet = new Daubechies2();
        } else if ("haar02".equalsIgnoreCase("daub03")) {
            this.wavelet = new Daubechies3();
        } else if ("haar02".equalsIgnoreCase("daub04")) {
            this.wavelet = new Daubechies4();
        } else if ("haar02".equalsIgnoreCase("lege04")) {
            this.wavelet = new Legendre2();
        } else if ("haar02".equalsIgnoreCase("lege06")) {
            this.wavelet = new Legendre3();
        } else if ("haar02".equalsIgnoreCase("coif06")) {
            this.wavelet = new Coiflet1();
        } else {
            System.err.println("usage: JWave [transformType] {waveletType}");
            System.err.println("");
            System.err.println("available wavelets are " + this.waveletTypeList);
            return;
        }
        if (DFT.equalsIgnoreCase("dft")) {
            this.bWave = new DiscreteFourierTransform();
        } else if (DFT.equalsIgnoreCase("fwt")) {
            this.bWave = new FastWaveletTransform(this.wavelet);
        } else if (DFT.equalsIgnoreCase("wpt")) {
            this.bWave = new WaveletPacketTransform(this.wavelet);
        } else {
            System.err.println("usage: JWave [transformType] {waveletType}");
            System.err.println("");
            System.err.println("available transforms are DFT, FWT, WPT");
            return;
        }
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.targetProduct.setDescription(this.sourceProduct.getDescription());
        this.numOfPixels = this.sourceProduct.getSceneRasterWidth() * this.sourceProduct.getSceneRasterHeight();
    }

    private void addSelectedBands() {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            for (Band band : bands) {
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        this.numOfSourceBands = this.sourceBandNames.length;
        if (this.numOfSourceBands <= 1) {
            throw new OperatorException("For PCA, more than one band should be selected");
        }
        Band sourcerBand = this.sourceProduct.getBand(this.sourceBandNames[0]);
        if (sourcerBand == null) {
            throw new OperatorException("Source band not found: " + sourcerBand);
        }
        int imageWidth = sourcerBand.getRasterWidth();
        int imageHeight = sourcerBand.getRasterHeight();
        String unit = sourcerBand.getUnit();
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            String targetBandName = "TB" + i;
            Band targetBand = new Band(targetBandName, 30, imageWidth, imageHeight);
            targetBand.setUnit(unit);
            this.targetProduct.addBand(targetBand);
        }
    }

    private static void createMeanImageVirtualBand(Product sourceProduct, String[] sourceBandNames, String meanImageBandName) {
        if (sourceProduct.getBand(meanImageBandName) != null) {
            return;
        }
        boolean isFirstBand = true;
        String unit = "";
        String expression = "( ";
        for (String bandName : sourceBandNames) {
            if (isFirstBand) {
                expression = expression + bandName;
                unit = sourceProduct.getBand(bandName).getUnit();
                isFirstBand = false;
                continue;
            }
            expression = expression + " + " + bandName;
        }
        expression = expression + " ) / " + sourceBandNames.length;
        VirtualBand band = new VirtualBand(meanImageBandName, 30, sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight(), expression);
        band.setUnit(unit);
        band.setDescription("Mean image");
        sourceProduct.addBand((Band)band);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int i;
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            int maxY = y0 + h;
            int maxX = x0 + w;
            Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h);
            int sx0 = sourceRectangle.x;
            int sy0 = sourceRectangle.y;
            int sw = sourceRectangle.width;
            int sh = sourceRectangle.height;
            int filterSize2 = this.filterSize * this.filterSize;
            double[][] neighborSpanValues = new double[this.filterSize][this.filterSize];
            double[][] neighborPixelValues = new double[this.filterSize][this.filterSize];
            int syMax = sy0 + sh;
            int sxMax = sx0 + sw;
            ProductData[] bandsRawSamples = new ProductData[this.numOfSourceBands];
            for (i = 0; i < this.numOfSourceBands; ++i) {
                bandsRawSamples[i] = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(this.sourceBandNames[i]), targetRectangle).getRawSamples();
            }
            for (i = 0; i < this.numOfSourceBands; ++i) {
                Band targetBand = this.targetProduct.getBand("TB" + i);
                Tile targetTile = targetTileMap.get(targetBand);
                ProductData trgData = targetTile.getDataBuffer();
                TileIndex targetIndex = new TileIndex(targetTile);
                ProductData dataBuffer = targetTile.getDataBuffer();
                int k = 0;
                for (int y = y0; y < y0 + h; ++y) {
                    targetIndex.calculateStride(y);
                    for (int x = x0; x < x0 + w; ++x) {
                        int j;
                        int index = targetIndex.getIndex(x);
                        double[][] v = new double[this.numOfSourceBands][bandsRawSamples[i].getNumElems()];
                        for (j = 0; j < this.numOfSourceBands; ++j) {
                            v[j][k] = bandsRawSamples[j].getElemDoubleAt(k);
                            System.err.print(String.valueOf(v[j][k]) + " ");
                        }
                        System.err.println();
                        double[][] arrFreqOrHilb = this.t.forward(v);
                        for (j = 0; j < this.numOfSourceBands; ++j) {
                            System.err.print(String.valueOf(bandsRawSamples[j].getElemDoubleAt(k)) + " ");
                        }
                        System.err.println();
                        ++k;
                    }
                }
            }
        }
        catch (OperatorException e) {
            throw new OperatorException((Throwable)e);
        }
        catch (JWaveException ex) {
            Logger.getLogger(HaarWaveletTransformOp.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            pm.done();
        }
        this.pcaImageComputed = true;
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h) {
        int sx0 = x0;
        int sy0 = y0;
        int sw = w;
        int sh = h;
        if (x0 >= this.halfFilterSize) {
            sx0 -= this.halfFilterSize;
            sw += this.halfFilterSize;
        }
        if (y0 >= this.halfFilterSize) {
            sy0 -= this.halfFilterSize;
            sh += this.halfFilterSize;
        }
        if (x0 + w + this.halfFilterSize <= this.sourceImageWidth) {
            sw += this.halfFilterSize;
        }
        if (y0 + h + this.halfFilterSize <= this.sourceImageHeight) {
            sh += this.halfFilterSize;
        }
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private synchronized void calculateStatistics() {
        if (this.statsCalculated) {
            return;
        }
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = HaarWaveletTransformOp.getAllTileRectangles(this.sourceProduct, tileSize);
        this.processStatistics(tileRectangles);
        this.processMin(tileRectangles);
        this.statsCalculated = true;
    }

    private static Rectangle[] getAllTileRectangles(Product sourceProduct, Dimension tileSize) {
        int rasterHeight = sourceProduct.getSceneRasterHeight();
        int rasterWidth = sourceProduct.getSceneRasterWidth();
        Rectangle boundary = new Rectangle(rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(tileX * tileSize.width, tileY * tileSize.height, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    private void processStatistics(Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing Statistics... ");
        int tileCnt = 0;
        ThreadManager threadManager = new ThreadManager();
        try {
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    final ProductData[] bandsRawSamples;
                    final double[] tileSum;
                    final double[][] tileSumCross;
                    {
                        this.bandsRawSamples = new ProductData[HaarWaveletTransformOp.this.numOfSourceBands];
                        this.tileSum = new double[HaarWaveletTransformOp.this.numOfSourceBands];
                        this.tileSumCross = new double[HaarWaveletTransformOp.this.numOfSourceBands][HaarWaveletTransformOp.this.numOfSourceBands];
                    }

                    @Override
                    public void run() {
                        for (int i = 0; i < HaarWaveletTransformOp.this.numOfSourceBands; ++i) {
                            this.bandsRawSamples[i] = HaarWaveletTransformOp.this.getSourceTile((RasterDataNode)HaarWaveletTransformOp.this.sourceProduct.getBand(HaarWaveletTransformOp.this.sourceBandNames[i]), rectangle).getRawSamples();
                        }
                        HaarWaveletTransformOp.computeTileStatisticsWithoutMeanImageSubstract(HaarWaveletTransformOp.this.numOfSourceBands, this.bandsRawSamples, this.tileSum, this.tileSumCross);
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            threadManager.finish();
            this.completeStatistics();
        }
        catch (InterruptedException e) {
            throw new OperatorException((Throwable)e);
        }
        finally {
            status.done();
        }
    }

    private void processMin(Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing Min... ");
        int tileCnt = 0;
        ThreadManager threadManager = new ThreadManager();
        try {
            this.initializeMin();
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    final double[] tileMinPCA;
                    final ProductData[] bandsRawSamples;
                    {
                        this.tileMinPCA = new double[HaarWaveletTransformOp.this.numOfSourceBands];
                        this.bandsRawSamples = new ProductData[HaarWaveletTransformOp.this.numOfSourceBands];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (int i = 0; i < HaarWaveletTransformOp.this.numOfSourceBands; ++i) {
                            this.bandsRawSamples[i] = HaarWaveletTransformOp.this.getSourceTile((RasterDataNode)HaarWaveletTransformOp.this.sourceProduct.getBand(HaarWaveletTransformOp.this.sourceBandNames[i]), rectangle).getRawSamples();
                        }
                        int n = this.bandsRawSamples[0].getNumElems();
                        Arrays.fill(this.tileMinPCA, Double.MAX_VALUE);
                        for (int i = 0; i < HaarWaveletTransformOp.this.noOfSteps; ++i) {
                            for (int k = 0; k < n; ++k) {
                                double vPCA = 0.0;
                                for (int j = 0; j < HaarWaveletTransformOp.this.numOfSourceBands; ++j) {
                                    vPCA += this.bandsRawSamples[j].getElemDoubleAt(k) * HaarWaveletTransformOp.this.eigenVectorMatrices[j][i];
                                }
                                if (!(vPCA < this.tileMinPCA[i])) continue;
                                this.tileMinPCA[i] = vPCA;
                            }
                        }
                        double[] dArray = HaarWaveletTransformOp.this.minPCA;
                        synchronized (dArray) {
                            HaarWaveletTransformOp.this.computePCAMin(this.tileMinPCA);
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            threadManager.finish();
        }
        catch (InterruptedException e) {
            throw new OperatorException((Throwable)e);
        }
        finally {
            status.done();
        }
    }

    private static void computeTileStatisticsWithoutMeanImageSubstract(int numOfSourceBands, ProductData[] bandsRawSamples, double[] tileSum, double[][] tileSumCross) {
        Arrays.fill(tileSum, 0.0);
        int n = bandsRawSamples[0].getNumElems();
        for (int i = 0; i < numOfSourceBands; ++i) {
            Arrays.fill(tileSumCross[i], 0.0);
            for (int j = 0; j <= i; ++j) {
                double vi;
                int k;
                if (j < i) {
                    for (k = 0; k < n; ++k) {
                        vi = bandsRawSamples[i].getElemDoubleAt(k);
                        double vj = bandsRawSamples[j].getElemDoubleAt(k);
                        double[] dArray = tileSumCross[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + vi * vj;
                    }
                    continue;
                }
                for (k = 0; k < n; ++k) {
                    vi = bandsRawSamples[i].getElemDoubleAt(k);
                    int n3 = i;
                    tileSum[n3] = tileSum[n3] + vi;
                    double[] dArray = tileSumCross[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + vi * vi;
                }
            }
        }
    }

    private static void computeTileStatisticsWithMeanImageSubstract(int numOfSourceBands, ProductData[] bandsRawSamples, ProductData meanBandRawSamples, double[] tileSum, double[][] tileSumCross) {
        Arrays.fill(tileSum, 0.0);
        int n = bandsRawSamples[0].getNumElems();
        for (int i = 0; i < numOfSourceBands; ++i) {
            Arrays.fill(tileSumCross[i], 0.0);
            for (int j = 0; j <= i; ++j) {
                double vi;
                double vm;
                int k;
                if (j < i) {
                    for (k = 0; k < n; ++k) {
                        vm = meanBandRawSamples.getElemDoubleAt(k);
                        vi = bandsRawSamples[i].getElemDoubleAt(k) - vm;
                        double vj = bandsRawSamples[j].getElemDoubleAt(k) - vm;
                        double[] dArray = tileSumCross[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + vi * vj;
                    }
                    continue;
                }
                for (k = 0; k < n; ++k) {
                    vm = meanBandRawSamples.getElemDoubleAt(k);
                    vi = bandsRawSamples[i].getElemDoubleAt(k) - vm;
                    int n3 = i;
                    tileSum[n3] = tileSum[n3] + vi;
                    double[] dArray = tileSumCross[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + vi * vi;
                }
            }
        }
    }

    private void computeImageStatistics(double[] tileSum, double[][] tileSumCross) {
    }

    private void completeStatistics() {
    }

    private void initializeMin() {
        this.minPCA = new double[this.numOfSourceBands];
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.minPCA[i] = Double.MAX_VALUE;
        }
        this.computeEigenDecompositionOfCovarianceMatrix();
    }

    private void computePCAMin(double[] tileMinPCA) {
        for (int i = 0; i < this.noOfSteps; ++i) {
            if (!(tileMinPCA[i] < this.minPCA[i])) continue;
            this.minPCA[i] = tileMinPCA[i];
        }
    }

    private void computeEigenDecompositionOfCovarianceMatrix() {
        this.eigenVectorMatrices = new double[this.numOfSourceBands][this.numOfSourceBands];
        this.eigenValues = new double[this.numOfSourceBands];
        double[][] cov = new double[this.numOfSourceBands][this.numOfSourceBands];
        Matrix Cov = new Matrix(cov);
        SingularValueDecomposition Svd = Cov.svd();
        Matrix S = Svd.getS();
        Matrix U = Svd.getU();
        this.totalEigenvalues = 0.0;
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.eigenValues[i] = S.get(i, i);
            this.totalEigenvalues += this.eigenValues[i];
            for (int j = 0; j < this.numOfSourceBands; ++j) {
                this.eigenVectorMatrices[i][j] = U.get(i, j);
            }
        }
        if (DFT.equals(DFT)) {
            double sum = 0.0;
            for (int i = 0; i < this.numOfSourceBands; ++i) {
                sum += this.eigenValues[i];
            }
        }
    }

    public void dispose() {
        if (!this.pcaImageComputed) {
            return;
        }
        this.createReportFile();
    }

    private void createReportFile() {
        File appUserDir = new File(ResourceUtils.getApplicationUserDir((boolean)true).getAbsolutePath() + File.separator + "log");
        if (!appUserDir.exists()) {
            appUserDir.mkdirs();
        }
        File reportFile = new File(appUserDir, this.sourceProduct.getName() + "_pca_report.txt");
        try {
            FileOutputStream out = new FileOutputStream(reportFile);
            try (PrintStream p = new PrintStream(out);){
                int i;
                p.println();
                p.println("User Selected Bands: ");
                for (i = 0; i < this.numOfSourceBands; ++i) {
                    p.println("    " + this.sourceBandNames[i]);
                }
                p.println();
                if (DFT.equals(DFT)) {
                    p.println();
                }
                p.println("Number of PCA Images Output: " + this.noOfSteps);
                p.println();
                p.println("Normalized Eigenvalues: ");
                for (i = 0; i < this.numOfSourceBands; ++i) {
                    p.println("    " + this.eigenValues[i]);
                }
                p.println();
            }
        }
        catch (IOException exc) {
            throw new OperatorException((Throwable)exc);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(HaarWaveletTransformOp.class);
        }
    }
}

