/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.util.HashMap;
import org.esa.nest.gpf.ProbabilityState;

public class JointProbabilityState {
    public final HashMap<Integer, Double> jointProbMap = new HashMap();
    public final HashMap<Integer, Double> firstProbMap = new HashMap();
    public final HashMap<Integer, Double> secondProbMap = new HashMap();
    public final int jointMaxVal;
    public final int firstMaxVal;
    public final int secondMaxVal;

    public JointProbabilityState(double[] firstVector, double[] secondVector) {
        int vectorLength = firstVector.length;
        double doubleLength = firstVector.length;
        int[] firstNormalisedVector = new int[vectorLength];
        int[] secondNormalisedVector = new int[vectorLength];
        this.firstMaxVal = ProbabilityState.normaliseArray(firstVector, firstNormalisedVector);
        this.secondMaxVal = ProbabilityState.normaliseArray(secondVector, secondNormalisedVector);
        this.jointMaxVal = this.firstMaxVal * this.secondMaxVal;
        HashMap<Integer, Integer> jointCountMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> firstCountMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> secondCountMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < vectorLength; ++i) {
            int firstVal = firstNormalisedVector[i];
            int secondVal = secondNormalisedVector[i];
            int jointVal = firstVal + this.firstMaxVal * secondVal;
            Integer tmpKey = jointVal;
            Integer tmpValue = (Integer)jointCountMap.remove(tmpKey);
            if (tmpValue == null) {
                jointCountMap.put(tmpKey, 1);
            } else {
                jointCountMap.put(tmpKey, tmpValue + 1);
            }
            tmpKey = firstVal;
            tmpValue = (Integer)firstCountMap.remove(tmpKey);
            if (tmpValue == null) {
                firstCountMap.put(tmpKey, 1);
            } else {
                firstCountMap.put(tmpKey, tmpValue + 1);
            }
            tmpKey = secondVal;
            tmpValue = (Integer)secondCountMap.remove(tmpKey);
            if (tmpValue == null) {
                secondCountMap.put(tmpKey, 1);
                continue;
            }
            secondCountMap.put(tmpKey, tmpValue + 1);
        }
        for (Integer key : jointCountMap.keySet()) {
            this.jointProbMap.put(key, (double)((Integer)jointCountMap.get(key)).intValue() / doubleLength);
        }
        for (Integer key : firstCountMap.keySet()) {
            this.firstProbMap.put(key, (double)((Integer)firstCountMap.get(key)).intValue() / doubleLength);
        }
        for (Integer key : secondCountMap.keySet()) {
            this.secondProbMap.put(key, (double)((Integer)secondCountMap.get(key)).intValue() / doubleLength);
        }
    }
}

