/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Hashtable;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.DFTDescriptor;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.util.math.MathUtils;
import org.esa.nest.gpf.Entropy;
import org.esa.nest.gpf.JointProbabilityState;
import org.esa.snap.gpf.TileIndex;

public class MIRegistration {
    private int maxIteration = 2;
    private double gcpTolerance = 0.5;
    private Tile mTile = null;
    private Tile sTile = null;
    private ProductData mData = null;
    private ProductData sData = null;
    private int cWindowWidth = 0;
    private int cWindowHeight = 0;
    private int rowUpSamplingFactor = 0;
    private int colUpSamplingFactor = 0;
    private int cHalfWindowWidth;
    private int cHalfWindowHeight;
    private int slaveImageWidth = 0;
    private int slaveImageHeight = 0;

    public MIRegistration(int cWindowWidth, int cWindowHeight, int rowUpSamplingFactor, int colUpSamplingFactor, int maxIteration, double gcpTolerance, Tile mTile, ProductData mData, Tile sTile, ProductData sData, int slaveImageWidth, int slaveImageHeight) {
        if (!this.isPowerOfTwo(cWindowWidth) || !this.isPowerOfTwo(cWindowHeight)) {
            throw new OperatorException("Dimension of window for cross-xorrelation is not power of 2");
        }
        if (!this.isPowerOfTwo(rowUpSamplingFactor) || !this.isPowerOfTwo(colUpSamplingFactor)) {
            throw new OperatorException("Row or column up sampling factor is not power of 2");
        }
        this.cWindowWidth = cWindowWidth;
        this.cWindowHeight = cWindowHeight;
        this.cHalfWindowWidth = cWindowWidth / 2;
        this.cHalfWindowHeight = cWindowHeight / 2;
        this.rowUpSamplingFactor = rowUpSamplingFactor;
        this.colUpSamplingFactor = colUpSamplingFactor;
        this.maxIteration = maxIteration;
        this.gcpTolerance = gcpTolerance;
        double achievableAccuracy = 1.0 / (double)Math.max(rowUpSamplingFactor, colUpSamplingFactor);
        if (gcpTolerance < achievableAccuracy) {
            throw new OperatorException("The achievable accuracy with current interpolation factors is " + achievableAccuracy + ", GCP Tolerance is below it.");
        }
        this.mTile = mTile;
        this.sTile = sTile;
        this.mData = mData;
        this.sData = sData;
        this.slaveImageWidth = slaveImageWidth;
        this.slaveImageHeight = slaveImageHeight;
    }

    private boolean isPowerOfTwo(int value) {
        return (value & -value) == value;
    }

    public static strictfp double adjustedMutualInfoScore(double[] firstVector, double[] secondVector) {
        JointProbabilityState state = new JointProbabilityState(firstVector, secondVector);
        int numFirstStates = state.firstMaxVal;
        double mutualInformation = 0.0;
        for (Integer key : state.jointProbMap.keySet()) {
            double jointValue = state.jointProbMap.get(key);
            double firstValue = state.firstProbMap.get(key % numFirstStates);
            double secondValue = state.secondProbMap.get(key / numFirstStates);
            if (!(jointValue > 0.0) || !(firstValue > 0.0) || !(secondValue > 0.0)) continue;
            mutualInformation += jointValue * Math.log(jointValue / firstValue / secondValue);
        }
        return mutualInformation /= Math.log(Entropy.LOG_BASE);
    }

    public static strictfp double normalizedMutualInfoScore(double[] firstVector, double[] secondVector) {
        JointProbabilityState state = new JointProbabilityState(firstVector, secondVector);
        int numFirstStates = state.firstMaxVal;
        double mutualInformation = 0.0;
        for (Integer key : state.jointProbMap.keySet()) {
            double jointValue = state.jointProbMap.get(key);
            double firstValue = state.firstProbMap.get(key % numFirstStates);
            double secondValue = state.secondProbMap.get(key / numFirstStates);
            if (!(jointValue > 0.0) || !(firstValue > 0.0) || !(secondValue > 0.0)) continue;
            mutualInformation += jointValue * Math.log(jointValue / firstValue / secondValue);
        }
        return mutualInformation /= Math.log(Entropy.LOG_BASE);
    }

    private boolean checkSlaveGCPValidity(PixelPos pixelPos) {
        return pixelPos.x - (float)this.cHalfWindowWidth + 1.0f >= 0.0f && pixelPos.x + (float)this.cHalfWindowWidth <= (float)(this.slaveImageWidth - 1) && pixelPos.y - (float)this.cHalfWindowHeight + 1.0f >= 0.0f && pixelPos.y + (float)this.cHalfWindowHeight <= (float)(this.slaveImageHeight - 1);
    }

    public boolean getCoarseSlaveGCPPosition(PixelPos mGCPPixelPos, PixelPos sGCPPixelPos) {
        double[] mI = this.getMasterImagette(this.mTile, this.mData, mGCPPixelPos);
        double rowShift = this.gcpTolerance + 1.0;
        double colShift = this.gcpTolerance + 1.0;
        int numIter = 0;
        while (Math.abs(rowShift) >= this.gcpTolerance || Math.abs(colShift) >= this.gcpTolerance) {
            if (numIter >= this.maxIteration) {
                return false;
            }
            if (!this.checkSlaveGCPValidity(sGCPPixelPos)) {
                return false;
            }
            double[] shift = new double[]{0.0, 0.0};
            double[] sI = this.getSlaveImagette(this.sTile, this.sData, sGCPPixelPos);
            if (!this.getSlaveGCPShift(shift, mI, sI)) {
                return false;
            }
            rowShift = shift[0];
            colShift = shift[1];
            sGCPPixelPos.x += (float)colShift;
            sGCPPixelPos.y += (float)rowShift;
            ++numIter;
        }
        return true;
    }

    private double[] getMasterImagette(Tile tile, ProductData data, PixelPos gcpPixelPos) {
        double[] imagette = new double[this.cWindowWidth * this.cWindowHeight];
        int xul = (int)gcpPixelPos.x - this.cHalfWindowWidth + 1;
        int yul = (int)gcpPixelPos.y - this.cHalfWindowHeight + 1;
        TileIndex index = new TileIndex(tile);
        int k = 0;
        for (int j = 0; j < this.cWindowHeight; ++j) {
            index.calculateStride(yul + j);
            for (int i = 0; i < this.cWindowWidth; ++i) {
                imagette[k++] = data.getElemDoubleAt(index.getIndex(xul + i));
            }
        }
        return imagette;
    }

    private double[] getSlaveImagette(Tile tile, ProductData data, PixelPos gcpPixelPos) throws OperatorException {
        double[] sI = new double[this.cWindowWidth * this.cWindowHeight];
        double xx = gcpPixelPos.x;
        double yy = gcpPixelPos.y;
        int k = 0;
        try {
            TileIndex index = new TileIndex(tile);
            for (int j = 0; j < this.cWindowHeight; ++j) {
                double y = yy - (double)this.cHalfWindowHeight + (double)j + 1.0;
                int y0 = (int)y;
                int y1 = y0 + 1;
                int offset0 = index.calculateStride(y0);
                int offset1 = index.calculateStride(y1);
                double wy = y - (double)y0;
                for (int i = 0; i < this.cWindowWidth; ++i) {
                    double x = xx - (double)this.cHalfWindowWidth + (double)i + 1.0;
                    int x0 = (int)x;
                    int x1 = x0 + 1;
                    double wx = x - (double)x0;
                    int x00 = x0 - offset0;
                    int x01 = x0 - offset1;
                    int x10 = x1 - offset0;
                    int x11 = x1 - offset1;
                    sI[k] = MathUtils.interpolate2D((double)wy, (double)wx, (double)data.getElemDoubleAt(x00), (double)data.getElemDoubleAt(x01), (double)data.getElemDoubleAt(x10), (double)data.getElemDoubleAt(x11));
                    ++k;
                }
            }
            return sI;
        }
        catch (Exception e) {
            System.out.println("Error in getSlaveImagette");
            throw new OperatorException((Throwable)e);
        }
    }

    private boolean getSlaveGCPShift(double[] shift, double[] mI, double[] sI) {
        try {
            PlanarImage crossCorrelatedImage = this.computeCrossCorrelatedImage(mI, sI);
            int w = crossCorrelatedImage.getWidth();
            int h = crossCorrelatedImage.getHeight();
            Raster idftData = crossCorrelatedImage.getData();
            double[] real = idftData.getSamples(0, 0, w, h, 0, (double[])null);
            int peakRow = 0;
            int peakCol = 0;
            double peak = real[0];
            for (int r = 0; r < h; ++r) {
                for (int c = 0; c < w; ++c) {
                    int k = r * w + c;
                    if (!(real[k] > peak)) continue;
                    peak = real[k];
                    peakRow = r;
                    peakCol = c;
                }
            }
            shift[0] = peakRow <= h / 2 ? (double)(-peakRow) / (double)this.rowUpSamplingFactor : (double)(h - peakRow) / (double)this.rowUpSamplingFactor;
            shift[1] = peakCol <= w / 2 ? (double)(-peakCol) / (double)this.colUpSamplingFactor : (double)(w - peakCol) / (double)this.colUpSamplingFactor;
            return true;
        }
        catch (Throwable t) {
            System.out.println("getSlaveGCPShift failed " + t.getMessage());
            return false;
        }
    }

    private PlanarImage computeCrossCorrelatedImage(double[] mI, double[] sI) {
        RenderedImage masterImage = MIRegistration.createRenderedImage(mI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage masterSpectrum = MIRegistration.dft(masterImage);
        RenderedImage slaveImage = MIRegistration.createRenderedImage(sI, this.cWindowWidth, this.cWindowHeight);
        PlanarImage slaveSpectrum = MIRegistration.dft(slaveImage);
        PlanarImage conjugateSlaveSpectrum = MIRegistration.conjugate(slaveSpectrum);
        PlanarImage crossSpectrum = MIRegistration.multiplyComplex(masterSpectrum, conjugateSlaveSpectrum);
        RenderedImage upsampledCrossSpectrum = this.upsampling(crossSpectrum);
        PlanarImage correlatedImage = MIRegistration.idft(upsampledCrossSpectrum);
        return MIRegistration.magnitude(correlatedImage);
    }

    private static RenderedImage createRenderedImage(double[] array, int w, int h) {
        SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)5, (int)w, (int)h, (int)1);
        ColorModel colourModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        DataBufferDouble dataBuffer = new DataBufferDouble(array, array.length);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (DataBuffer)dataBuffer, (Point)new Point(0, 0));
        return new BufferedImage(colourModel, raster, false, new Hashtable());
    }

    private static PlanarImage dft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_NONE);
        pb.add(DFTDescriptor.REAL_TO_COMPLEX);
        return JAI.create((String)"dft", (ParameterBlock)pb, null);
    }

    private static PlanarImage idft(RenderedImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(DFTDescriptor.SCALING_DIMENSIONS);
        pb.add(DFTDescriptor.COMPLEX_TO_COMPLEX);
        return JAI.create((String)"idft", (ParameterBlock)pb, null);
    }

    private static PlanarImage conjugate(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"conjugate", (ParameterBlock)pb, null);
    }

    private static PlanarImage multiplyComplex(PlanarImage image1, PlanarImage image2) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image1);
        pb.addSource(image2);
        return JAI.create((String)"MultiplyComplex", (ParameterBlock)pb, null);
    }

    private RenderedImage upsampling(PlanarImage image) {
        int topPad;
        int leftPad;
        int w = image.getWidth();
        int h = image.getHeight();
        int newWidth = this.rowUpSamplingFactor * w;
        int newHeight = this.colUpSamplingFactor * h;
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(image);
        pb1.add(w / 2);
        pb1.add(h / 2);
        RenderedOp shiftedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb1, null);
        ParameterBlock pb2 = new ParameterBlock();
        int rightPad = leftPad = (newWidth - w) / 2;
        int bottomPad = topPad = (newHeight - h) / 2;
        pb2.addSource(shiftedImage);
        pb2.add(leftPad);
        pb2.add(rightPad);
        pb2.add(topPad);
        pb2.add(bottomPad);
        pb2.add(BorderExtender.createInstance((int)0));
        RenderedOp zeroPaddedImage = JAI.create((String)"border", (ParameterBlock)pb2);
        ParameterBlock pb3 = new ParameterBlock();
        pb3.addSource(zeroPaddedImage);
        pb3.add(1.0f * (float)leftPad);
        pb3.add(1.0f * (float)topPad);
        RenderedOp zeroBorderedImage = JAI.create((String)"translate", (ParameterBlock)pb3, null);
        ParameterBlock pb4 = new ParameterBlock();
        pb4.addSource(zeroBorderedImage);
        pb4.add(newWidth / 2);
        pb4.add(newHeight / 2);
        RenderedOp shiftedZeroPaddedImage = JAI.create((String)"PeriodicShift", (ParameterBlock)pb4, null);
        return shiftedZeroPaddedImage;
    }

    private static PlanarImage magnitude(PlanarImage image) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"magnitude", (ParameterBlock)pb, null);
    }
}

