/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProducts;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.StackUtils;

@OperatorMetadata(alias="Multi-Input-Stack-Averaging", category="SAR Processing/Coregistration", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Averaging multi-temporal images")
public class MultiInputStackAveragingOp
extends Operator {
    @SourceProducts
    private Product[] sourceProducts;
    @TargetProduct
    private Product targetProduct;
    @Parameter(valueSet={"Mean Average", "Minimum", "Maximum", "Standard Deviation", "Coefficient of Variation"}, defaultValue="Mean Average", label="Statistic")
    private String statistic = "Mean Average";
    private BandInfo[] nameGroups;
    private Product sourceProduct = null;

    public void initialize() throws OperatorException {
        try {
            this.validateSourceProducts();
            this.createSourceProductStack();
            this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
            ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
            block16: for (BandInfo bandInfo : this.nameGroups = this.getBandGroupNames()) {
                if (bandInfo.isVirtual) {
                    this.addOriginalVirtualBands(bandInfo.name);
                    continue;
                }
                String name_prefix = bandInfo.name;
                Band[] sourceBands = this.getSourceBands(name_prefix);
                String unit = sourceBands[0].getUnit();
                double nodatavalue = sourceBands[0].getNoDataValue();
                switch (this.statistic) {
                    case "Mean Average": {
                        this.addVirtualBand("average", name_prefix, MultiInputStackAveragingOp.mean(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Minimum": {
                        this.addVirtualBand("min", name_prefix, MultiInputStackAveragingOp.min(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Maximum": {
                        this.addVirtualBand("max", name_prefix, MultiInputStackAveragingOp.max(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Standard Deviation": {
                        this.addVirtualBand("stddev", name_prefix, MultiInputStackAveragingOp.stddev(sourceBands), unit, nodatavalue);
                        continue block16;
                    }
                    case "Coefficient of Variation": {
                        this.addVirtualBand("coefVar", name_prefix, MultiInputStackAveragingOp.coefVar(sourceBands), unit, nodatavalue);
                    }
                }
            }
            this.updateMetadata(this.targetProduct);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void dispose() {
        for (BandInfo bandInfo : this.nameGroups) {
            Band srcBand = this.sourceProduct.getBand(bandInfo.name);
            if (srcBand == null) continue;
            this.sourceProduct.removeBand(srcBand);
        }
        this.sourceProduct.setModified(false);
    }

    private void validateSourceProducts() {
        if (this.sourceProducts.length < 2) {
            throw new OperatorException("Please select at least two source products");
        }
        int width = this.sourceProducts[0].getSceneRasterWidth();
        int height = this.sourceProducts[0].getSceneRasterHeight();
        for (int i = 1; i < this.sourceProducts.length; ++i) {
            if (this.sourceProducts[i].getSceneRasterWidth() == width && this.sourceProducts[i].getSceneRasterHeight() == height) continue;
            throw new OperatorException("Please select source products of the same dimension");
        }
    }

    private void createSourceProductStack() {
        this.sourceProduct = new Product(this.sourceProducts[0].getName(), this.sourceProducts[0].getProductType(), this.sourceProducts[0].getSceneRasterWidth(), this.sourceProducts[0].getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProducts[0], (Product)this.sourceProduct);
        int prodIdx = 0;
        for (Product product : this.sourceProducts) {
            Band[] sourceBands;
            for (Band band : sourceBands = product.getBands()) {
                String srcBandName = band.getName();
                String srcBandNameWithTimeStamp = srcBandName + "_" + String.valueOf(prodIdx);
                ProductUtils.copyBand((String)srcBandName, (Product)product, (String)srcBandNameWithTimeStamp, (Product)this.sourceProduct, (boolean)true);
            }
            ++prodIdx;
        }
    }

    private void updateMetadata(Product targetProduct) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"coregistered_stack", (int)0);
    }

    private BandInfo[] getBandGroupNames() {
        Band[] bands = this.sourceProduct.getBands();
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        ArrayList<BandInfo> bandGroup = new ArrayList<BandInfo>();
        for (Band band : bands) {
            String name = StackUtils.getBandNameWithoutDate((String)band.getName());
            if (nameSet.contains(name)) continue;
            nameSet.add(name);
            bandGroup.add(new BandInfo(band, name));
        }
        return bandGroup.toArray(new BandInfo[bandGroup.size()]);
    }

    private Band[] getSourceBands(String name_prefix) {
        Band[] bands = this.sourceProduct.getBands();
        ArrayList<Band> bandList = new ArrayList<Band>();
        for (Band band : bands) {
            if (band instanceof VirtualBand || !band.getName().startsWith(name_prefix)) continue;
            bandList.add(band);
        }
        return bandList.toArray(new Band[bandList.size()]);
    }

    private void addVirtualBand(String operation, String name_prefix, String expression, String unit, double nodatavalue) {
        VirtualBand virtBand = new VirtualBand(name_prefix, 30, this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight(), expression);
        virtBand.setUnit(unit);
        virtBand.setDescription(name_prefix + ' ' + operation + ' ' + unit);
        virtBand.setNoDataValueUsed(true);
        virtBand.setNoDataValue(nodatavalue);
        Band srcBand = this.sourceProduct.getBand(virtBand.getName());
        if (srcBand != null) {
            this.sourceProduct.removeBand(srcBand);
        }
        this.sourceProduct.addBand((Band)virtBand);
        ProductUtils.copyBand((String)name_prefix, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
    }

    private void addOriginalVirtualBands(String trgBandName) {
        Band[] srcBands = this.sourceProduct.getBands();
        Band virtSrcBand = null;
        for (Band band : srcBands) {
            if (!band.getName().startsWith(trgBandName) || !(band instanceof VirtualBand)) continue;
            virtSrcBand = band;
            break;
        }
        if (virtSrcBand == null) {
            return;
        }
        VirtualBand srcBand = (VirtualBand)virtSrcBand;
        String expression = srcBand.getExpression();
        for (Band b : srcBands) {
            String bName = b.getName();
            if (!expression.contains(bName) || this.nameGroupContains(bName)) continue;
            String newName = StackUtils.getBandNameWithoutDate((String)bName);
            expression = expression.replaceAll(bName, newName);
        }
        VirtualBand virtBand = new VirtualBand(trgBandName, srcBand.getDataType(), srcBand.getSceneRasterWidth(), srcBand.getSceneRasterHeight(), expression);
        virtBand.setUnit(srcBand.getUnit());
        virtBand.setDescription(srcBand.getDescription());
        virtBand.setNoDataValue(srcBand.getNoDataValue());
        virtBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
        this.targetProduct.addBand((Band)virtBand);
    }

    private boolean nameGroupContains(String name) {
        for (BandInfo b : this.nameGroups) {
            if (!name.equals(b.name)) continue;
            return true;
        }
        return false;
    }

    private static String mean(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append(band.getName());
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String min(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("min( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(", ");
                if (cnt < sourceBands.length - 1) {
                    expression.append("min( ");
                }
            }
            expression.append(band.getName());
            ++cnt;
        }
        for (int i = 0; i < sourceBands.length - 1; ++i) {
            expression.append(")");
        }
        return expression.toString();
    }

    private static String max(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("max( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(", ");
                if (cnt < sourceBands.length - 1) {
                    expression.append("max( ");
                }
            }
            expression.append(band.getName());
            ++cnt;
        }
        for (int i = 0; i < sourceBands.length - 1; ++i) {
            expression.append(")");
        }
        return expression.toString();
    }

    private static String mean2(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append("sqr(");
            expression.append(band.getName());
            expression.append(")");
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String mean4(Band[] sourceBands) {
        StringBuilder expression = new StringBuilder("( ");
        int cnt = 0;
        for (Band band : sourceBands) {
            if (cnt > 0) {
                expression.append(" + ");
            }
            expression.append("pow(");
            expression.append(band.getName());
            expression.append(", 4)");
            ++cnt;
        }
        expression.append(") / ");
        expression.append(sourceBands.length);
        return expression.toString();
    }

    private static String stddev(Band[] sourceBands) {
        return "sqrt( " + MultiInputStackAveragingOp.mean2(sourceBands) + " - " + "sqr(" + MultiInputStackAveragingOp.mean(sourceBands) + "))";
    }

    private static String coefVar(Band[] sourceBands) {
        String m2 = MultiInputStackAveragingOp.mean2(sourceBands);
        return "sqrt( " + MultiInputStackAveragingOp.mean4(sourceBands) + " - " + "sqr(" + m2 + ")) / " + m2;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MultiInputStackAveragingOp.class);
        }
    }

    private static class BandInfo {
        final String name;
        final boolean isVirtual;

        public BandInfo(Band band, String name) {
            this.name = name;
            this.isVirtual = band instanceof VirtualBand;
        }
    }
}

