/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;
import org.esa.snap.gpf.StatusProgressMonitor;
import org.esa.snap.gpf.ThreadManager;
import org.esa.snap.gpf.TileIndex;
import org.esa.snap.util.ResourceUtils;

@OperatorMetadata(alias="Principle-Components", description="Principle Component Analysis", category="Image Analysis/Primitive Features")
public class PCAOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", itemAlias="band", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(valueSet={"Eigenvalue Threshold", "Number of Eigenvalues"}, defaultValue="Eigenvalue Threshold", label="Select Eigenvalues By:")
    private String selectEigenvaluesBy = "Eigenvalue Threshold";
    @Parameter(description="The threshold for selecting eigenvalues", interval="(0, 100]", defaultValue="100", label="Eigenvalue Threshold (%)")
    private double eigenvalueThreshold = 100.0;
    @Parameter(description="The number of PCA images output", interval="(0, 100]", defaultValue="1", label="Number Of PCA Images")
    private int numPCA = 1;
    @Parameter(description="Show the eigenvalues", defaultValue="1", label="Show Eigenvalues")
    private Boolean showEigenvalues = false;
    @Parameter(description="Subtract mean image", defaultValue="1", label="Subtract Mean Image")
    private Boolean subtractMeanImage = false;
    private boolean statsCalculated = false;
    private int numOfPixels = 0;
    private int numOfSourceBands = 0;
    private double[] sum = null;
    private double[][] sumCross = null;
    private double[] mean = null;
    private double[][] meanCross = null;
    public static final String EIGENVALUE_THRESHOLD = "Eigenvalue Threshold";
    public static final String NUMBER_EIGENVALUES = "Number of Eigenvalues";
    private static final String meanImageBandName = "Mean_Image";
    private double totalEigenvalues;
    private boolean pcaImageComputed = false;
    private double[][] eigenVectorMatrices = null;
    private double[] eigenValues = null;
    private double[] minPCA = null;

    public void initialize() throws OperatorException {
        try {
            if (this.selectEigenvaluesBy.equals(NUMBER_EIGENVALUES) && this.numPCA > this.sourceBandNames.length) {
                throw new OperatorException("The number of eigenvalues should not be greater than the number of selected bands");
            }
            this.createTargetProduct();
            this.addSelectedBands();
            this.setInitialValues();
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
    }

    private void setInitialValues() {
        this.mean = new double[this.numOfSourceBands];
        this.meanCross = new double[this.numOfSourceBands][this.numOfSourceBands];
        this.sum = new double[this.numOfSourceBands];
        this.sumCross = new double[this.numOfSourceBands][this.numOfSourceBands];
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.sum[i] = 0.0;
            this.mean[i] = 0.0;
            for (int j = 0; j < this.numOfSourceBands; ++j) {
                this.sumCross[i][j] = 0.0;
                this.meanCross[i][j] = 0.0;
            }
        }
        this.numOfPixels = this.sourceProduct.getSceneRasterWidth() * this.sourceProduct.getSceneRasterHeight();
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyTiePointGrids((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.targetProduct.setDescription(this.sourceProduct.getDescription());
    }

    private void addSelectedBands() {
        if (this.sourceBandNames == null || this.sourceBandNames.length == 0) {
            Band[] bands = this.sourceProduct.getBands();
            ArrayList<String> bandNameList = new ArrayList<String>(this.sourceProduct.getNumBands());
            for (Band band : bands) {
                bandNameList.add(band.getName());
            }
            this.sourceBandNames = bandNameList.toArray(new String[bandNameList.size()]);
        }
        this.numOfSourceBands = this.sourceBandNames.length;
        if (this.numOfSourceBands <= 1) {
            throw new OperatorException("For PCA, more than one band should be selected");
        }
        Band sourcerBand = this.sourceProduct.getBand(this.sourceBandNames[0]);
        if (sourcerBand == null) {
            throw new OperatorException("Source band not found: " + sourcerBand);
        }
        if (this.selectEigenvaluesBy.equals(EIGENVALUE_THRESHOLD)) {
            this.numPCA = this.numOfSourceBands;
        }
        int imageWidth = sourcerBand.getRasterWidth();
        int imageHeight = sourcerBand.getRasterHeight();
        String unit = sourcerBand.getUnit();
        for (int i = 0; i < this.numPCA; ++i) {
            String targetBandName = "PC" + i;
            Band targetBand = new Band(targetBandName, 30, imageWidth, imageHeight);
            targetBand.setUnit(unit);
            this.targetProduct.addBand(targetBand);
        }
        if (this.subtractMeanImage.booleanValue()) {
            PCAOp.createMeanImageVirtualBand(this.sourceProduct, this.sourceBandNames, meanImageBandName);
        }
    }

    private static void createMeanImageVirtualBand(Product sourceProduct, String[] sourceBandNames, String meanImageBandName) {
        if (sourceProduct.getBand(meanImageBandName) != null) {
            return;
        }
        boolean isFirstBand = true;
        String unit = "";
        String expression = "( ";
        for (String bandName : sourceBandNames) {
            if (isFirstBand) {
                expression = expression + bandName;
                unit = sourceProduct.getBand(bandName).getUnit();
                isFirstBand = false;
                continue;
            }
            expression = expression + " + " + bandName;
        }
        expression = expression + " ) / " + sourceBandNames.length;
        VirtualBand band = new VirtualBand(meanImageBandName, 30, sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight(), expression);
        band.setUnit(unit);
        band.setDescription("Mean image");
        sourceProduct.addBand((Band)band);
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int i;
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            if (!this.statsCalculated) {
                this.calculateStatistics();
            }
            ProductData[] bandsRawSamples = new ProductData[this.numOfSourceBands];
            for (i = 0; i < this.numOfSourceBands; ++i) {
                bandsRawSamples[i] = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(this.sourceBandNames[i]), targetRectangle).getRawSamples();
            }
            for (i = 0; i < this.numPCA; ++i) {
                Band targetBand = this.targetProduct.getBand("PC" + i);
                Tile targetTile = targetTileMap.get(targetBand);
                ProductData trgData = targetTile.getDataBuffer();
                TileIndex targetIndex = new TileIndex(targetTile);
                int k = 0;
                for (int y = y0; y < y0 + h; ++y) {
                    targetIndex.calculateStride(y);
                    for (int x = x0; x < x0 + w; ++x) {
                        int index = targetIndex.getIndex(x);
                        double vPCA = 0.0;
                        for (int j = 0; j < this.numOfSourceBands; ++j) {
                            vPCA += bandsRawSamples[j].getElemDoubleAt(k) * this.eigenVectorMatrices[j][i];
                        }
                        ++k;
                        trgData.setElemDoubleAt(index, vPCA - this.minPCA[i]);
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
        finally {
            pm.done();
        }
        this.pcaImageComputed = true;
    }

    private synchronized void calculateStatistics() {
        if (this.statsCalculated) {
            return;
        }
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = PCAOp.getAllTileRectangles(this.sourceProduct, tileSize);
        this.processStatistics(tileRectangles);
        this.processMin(tileRectangles);
        this.statsCalculated = true;
    }

    private static Rectangle[] getAllTileRectangles(Product sourceProduct, Dimension tileSize) {
        int rasterHeight = sourceProduct.getSceneRasterHeight();
        int rasterWidth = sourceProduct.getSceneRasterWidth();
        Rectangle boundary = new Rectangle(rasterWidth, rasterHeight);
        int tileCountX = MathUtils.ceilInt((double)((double)boundary.width / (double)tileSize.width));
        int tileCountY = MathUtils.ceilInt((double)((double)boundary.height / (double)tileSize.height));
        Rectangle[] rectangles = new Rectangle[tileCountX * tileCountY];
        int index = 0;
        for (int tileY = 0; tileY < tileCountY; ++tileY) {
            for (int tileX = 0; tileX < tileCountX; ++tileX) {
                Rectangle intersection;
                Rectangle tileRectangle = new Rectangle(tileX * tileSize.width, tileY * tileSize.height, tileSize.width, tileSize.height);
                rectangles[index] = intersection = boundary.intersection(tileRectangle);
                ++index;
            }
        }
        return rectangles;
    }

    private void processStatistics(Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing Statistics... ");
        int tileCnt = 0;
        ThreadManager threadManager = new ThreadManager();
        try {
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    final ProductData[] bandsRawSamples;
                    final double[] tileSum;
                    final double[][] tileSumCross;
                    {
                        this.bandsRawSamples = new ProductData[PCAOp.this.numOfSourceBands];
                        this.tileSum = new double[PCAOp.this.numOfSourceBands];
                        this.tileSumCross = new double[PCAOp.this.numOfSourceBands][PCAOp.this.numOfSourceBands];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (int i = 0; i < PCAOp.this.numOfSourceBands; ++i) {
                            this.bandsRawSamples[i] = PCAOp.this.getSourceTile((RasterDataNode)PCAOp.this.sourceProduct.getBand(PCAOp.this.sourceBandNames[i]), rectangle).getRawSamples();
                        }
                        if (PCAOp.this.subtractMeanImage.booleanValue()) {
                            ProductData meanBandRawSamples = PCAOp.this.getSourceTile((RasterDataNode)PCAOp.this.sourceProduct.getBand(PCAOp.meanImageBandName), rectangle).getRawSamples();
                            PCAOp.computeTileStatisticsWithMeanImageSubstract(PCAOp.this.numOfSourceBands, this.bandsRawSamples, meanBandRawSamples, this.tileSum, this.tileSumCross);
                        } else {
                            PCAOp.computeTileStatisticsWithoutMeanImageSubstract(PCAOp.this.numOfSourceBands, this.bandsRawSamples, this.tileSum, this.tileSumCross);
                        }
                        double[] dArray = PCAOp.this.sum;
                        synchronized (dArray) {
                            PCAOp.this.computeImageStatistics(this.tileSum, this.tileSumCross);
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            threadManager.finish();
            this.completeStatistics();
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
        finally {
            status.done();
        }
    }

    private void processMin(Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor((float)tileRectangles.length, "Computing Min... ");
        int tileCnt = 0;
        ThreadManager threadManager = new ThreadManager();
        try {
            this.initializeMin();
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    final double[] tileMinPCA;
                    final ProductData[] bandsRawSamples;
                    {
                        this.tileMinPCA = new double[PCAOp.this.numOfSourceBands];
                        this.bandsRawSamples = new ProductData[PCAOp.this.numOfSourceBands];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        for (int i = 0; i < PCAOp.this.numOfSourceBands; ++i) {
                            this.bandsRawSamples[i] = PCAOp.this.getSourceTile((RasterDataNode)PCAOp.this.sourceProduct.getBand(PCAOp.this.sourceBandNames[i]), rectangle).getRawSamples();
                        }
                        int n = this.bandsRawSamples[0].getNumElems();
                        Arrays.fill(this.tileMinPCA, Double.MAX_VALUE);
                        for (int i = 0; i < PCAOp.this.numPCA; ++i) {
                            for (int k = 0; k < n; ++k) {
                                double vPCA = 0.0;
                                for (int j = 0; j < PCAOp.this.numOfSourceBands; ++j) {
                                    vPCA += this.bandsRawSamples[j].getElemDoubleAt(k) * PCAOp.this.eigenVectorMatrices[j][i];
                                }
                                if (!(vPCA < this.tileMinPCA[i])) continue;
                                this.tileMinPCA[i] = vPCA;
                            }
                        }
                        double[] dArray = PCAOp.this.minPCA;
                        synchronized (dArray) {
                            PCAOp.this.computePCAMin(this.tileMinPCA);
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(tileCnt++);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            throw new OperatorException(e);
        }
        finally {
            status.done();
        }
    }

    private static void computeTileStatisticsWithoutMeanImageSubstract(int numOfSourceBands, ProductData[] bandsRawSamples, double[] tileSum, double[][] tileSumCross) {
        Arrays.fill(tileSum, 0.0);
        int n = bandsRawSamples[0].getNumElems();
        for (int i = 0; i < numOfSourceBands; ++i) {
            Arrays.fill(tileSumCross[i], 0.0);
            for (int j = 0; j <= i; ++j) {
                double vi;
                int k;
                if (j < i) {
                    for (k = 0; k < n; ++k) {
                        vi = bandsRawSamples[i].getElemDoubleAt(k);
                        double vj = bandsRawSamples[j].getElemDoubleAt(k);
                        double[] dArray = tileSumCross[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + vi * vj;
                    }
                    continue;
                }
                for (k = 0; k < n; ++k) {
                    vi = bandsRawSamples[i].getElemDoubleAt(k);
                    int n3 = i;
                    tileSum[n3] = tileSum[n3] + vi;
                    double[] dArray = tileSumCross[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + vi * vi;
                }
            }
        }
    }

    private static void computeTileStatisticsWithMeanImageSubstract(int numOfSourceBands, ProductData[] bandsRawSamples, ProductData meanBandRawSamples, double[] tileSum, double[][] tileSumCross) {
        Arrays.fill(tileSum, 0.0);
        int n = bandsRawSamples[0].getNumElems();
        for (int i = 0; i < numOfSourceBands; ++i) {
            Arrays.fill(tileSumCross[i], 0.0);
            for (int j = 0; j <= i; ++j) {
                double vi;
                double vm;
                int k;
                if (j < i) {
                    for (k = 0; k < n; ++k) {
                        vm = meanBandRawSamples.getElemDoubleAt(k);
                        vi = bandsRawSamples[i].getElemDoubleAt(k) - vm;
                        double vj = bandsRawSamples[j].getElemDoubleAt(k) - vm;
                        double[] dArray = tileSumCross[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + vi * vj;
                    }
                    continue;
                }
                for (k = 0; k < n; ++k) {
                    vm = meanBandRawSamples.getElemDoubleAt(k);
                    vi = bandsRawSamples[i].getElemDoubleAt(k) - vm;
                    int n3 = i;
                    tileSum[n3] = tileSum[n3] + vi;
                    double[] dArray = tileSumCross[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + vi * vi;
                }
            }
        }
    }

    private void computeImageStatistics(double[] tileSum, double[][] tileSumCross) {
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            for (int j = 0; j <= i; ++j) {
                if (j < i) {
                    double[] dArray = this.sumCross[i];
                    int n = j;
                    dArray[n] = dArray[n] + tileSumCross[i][j];
                    continue;
                }
                int n = i;
                this.sum[n] = this.sum[n] + tileSum[i];
                double[] dArray = this.sumCross[i];
                int n2 = j;
                dArray[n2] = dArray[n2] + tileSumCross[i][j];
            }
        }
    }

    private void completeStatistics() {
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.mean[i] = this.sum[i] / (double)this.numOfPixels;
            for (int j = 0; j <= i; ++j) {
                this.meanCross[i][j] = this.sumCross[i][j] / (double)this.numOfPixels;
                if (j == i) continue;
                this.meanCross[j][i] = this.meanCross[i][j];
            }
        }
    }

    private void initializeMin() {
        this.minPCA = new double[this.numOfSourceBands];
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.minPCA[i] = Double.MAX_VALUE;
        }
        this.computeEigenDecompositionOfCovarianceMatrix();
    }

    private void computePCAMin(double[] tileMinPCA) {
        for (int i = 0; i < this.numPCA; ++i) {
            if (!(tileMinPCA[i] < this.minPCA[i])) continue;
            this.minPCA[i] = tileMinPCA[i];
        }
    }

    private void computeEigenDecompositionOfCovarianceMatrix() {
        this.eigenVectorMatrices = new double[this.numOfSourceBands][this.numOfSourceBands];
        this.eigenValues = new double[this.numOfSourceBands];
        double[][] cov = new double[this.numOfSourceBands][this.numOfSourceBands];
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            for (int j = 0; j < this.numOfSourceBands; ++j) {
                cov[i][j] = this.meanCross[i][j] - this.mean[i] * this.mean[j];
            }
        }
        Matrix Cov = new Matrix(cov);
        SingularValueDecomposition Svd = Cov.svd();
        Matrix S = Svd.getS();
        Matrix U = Svd.getU();
        this.totalEigenvalues = 0.0;
        for (int i = 0; i < this.numOfSourceBands; ++i) {
            this.eigenValues[i] = S.get(i, i);
            this.totalEigenvalues += this.eigenValues[i];
            for (int j = 0; j < this.numOfSourceBands; ++j) {
                this.eigenVectorMatrices[i][j] = U.get(i, j);
            }
        }
        if (this.selectEigenvaluesBy.equals(EIGENVALUE_THRESHOLD)) {
            double sum = 0.0;
            for (int i = 0; i < this.numOfSourceBands; ++i) {
                if (!((sum += this.eigenValues[i]) / this.totalEigenvalues >= this.eigenvalueThreshold)) continue;
                this.numPCA = i + 1;
                break;
            }
        }
    }

    public void dispose() {
        if (!this.pcaImageComputed) {
            return;
        }
        this.createReportFile();
    }

    private void createReportFile() {
        File appUserDir = new File(ResourceUtils.getApplicationUserDir((boolean)true).getAbsolutePath() + File.separator + "log");
        if (!appUserDir.exists()) {
            appUserDir.mkdirs();
        }
        File reportFile = new File(appUserDir, this.sourceProduct.getName() + "_pca_report.txt");
        try {
            int i;
            FileOutputStream out = new FileOutputStream(reportFile);
            PrintStream p = new PrintStream(out);
            p.println();
            p.println("User Selected Bands: ");
            for (i = 0; i < this.numOfSourceBands; ++i) {
                p.println("    " + this.sourceBandNames[i]);
            }
            p.println();
            if (this.selectEigenvaluesBy.equals(EIGENVALUE_THRESHOLD)) {
                p.println("User Input Eigenvalue Threshold: " + this.eigenvalueThreshold + " %");
                p.println();
            }
            p.println("Number of PCA Images Output: " + this.numPCA);
            p.println();
            p.println("Normalized Eigenvalues: ");
            for (i = 0; i < this.numOfSourceBands; ++i) {
                p.println("    " + this.eigenValues[i]);
            }
            p.println();
            p.close();
            if (this.showEigenvalues.booleanValue()) {
                Desktop.getDesktop().edit(reportFile);
            }
        }
        catch (IOException exc) {
            throw new OperatorException((Throwable)exc);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PCAOp.class);
        }
    }
}

