/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.framework.gpf.experimental.Output;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.InputProductValidator;
import org.esa.snap.gpf.StackUtils;

@OperatorMetadata(alias="Stack-Split", description="Writes all bands to files.", category="SAR Processing/Coregistration")
public class StackSplitWriter
extends Operator
implements Output {
    @TargetProduct
    private Product targetProduct;
    @SourceProduct(alias="source", description="The source product to be written.")
    private Product sourceProduct;
    @Parameter(defaultValue="target", description="The output folder to which the data product is written.")
    private File targetFolder;
    @Parameter(defaultValue="BEAM-DIMAP", description="The name of the output file format.")
    private String formatName;
    private final Map<Band, SubsetInfo> bandMap = new HashMap<Band, SubsetInfo>();

    public StackSplitWriter() {
        this.setRequiresAllBands(true);
    }

    public void initialize() throws OperatorException {
        try {
            String[] slvProductNames;
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfCoregisteredStack();
            if (this.targetFolder == null) {
                throw new OperatorException("Please add a target folder");
            }
            if (!this.targetFolder.exists()) {
                this.targetFolder.mkdirs();
            }
            int width = this.sourceProduct.getSceneRasterWidth();
            int height = this.sourceProduct.getSceneRasterHeight();
            this.targetProduct = this.sourceProduct;
            this.targetProduct.setPreferredTileSize(new Dimension(width, height));
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            String mstProductName = absRoot.getAttributeString("PRODUCT", this.sourceProduct.getName());
            String[] mstNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
            this.createSubset(mstProductName, this.getBandNames(mstNames));
            for (String slvProductName : slvProductNames = StackUtils.getSlaveProductNames((Product)this.sourceProduct)) {
                String[] slvBandNames = StackUtils.getSlaveBandNames((Product)this.sourceProduct, (String)slvProductName);
                this.createSubset(slvProductName, this.getBandNames(slvBandNames));
            }
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private String[] getBandNames(String[] names) {
        HashSet<String> bandNames = new HashSet<String>();
        for (String name : names) {
            String suffix = StackUtils.getBandSuffix((String)name);
            for (String srcBandName : this.sourceProduct.getBandNames()) {
                if (!srcBandName.endsWith(suffix)) continue;
                bandNames.add(srcBandName);
            }
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    private void createSubset(String productName, String[] bandNames) throws IOException {
        int width = this.sourceProduct.getSceneRasterWidth();
        int height = this.sourceProduct.getSceneRasterHeight();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        subsetDef.addNodeNames(this.sourceProduct.getTiePointGridNames());
        subsetDef.addNodeNames(bandNames);
        subsetDef.setRegion(0, 0, width, height);
        subsetDef.setSubSampling(1, 1);
        subsetDef.setIgnoreMetadata(true);
        SubsetInfo subsetInfo = new SubsetInfo();
        subsetInfo.subsetBuilder = new ProductSubsetBuilder();
        subsetInfo.subsetProduct = subsetInfo.subsetBuilder.readProductNodes((Object)this.sourceProduct, subsetDef);
        subsetInfo.file = new File(this.targetFolder, productName);
        for (Band trgBand : subsetInfo.subsetProduct.getBands()) {
            String newBandName = StackUtils.getBandNameWithoutDate((String)trgBand.getName());
            subsetInfo.newBandNamingMap.put(newBandName, trgBand.getName());
            trgBand.setName(newBandName);
            for (Band vBand : subsetInfo.subsetProduct.getBands()) {
                if (!(vBand instanceof VirtualBand)) continue;
                VirtualBand virtBand = (VirtualBand)vBand;
                String expression = virtBand.getExpression().replaceAll(trgBand.getName(), newBandName);
                virtBand.setExpression(expression);
            }
        }
        subsetInfo.productWriter = ProductIO.getProductWriter((String)this.formatName);
        if (subsetInfo.productWriter == null) {
            throw new OperatorException("No data product writer for the '" + this.formatName + "' format available");
        }
        subsetInfo.productWriter.setFormatName(this.formatName);
        subsetInfo.productWriter.setIncrementalMode(false);
        subsetInfo.subsetProduct.setProductWriter(subsetInfo.productWriter);
        this.bandMap.put(this.targetProduct.getBand(bandNames[0]), subsetInfo);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            SubsetInfo subsetInfo = this.bandMap.get(targetBand);
            if (subsetInfo == null) {
                return;
            }
            subsetInfo.productWriter.writeProductNodes(subsetInfo.subsetProduct, (Object)subsetInfo.file);
            Rectangle trgRect = subsetInfo.subsetBuilder.getSubsetDef().getRegion();
            if (!subsetInfo.written) {
                this.writeTile(subsetInfo, trgRect);
            }
        }
        catch (Exception e) {
            if (e instanceof OperatorException) {
                throw (OperatorException)((Object)e);
            }
            throw new OperatorException((Throwable)e);
        }
    }

    private synchronized void writeTile(SubsetInfo info, Rectangle trgRect) throws IOException {
        if (info.written) {
            return;
        }
        for (Band trgBand : info.subsetProduct.getBands()) {
            String oldBandName = info.newBandNamingMap.get(trgBand.getName());
            Tile sourceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(oldBandName), trgRect);
            ProductData rawSamples = sourceTile.getRawSamples();
            info.productWriter.writeBandRasterData(trgBand, 0, 0, trgBand.getSceneRasterWidth(), trgBand.getSceneRasterHeight(), rawSamples, ProgressMonitor.NULL);
        }
        info.written = true;
    }

    public void dispose() {
        try {
            for (Band band : this.bandMap.keySet()) {
                SubsetInfo info = this.bandMap.get(band);
                info.productWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.dispose();
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StackSplitWriter.class);
        }
    }

    private static class SubsetInfo {
        Product subsetProduct;
        ProductSubsetBuilder subsetBuilder;
        File file;
        ProductWriter productWriter;
        boolean written = false;
        final Map<String, String> newBandNamingMap = new HashMap<String, String>();

        private SubsetInfo() {
        }
    }
}

