/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPolynomial;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GcpDescriptor;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.visat.VisatApp;
import org.esa.nest.dat.dialogs.AutoCloseOptionPane;
import org.esa.nest.gpf.GCPManager;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ReaderUtils;
import org.esa.snap.gpf.StackUtils;
import org.esa.snap.util.ResourceUtils;
import org.jlinda.core.coregistration.SimpleLUT;

@OperatorMetadata(alias="Warp", category="SAR Processing/Coregistration", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Create Warp Function And Get Co-registrated Images")
public class WarpOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The RMS threshold for eliminating invalid GCPs", interval="(0, *)", defaultValue="0.5", label="RMS Threshold")
    private float rmsThreshold = 0.5f;
    @Parameter(description="The order of WARP polynomial function", valueSet={"1", "2", "3"}, defaultValue="2", label="Warp Polynomial Order")
    private int warpPolynomialOrder = 2;
    @Parameter(valueSet={"Nearest-neighbor interpolation", "Bilinear interpolation", "Bicubic interpolation", "Bicubic2 interpolation", "Linear interpolation", "Cubic convolution (4 points)", "Cubic convolution (6 points)", "Truncated sinc (6 points)", "Truncated sinc (8 points)", "Truncated sinc (16 points)"}, defaultValue="Bilinear interpolation", label="Interpolation Method")
    private String interpolationMethod = "Bilinear interpolation";
    @Parameter(defaultValue="false")
    private boolean excludeMaster = false;
    private Interpolation interp = null;
    private InterpolationTable interpTable = null;
    @Parameter(description="Show the Residuals file in a text viewer", defaultValue="false", label="Show Residuals")
    private Boolean openResidualsFile = false;
    private Band masterBand = null;
    private Band masterBand2 = null;
    private boolean complexCoregistration = false;
    private boolean warpDataAvailable = false;
    public static final String NEAREST_NEIGHBOR = "Nearest-neighbor interpolation";
    public static final String BILINEAR = "Bilinear interpolation";
    public static final String BICUBIC = "Bicubic interpolation";
    public static final String BICUBIC2 = "Bicubic2 interpolation";
    public static final String RECT = "Step function (nearest-neighbor)";
    public static final String TRI = "Linear interpolation";
    public static final String CC4P = "Cubic convolution (4 points)";
    public static final String CC6P = "Cubic convolution (6 points)";
    public static final String TS6P = "Truncated sinc (6 points)";
    public static final String TS8P = "Truncated sinc (8 points)";
    public static final String TS16P = "Truncated sinc (16 points)";
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);
    private final Map<Band, Band> complexSrcMap = new HashMap<Band, Band>(10);
    private final Map<Band, WarpData> warpDataMap = new HashMap<Band, WarpData>(10);
    private String processedSlaveBand;
    private String[] masterBandNames = null;
    private int maxIterations = 20;

    public void initialize() throws OperatorException {
        try {
            File residualsFile = WarpOp.getResidualsFile(this.sourceProduct);
            if (residualsFile.exists()) {
                residualsFile.delete();
            }
            this.masterBand = this.sourceProduct.getBandAt(0);
            if (this.masterBand.getUnit() != null && this.masterBand.getUnit().equals("real") && this.sourceProduct.getNumBands() > 1) {
                this.complexCoregistration = true;
                this.masterBand2 = this.sourceProduct.getBandAt(1);
            }
            if (this.complexCoregistration) {
                switch (this.interpolationMethod) {
                    case "Cubic convolution (4 points)": {
                        this.constructInterpolationTable(CC4P);
                        break;
                    }
                    case "Cubic convolution (6 points)": {
                        this.constructInterpolationTable(CC6P);
                        break;
                    }
                    case "Truncated sinc (6 points)": {
                        this.constructInterpolationTable(TS6P);
                        break;
                    }
                    case "Truncated sinc (8 points)": {
                        this.constructInterpolationTable(TS8P);
                        break;
                    }
                    case "Truncated sinc (16 points)": {
                        this.constructInterpolationTable(TS16P);
                        break;
                    }
                    default: {
                        this.interp = Interpolation.getInstance((int)0);
                        break;
                    }
                }
            } else {
                switch (this.interpolationMethod) {
                    case "Nearest-neighbor interpolation": {
                        this.interp = Interpolation.getInstance((int)0);
                        break;
                    }
                    case "Bilinear interpolation": {
                        this.interp = Interpolation.getInstance((int)1);
                        break;
                    }
                    case "Bicubic interpolation": {
                        this.interp = Interpolation.getInstance((int)2);
                        break;
                    }
                    case "Bicubic2 interpolation": {
                        this.interp = Interpolation.getInstance((int)3);
                    }
                }
            }
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.processedSlaveBand = absRoot.getAttributeString("processed_slave");
            this.createTargetProduct();
        }
        catch (Throwable e) {
            this.openResidualsFile = true;
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void constructInterpolationTable(String interpolationMethod) {
        SimpleLUT lut = new SimpleLUT(interpolationMethod);
        lut.constructLUT();
        int kernelLength = lut.getKernelLength();
        double[] lutArrayDoubles = lut.getKernelAsArray();
        float[] lutArrayFloats = new float[lutArrayDoubles.length];
        int i = 0;
        for (double lutElement : lutArrayDoubles) {
            lutArrayFloats[i++] = (float)lutElement;
        }
        int subsampleBits = 7;
        int precisionBits = 32;
        int padding = kernelLength / 2 - 1;
        this.interpTable = new InterpolationTable(padding, kernelLength, 7, 32, lutArrayFloats);
    }

    private void addSlaveGCPs(WarpData warpData, String bandName) {
        GeoCoding targetGeoCoding = this.targetProduct.getGeoCoding();
        ProductNodeGroup<Placemark> targetGCPGroup = GCPManager.instance().getGcpGroup(this.targetProduct.getBand(bandName));
        targetGCPGroup.removeAll();
        for (int i = 0; i < warpData.slaveGCPList.size(); ++i) {
            Placemark sPin = warpData.slaveGCPList.get(i);
            Placemark tPin = Placemark.createPointPlacemark((PlacemarkDescriptor)GcpDescriptor.getInstance(), (String)sPin.getName(), (String)sPin.getLabel(), (String)sPin.getDescription(), (PixelPos)sPin.getPixelPos(), (GeoPos)sPin.getGeoPos(), (GeoCoding)targetGeoCoding);
            targetGCPGroup.add((ProductNode)tPin);
        }
    }

    private String formatName(Band srcBand) {
        String name = srcBand.getName();
        if (this.excludeMaster) {
            String newName = StackUtils.getBandNameWithoutDate((String)name);
            if (name.equals(this.processedSlaveBand)) {
                this.processedSlaveBand = newName;
            }
            return newName;
        }
        return name;
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.masterBandNames = StackUtils.getMasterBandNames((Product)this.sourceProduct);
        int numSrcBands = this.sourceProduct.getNumBands();
        int inc = 1;
        if (this.complexCoregistration) {
            inc = 2;
        }
        for (int i = 0; i < numSrcBands; i += inc) {
            Band targetBandQ;
            Band targetBand;
            Band srcBand = this.sourceProduct.getBandAt(i);
            if (srcBand == this.masterBand || srcBand == this.masterBand2 || StringUtils.contains((String[])this.masterBandNames, (String)srcBand.getName())) {
                if (this.excludeMaster) continue;
                targetBand = ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBand.setSourceImage(srcBand.getSourceImage());
            } else {
                targetBand = this.targetProduct.addBand(this.formatName(srcBand), 30);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)targetBand);
            }
            this.sourceRasterMap.put(targetBand, srcBand);
            if (!this.complexCoregistration) continue;
            Band srcBandQ = this.sourceProduct.getBandAt(i + 1);
            if (srcBand == this.masterBand || srcBand == this.masterBand2 || StringUtils.contains((String[])this.masterBandNames, (String)srcBand.getName())) {
                targetBandQ = ProductUtils.copyBand((String)srcBandQ.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBandQ.setSourceImage(srcBandQ.getSourceImage());
            } else {
                targetBandQ = this.targetProduct.addBand(this.formatName(srcBandQ), 30);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBandQ, (RasterDataNode)targetBandQ);
            }
            this.sourceRasterMap.put(targetBandQ, srcBandQ);
            this.complexSrcMap.put(srcBandQ, srcBand);
            String suffix = "";
            if (this.excludeMaster) {
                String pol = OperatorUtils.getPolarizationFromBandName((String)srcBand.getName());
                if (pol != null && !pol.isEmpty()) {
                    suffix = '_' + pol.toUpperCase();
                }
            } else {
                suffix = '_' + OperatorUtils.getSuffixFromBandName((String)srcBand.getName());
            }
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBand, (Band)targetBandQ, (String)suffix);
        }
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.updateTargetProductMetadata();
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (this.excludeMaster) {
            String[] slaveNames = StackUtils.getSlaveProductNames((Product)this.sourceProduct);
            absTgt.setAttributeString("PRODUCT", slaveNames[0]);
            ProductData.UTC[] times = StackUtils.getProductTimes((Product)this.sourceProduct);
            this.targetProduct.setStartTime(times[1]);
            double lineTimeInterval = absTgt.getAttributeDouble("line_time_interval");
            int height = this.sourceProduct.getSceneRasterHeight();
            ProductData.UTC endTime = new ProductData.UTC(times[1].getMJD() + lineTimeInterval * (double)height / 86400.0);
            this.targetProduct.setEndTime(endTime);
        } else {
            AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"coregistered_stack", (int)1);
        }
    }

    private synchronized void getWarpData(Rectangle targetRectangle) throws OperatorException {
        if (this.warpDataAvailable) {
            return;
        }
        Band targetBand = this.targetProduct.getBand(this.processedSlaveBand);
        Tile sourceRaster = this.getSourceTile((RasterDataNode)this.sourceRasterMap.get(targetBand), targetRectangle);
        int numSrcBands = this.sourceProduct.getNumBands();
        int inc = 1;
        if (this.complexCoregistration) {
            inc = 2;
        }
        ProductNodeGroup<Placemark> masterGCPGroup = GCPManager.instance().getGcpGroup(this.masterBand);
        boolean appendFlag = false;
        for (int i = 0; i < numSrcBands; i += inc) {
            Band srcBand = this.sourceProduct.getBandAt(i);
            if (srcBand == this.masterBand || srcBand == this.masterBand2 || StringUtils.contains((String[])this.masterBandNames, (String)srcBand.getName())) continue;
            ProductNodeGroup<Placemark> slaveGCPGroup = GCPManager.instance().getGcpGroup(srcBand);
            if (slaveGCPGroup.getNodeCount() < 3) {
                String slvProductName = StackUtils.getSlaveProductName((Product)this.sourceProduct, (Band)srcBand, null);
                for (Band band : this.sourceProduct.getBands()) {
                    if (band == srcBand) continue;
                    String productName = StackUtils.getSlaveProductName((Product)this.sourceProduct, (Band)band, null);
                    if (slvProductName != null && slvProductName.equals(productName) && (slaveGCPGroup = GCPManager.instance().getGcpGroup(band)).getNodeCount() >= 3) break;
                }
            }
            WarpData warpData = new WarpData(slaveGCPGroup);
            this.warpDataMap.put(srcBand, warpData);
            if (slaveGCPGroup.getNodeCount() < 3) {
                warpData.notEnoughGCPs = true;
                continue;
            }
            WarpOp.computeWARPPolynomialFromGCPs(this.sourceProduct, srcBand, this.warpPolynomialOrder, masterGCPGroup, this.maxIterations, this.rmsThreshold, appendFlag, warpData);
            if (warpData.notEnoughGCPs) continue;
            if (!appendFlag) {
                appendFlag = true;
            }
            this.addSlaveGCPs(warpData, targetBand.getName());
        }
        this.announceGCPWarning();
        GCPManager.instance().removeAllGcpGroups();
        if (this.openResidualsFile.booleanValue()) {
            File residualsFile = WarpOp.getResidualsFile(this.sourceProduct);
            if (Desktop.isDesktopSupported() && residualsFile.exists()) {
                try {
                    Desktop.getDesktop().open(residualsFile);
                }
                catch (Exception e) {
                    System.out.println("Error opening residuals file " + e.getMessage());
                }
            }
        }
        this.writeWarpDataToMetadata();
        this.warpDataAvailable = true;
    }

    public static void computeWARPPolynomialFromGCPs(Product sourceProduct, Band srcBand, int warpPolynomialOrder, ProductNodeGroup<Placemark> masterGCPGroup, int maxIterations, float rmsThreshold, boolean appendFlag, WarpData warpData) {
        float threshold = 0.0f;
        for (int iter = 0; iter < maxIterations; ++iter) {
            boolean append;
            if (iter == 0) {
                append = appendFlag;
            } else {
                append = true;
                threshold = iter < maxIterations - 1 && warpData.rmsMean > (double)rmsThreshold ? (float)(warpData.rmsMean + warpData.rmsStd) : rmsThreshold;
            }
            if (threshold > 0.0f) {
                WarpOp.eliminateGCPsBasedOnRMS(warpData, threshold);
            }
            WarpOp.computeWARPPolynomial(warpData, warpPolynomialOrder, masterGCPGroup);
            WarpOp.outputCoRegistrationInfo(sourceProduct, warpPolynomialOrder, warpData, append, threshold, iter, srcBand.getName());
            if (warpData.notEnoughGCPs || iter > 0 && threshold <= rmsThreshold) break;
        }
    }

    private void writeWarpDataToMetadata() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        Set<Band> bandSet = this.warpDataMap.keySet();
        for (Band band : bandSet) {
            MetadataElement bandElem = AbstractMetadata.getBandAbsMetadata((MetadataElement)absRoot, (String)band.getName(), (boolean)true);
            MetadataElement warpDataElem = bandElem.getElement("WarpData");
            if (warpDataElem == null) {
                warpDataElem = new MetadataElement("WarpData");
                bandElem.addElement(warpDataElem);
            } else {
                MetadataAttribute[] attribList;
                for (MetadataAttribute attrib : attribList = warpDataElem.getAttributes()) {
                    warpDataElem.removeAttribute(attrib);
                }
            }
            WarpData warpData = this.warpDataMap.get(band);
            if (warpData.numValidGCPs <= 0) continue;
            for (int i = 0; i < warpData.numValidGCPs; ++i) {
                MetadataElement gcpElem = new MetadataElement("GCP" + i);
                warpDataElem.addElement(gcpElem);
                gcpElem.setAttributeDouble("mst_x", (double)warpData.masterGCPCoords[2 * i]);
                gcpElem.setAttributeDouble("mst_y", (double)warpData.masterGCPCoords[2 * i + 1]);
                gcpElem.setAttributeDouble("slv_x", (double)warpData.slaveGCPCoords[2 * i]);
                gcpElem.setAttributeDouble("slv_y", (double)warpData.slaveGCPCoords[2 * i + 1]);
                if (warpData.notEnoughGCPs) continue;
                gcpElem.setAttributeDouble("rms", (double)warpData.rms[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        try {
            Band srcBand;
            if (!this.warpDataAvailable) {
                this.getWarpData(targetRectangle);
            }
            if ((srcBand = this.sourceRasterMap.get(targetBand)) == null) {
                return;
            }
            Band realSrcBand = this.complexSrcMap.get(srcBand);
            if (realSrcBand == null) {
                realSrcBand = srcBand;
            }
            Tile sourceRaster = this.getSourceTile((RasterDataNode)srcBand, targetRectangle);
            if (pm.isCanceled()) {
                return;
            }
            WarpData warpData = this.warpDataMap.get(realSrcBand);
            if (warpData.notEnoughGCPs) {
                return;
            }
            MultiLevelImage srcImage = sourceRaster.getRasterDataNode().getSourceImage();
            RenderedOp warpedImage = this.createWarpImage(warpData.jaiWarp, (RenderedImage)srcImage);
            float[] dataArray = warpedImage.getData(targetRectangle).getSamples(x0, y0, w, h, 0, (float[])null);
            targetTile.setRawSamples(ProductData.createInstance((float[])dataArray));
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    public static void computeWARPPolynomial(WarpData warpData, int warpPolynomialOrder, ProductNodeGroup<Placemark> masterGCPGroup) {
        WarpOp.getNumOfValidGCPs(warpData, warpPolynomialOrder);
        WarpOp.getMasterAndSlaveGCPCoordinates(warpData, masterGCPGroup);
        if (warpData.notEnoughGCPs) {
            return;
        }
        warpData.computeWARP(warpPolynomialOrder);
        WarpOp.computeRMS(warpData, warpPolynomialOrder);
    }

    private static void getNumOfValidGCPs(WarpData warpData, int warpPolynomialOrder) throws OperatorException {
        warpData.numValidGCPs = warpData.slaveGCPList.size();
        int requiredGCPs = (warpPolynomialOrder + 2) * (warpPolynomialOrder + 1) / 2;
        if (warpData.numValidGCPs < requiredGCPs) {
            warpData.notEnoughGCPs = true;
        }
    }

    private static void getMasterAndSlaveGCPCoordinates(WarpData warpData, ProductNodeGroup<Placemark> masterGCPGroup) {
        warpData.masterGCPCoords = new float[2 * warpData.numValidGCPs];
        warpData.slaveGCPCoords = new float[2 * warpData.numValidGCPs];
        for (int i = 0; i < warpData.numValidGCPs; ++i) {
            Placemark sPin = warpData.slaveGCPList.get(i);
            PixelPos sGCPPos = sPin.getPixelPos();
            Placemark mPin = (Placemark)masterGCPGroup.get(sPin.getName());
            PixelPos mGCPPos = mPin.getPixelPos();
            int j = 2 * i;
            warpData.masterGCPCoords[j] = mGCPPos.x;
            warpData.masterGCPCoords[j + 1] = mGCPPos.y;
            warpData.slaveGCPCoords[j] = sGCPPos.x;
            warpData.slaveGCPCoords[j + 1] = sGCPPos.y;
        }
    }

    private static void computeRMS(WarpData warpData, int warpPolynomialOrder) {
        warpData.rms = new float[warpData.numValidGCPs];
        warpData.colResiduals = new float[warpData.numValidGCPs];
        warpData.rowResiduals = new float[warpData.numValidGCPs];
        PixelPos slavePos = new PixelPos(0.0f, 0.0f);
        for (int i = 0; i < warpData.rms.length; ++i) {
            int i2 = 2 * i;
            WarpOp.getWarpedCoords(warpData, warpPolynomialOrder, warpData.masterGCPCoords[i2], warpData.masterGCPCoords[i2 + 1], slavePos);
            double dX = slavePos.x - warpData.slaveGCPCoords[i2];
            double dY = slavePos.y - warpData.slaveGCPCoords[i2 + 1];
            warpData.colResiduals[i] = (float)dX;
            warpData.rowResiduals[i] = (float)dY;
            warpData.rms[i] = (float)Math.sqrt(dX * dX + dY * dY);
        }
        warpData.rmsMean = 0.0;
        warpData.rowResidualMean = 0.0;
        warpData.colResidualMean = 0.0;
        double rms2Mean = 0.0;
        double rowResidual2Mean = 0.0;
        double colResidual2Mean = 0.0;
        for (int i = 0; i < warpData.rms.length; ++i) {
            warpData.rmsMean += (double)warpData.rms[i];
            rms2Mean += (double)(warpData.rms[i] * warpData.rms[i]);
            warpData.rowResidualMean += (double)warpData.rowResiduals[i];
            rowResidual2Mean += (double)(warpData.rowResiduals[i] * warpData.rowResiduals[i]);
            warpData.colResidualMean += (double)warpData.colResiduals[i];
            colResidual2Mean += (double)(warpData.colResiduals[i] * warpData.colResiduals[i]);
        }
        warpData.rmsMean /= (double)warpData.rms.length;
        warpData.rowResidualMean /= (double)warpData.rms.length;
        warpData.colResidualMean /= (double)warpData.rms.length;
        warpData.rmsStd = Math.sqrt((rms2Mean /= (double)warpData.rms.length) - warpData.rmsMean * warpData.rmsMean);
        warpData.rowResidualStd = Math.sqrt((rowResidual2Mean /= (double)warpData.rms.length) - warpData.rowResidualMean * warpData.rowResidualMean);
        warpData.colResidualStd = Math.sqrt((colResidual2Mean /= (double)warpData.rms.length) - warpData.colResidualMean * warpData.colResidualMean);
    }

    public static boolean eliminateGCPsBasedOnRMS(WarpData warpData, float threshold) {
        ArrayList<Placemark> pinList = new ArrayList<Placemark>();
        if (warpData.slaveGCPList.size() < warpData.rms.length) {
            warpData.notEnoughGCPs = true;
            return true;
        }
        for (int i = 0; i < warpData.rms.length; ++i) {
            if (!(warpData.rms[i] >= threshold)) continue;
            pinList.add(warpData.slaveGCPList.get(i));
        }
        for (Placemark aPin : pinList) {
            warpData.slaveGCPList.remove(aPin);
        }
        return !pinList.isEmpty();
    }

    public static void getWarpedCoords(WarpData warpData, int warpPolynomialOrder, double mX, double mY, PixelPos slavePos) throws OperatorException {
        double[] xCoeffs = warpData.xCoef;
        double[] yCoeffs = warpData.yCoef;
        if (xCoeffs.length != yCoeffs.length) {
            throw new OperatorException("WARP has different number of coefficients for X and Y");
        }
        int numOfCoeffs = xCoeffs.length;
        switch (warpPolynomialOrder) {
            case 1: {
                if (numOfCoeffs != 3) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                slavePos.x = (float)(xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY);
                slavePos.y = (float)(yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY);
                break;
            }
            case 2: {
                if (numOfCoeffs != 6) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                double mXmX = mX * mX;
                double mXmY = mX * mY;
                double mYmY = mY * mY;
                slavePos.x = (float)(xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY + xCoeffs[3] * mXmX + xCoeffs[4] * mXmY + xCoeffs[5] * mYmY);
                slavePos.y = (float)(yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY + yCoeffs[3] * mXmX + yCoeffs[4] * mXmY + yCoeffs[5] * mYmY);
                break;
            }
            case 3: {
                if (numOfCoeffs != 10) {
                    throw new OperatorException("Number of WARP coefficients do not match WARP degree");
                }
                double mXmX = mX * mX;
                double mXmY = mX * mY;
                double mYmY = mY * mY;
                slavePos.x = (float)(xCoeffs[0] + xCoeffs[1] * mX + xCoeffs[2] * mY + xCoeffs[3] * mXmX + xCoeffs[4] * mXmY + xCoeffs[5] * mYmY + xCoeffs[6] * mXmX * mX + xCoeffs[7] * mX * mXmY + xCoeffs[8] * mXmY * mY + xCoeffs[9] * mYmY * mY);
                slavePos.y = (float)(yCoeffs[0] + yCoeffs[1] * mX + yCoeffs[2] * mY + yCoeffs[3] * mXmX + yCoeffs[4] * mXmY + yCoeffs[5] * mYmY + yCoeffs[6] * mXmX * mX + yCoeffs[7] * mX * mXmY + yCoeffs[8] * mXmY * mY + yCoeffs[9] * mYmY * mY);
                break;
            }
            default: {
                throw new OperatorException("Incorrect WARP degree");
            }
        }
    }

    public static void outputCoRegistrationInfo(Product sourceProduct, int warpPolynomialOrder, WarpData warpData, boolean appendFlag, float threshold, int parseIndex, String bandName) throws OperatorException {
        File residualFile = WarpOp.getResidualsFile(sourceProduct);
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(residualFile.getAbsolutePath(), appendFlag);
            p = new PrintStream(out);
            p.println();
            if (!appendFlag) {
                p.println();
                p.format("Transformation degree = %d", warpPolynomialOrder);
                p.println();
            }
            p.println();
            p.print("------------------------ Band: " + bandName + " (Parse " + parseIndex + ") ------------------------");
            p.println();
            if (!warpData.notEnoughGCPs) {
                p.println();
                p.println("WARP coefficients:");
                for (double xCoeff : warpData.xCoef) {
                    p.print((float)xCoeff + ", ");
                }
                p.println();
                for (double yCoeff : warpData.yCoef) {
                    p.print((float)yCoeff + ", ");
                }
                p.println();
            }
            if (appendFlag) {
                p.println();
                p.format("RMS Threshold: %5.3f", Float.valueOf(threshold));
                p.println();
            }
            p.println();
            if (appendFlag) {
                p.print("Valid GCPs after parse " + parseIndex + " :");
            } else {
                p.print("Initial Valid GCPs:");
            }
            p.println();
            if (!warpData.notEnoughGCPs) {
                p.println();
                p.println("  No.  | Master GCP x | Master GCP y | Slave GCP x  | Slave GCP y  | Row Residual | Col Residual |        RMS        |");
                p.println("----------------------------------------------------------------------------------------------------------------------");
                for (int i = 0; i < warpData.rms.length; ++i) {
                    p.format("%6d |%13.3f |%13.3f |%13.3f |%13.3f |%13.8f |%13.8f |%18.12f |", i, Float.valueOf(warpData.masterGCPCoords[2 * i]), Float.valueOf(warpData.masterGCPCoords[2 * i + 1]), Float.valueOf(warpData.slaveGCPCoords[2 * i]), Float.valueOf(warpData.slaveGCPCoords[2 * i + 1]), Float.valueOf(warpData.rowResiduals[i]), Float.valueOf(warpData.colResiduals[i]), Float.valueOf(warpData.rms[i]));
                    p.println();
                }
                p.println();
                p.print("Row residual mean = " + warpData.rowResidualMean);
                p.println();
                p.print("Row residual std = " + warpData.rowResidualStd);
                p.println();
                p.println();
                p.print("Col residual mean = " + warpData.colResidualMean);
                p.println();
                p.print("Col residual std = " + warpData.colResidualStd);
                p.println();
                p.println();
                p.print("RMS mean = " + warpData.rmsMean);
                p.println();
                p.print("RMS std = " + warpData.rmsStd);
                p.println();
            } else {
                p.println();
                p.println("No. | Master GCP x | Master GCP y | Slave GCP x | Slave GCP y |");
                p.println("---------------------------------------------------------------");
                for (int i = 0; i < warpData.numValidGCPs; ++i) {
                    p.format("%2d  |%13.3f |%13.3f |%12.3f |%12.3f |", i, Float.valueOf(warpData.masterGCPCoords[2 * i]), Float.valueOf(warpData.masterGCPCoords[2 * i + 1]), Float.valueOf(warpData.slaveGCPCoords[2 * i]), Float.valueOf(warpData.slaveGCPCoords[2 * i + 1]));
                    p.println();
                }
            }
            p.println();
            p.println();
        }
    }

    private static File getResidualsFile(Product sourceProduct) {
        String fileName = sourceProduct.getName() + "_residual.txt";
        File appUserDir = new File(ResourceUtils.getApplicationUserDir((boolean)true).getAbsolutePath() + File.separator + "log");
        if (!appUserDir.exists()) {
            appUserDir.mkdirs();
        }
        return new File(appUserDir.toString(), fileName);
    }

    private RenderedOp createWarpImage(WarpPolynomial warp, RenderedImage srcImage) {
        ParameterBlock pb1 = new ParameterBlock();
        pb1.addSource(srcImage);
        pb1.add(4);
        RenderedOp srcImageFloat = JAI.create((String)"format", (ParameterBlock)pb1);
        ParameterBlock pb2 = new ParameterBlock();
        pb2.addSource(srcImageFloat);
        pb2.add(warp);
        if (this.interp != null) {
            pb2.add(this.interp);
        } else if (this.interpTable != null) {
            pb2.add(this.interpTable);
        }
        return JAI.create((String)"warp", (ParameterBlock)pb2);
    }

    private void announceGCPWarning() {
        String msg = "";
        for (Band srcBand : this.sourceProduct.getBands()) {
            WarpData warpData = this.warpDataMap.get(srcBand);
            if (warpData == null || !warpData.notEnoughGCPs) continue;
            msg = msg + srcBand.getName() + " does not have enough valid GCPs for the warp\n";
            this.openResidualsFile = true;
        }
        if (!msg.isEmpty()) {
            System.out.println(msg);
            if (VisatApp.getApp() != null) {
                AutoCloseOptionPane.showWarningDialog((String)"Some bands did not coregister", (String)msg);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WarpOp.class);
        }
    }

    public static class WarpData {
        public final List<Placemark> slaveGCPList = new ArrayList<Placemark>();
        private WarpPolynomial jaiWarp = null;
        public double[] xCoef = null;
        public double[] yCoef = null;
        public int numValidGCPs = 0;
        public boolean notEnoughGCPs = false;
        public float[] rms = null;
        public float[] rowResiduals = null;
        public float[] colResiduals = null;
        public float[] masterGCPCoords = null;
        public float[] slaveGCPCoords = null;
        public double rmsStd = 0.0;
        public double rmsMean = 0.0;
        public double rowResidualStd = 0.0;
        public double rowResidualMean = 0.0;
        public double colResidualStd = 0.0;
        public double colResidualMean = 0.0;

        public WarpData(ProductNodeGroup<Placemark> slaveGCPGroup) {
            for (int i = 0; i < slaveGCPGroup.getNodeCount(); ++i) {
                this.slaveGCPList.add((Placemark)slaveGCPGroup.get(i));
            }
        }

        public void computeWARP(int warpPolynomialOrder) {
            float sum = 0.0f;
            for (int i = 0; i < this.slaveGCPCoords.length; ++i) {
                sum += Math.abs(this.slaveGCPCoords[i] - this.masterGCPCoords[i]);
            }
            if ((double)sum < 0.01) {
                switch (warpPolynomialOrder) {
                    case 1: {
                        this.xCoef = new double[3];
                        this.yCoef = new double[3];
                        this.xCoef[0] = 0.0;
                        this.xCoef[1] = 1.0;
                        this.xCoef[2] = 0.0;
                        this.yCoef[0] = 0.0;
                        this.yCoef[1] = 0.0;
                        this.yCoef[2] = 1.0;
                        break;
                    }
                    case 2: {
                        this.xCoef = new double[6];
                        this.yCoef = new double[6];
                        this.xCoef[0] = 0.0;
                        this.xCoef[1] = 1.0;
                        this.xCoef[2] = 0.0;
                        this.xCoef[3] = 0.0;
                        this.xCoef[4] = 0.0;
                        this.xCoef[5] = 0.0;
                        this.yCoef[0] = 0.0;
                        this.yCoef[1] = 0.0;
                        this.yCoef[2] = 1.0;
                        this.yCoef[3] = 0.0;
                        this.yCoef[4] = 0.0;
                        this.yCoef[5] = 0.0;
                        break;
                    }
                    case 3: {
                        this.xCoef = new double[10];
                        this.yCoef = new double[10];
                        this.xCoef[0] = 0.0;
                        this.xCoef[1] = 1.0;
                        this.xCoef[2] = 0.0;
                        this.xCoef[3] = 0.0;
                        this.xCoef[4] = 0.0;
                        this.xCoef[5] = 0.0;
                        this.xCoef[6] = 0.0;
                        this.xCoef[7] = 0.0;
                        this.xCoef[8] = 0.0;
                        this.xCoef[9] = 0.0;
                        this.yCoef[0] = 0.0;
                        this.yCoef[1] = 0.0;
                        this.yCoef[2] = 1.0;
                        this.yCoef[3] = 0.0;
                        this.yCoef[4] = 0.0;
                        this.yCoef[5] = 0.0;
                        this.yCoef[6] = 0.0;
                        this.yCoef[7] = 0.0;
                        this.yCoef[8] = 0.0;
                        this.yCoef[9] = 0.0;
                        break;
                    }
                    default: {
                        throw new OperatorException("Incorrect WARP degree");
                    }
                }
                return;
            }
            this.jaiWarp = WarpPolynomial.createWarp((float[])this.slaveGCPCoords, (int)0, (float[])this.masterGCPCoords, (int)0, (int)(2 * this.numValidGCPs), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)warpPolynomialOrder);
            float[] jaiXCoefs = this.jaiWarp.getXCoeffs();
            float[] jaiYCoefs = this.jaiWarp.getYCoeffs();
            int size = jaiXCoefs.length;
            this.xCoef = new double[size];
            this.yCoef = new double[size];
            for (int i = 0; i < size; ++i) {
                this.xCoef[i] = jaiXCoefs[i];
                this.yCoef[i] = jaiYCoefs[i];
            }
        }
    }
}

