/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.AppContext;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.ui.BaseOperatorUI;
import org.esa.snap.gpf.ui.UIValidation;
import org.esa.snap.util.DialogUtils;

public class WarpOpUI
extends BaseOperatorUI {
    private final JComboBox warpPolynomialOrder = new JComboBox<String>(new String[]{"1", "2", "3"});
    private final JComboBox interpolationMethod = new JComboBox<String>(new String[]{"Nearest-neighbor interpolation", "Bilinear interpolation", "Bicubic interpolation", "Bicubic2 interpolation", "Linear interpolation", "Cubic convolution (4 points)", "Cubic convolution (6 points)", "Truncated sinc (6 points)", "Truncated sinc (8 points)", "Truncated sinc (16 points)"});
    private final JTextField rmsThreshold = new JTextField("");
    final JCheckBox openResidualsFileCheckBox = new JCheckBox("Show Residuals");
    boolean openResidualsFile;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.openResidualsFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WarpOpUI.this.openResidualsFile = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        boolean isComplex;
        this.rmsThreshold.setText(String.valueOf(this.paramMap.get("rmsThreshold")));
        this.warpPolynomialOrder.setSelectedItem(this.paramMap.get("warpPolynomialOrder"));
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && !(isComplex = OperatorUtils.isComplex((Product)this.sourceProducts[0]))) {
            this.interpolationMethod.removeAllItems();
            this.interpolationMethod.addItem("Nearest-neighbor interpolation");
            this.interpolationMethod.addItem("Bilinear interpolation");
            this.interpolationMethod.addItem("Bicubic interpolation");
            this.interpolationMethod.addItem("Bicubic2 interpolation");
        }
        this.interpolationMethod.setSelectedItem(this.paramMap.get("interpolationMethod"));
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("rmsThreshold", Float.valueOf(Float.parseFloat(this.rmsThreshold.getText())));
        this.paramMap.put("warpPolynomialOrder", Integer.parseInt((String)this.warpPolynomialOrder.getSelectedItem()));
        this.paramMap.put("interpolationMethod", this.interpolationMethod.getSelectedItem());
        this.paramMap.put("openResidualsFile", this.openResidualsFile);
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"RMS Threshold (pixel accuracy):", (JComponent)this.rmsThreshold);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Warp Polynomial Order:", (JComponent)this.warpPolynomialOrder);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Interpolation Method:", (JComponent)this.interpolationMethod);
        ++gbc.gridy;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.openResidualsFileCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

