/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import Jama.Matrix;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.nest.dataio.dem.ElevationModel;
import org.esa.snap.datamodel.AbstractMetadata;
import org.esa.snap.datamodel.OrbitStateVector;
import org.esa.snap.eo.GeoUtils;
import org.esa.snap.eo.LocalGeometry;
import org.esa.snap.gpf.OperatorUtils;
import org.esa.snap.gpf.TileGeoreferencing;
import org.esa.snap.util.Maths;

public class SARGeocoding {
    public static final double NonValidZeroDopplerTime = -99999.0;
    public static final double NonValidIncidenceAngle = -99999.0;

    public static boolean isNearRangeOnLeft(TiePointGrid incidenceAngle, int sourceImageWidth) {
        double incidenceAngleToLastPixel;
        if (incidenceAngle == null) {
            return true;
        }
        double incidenceAngleToFirstPixel = incidenceAngle.getPixelDouble(0, 0);
        return incidenceAngleToFirstPixel < (incidenceAngleToLastPixel = incidenceAngle.getPixelDouble(sourceImageWidth - 1, 0));
    }

    public static double getEarthPointZeroDopplerTime(double firstLineUTC, double lineTimeInterval, double wavelength, double[] earthPoint, double[][] sensorPosition, double[][] sensorVelocity) throws OperatorException {
        int lowerBound = 0;
        int upperBound = sensorPosition.length - 1;
        double lowerBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[lowerBound], sensorVelocity[lowerBound], wavelength);
        double upperBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[upperBound], sensorVelocity[upperBound], wavelength);
        if (Double.compare(lowerBoundFreq, 0.0) == 0) {
            return firstLineUTC + (double)lowerBound * lineTimeInterval;
        }
        if (Double.compare(upperBoundFreq, 0.0) == 0) {
            return firstLineUTC + (double)upperBound * lineTimeInterval;
        }
        if (lowerBoundFreq * upperBoundFreq > 0.0) {
            return -99999.0;
        }
        while (upperBound - lowerBound > 1) {
            int mid = (int)((double)(lowerBound + upperBound) / 2.0);
            double midFreq = sensorVelocity[mid][0] * (earthPoint[0] - sensorPosition[mid][0]) + sensorVelocity[mid][1] * (earthPoint[1] - sensorPosition[mid][1]) + sensorVelocity[mid][2] * (earthPoint[2] - sensorPosition[mid][2]);
            if (midFreq * lowerBoundFreq > 0.0) {
                lowerBound = mid;
                lowerBoundFreq = midFreq;
                continue;
            }
            if (midFreq * upperBoundFreq > 0.0) {
                upperBound = mid;
                upperBoundFreq = midFreq;
                continue;
            }
            if (Double.compare(midFreq, 0.0) != 0) continue;
            return firstLineUTC + (double)mid * lineTimeInterval;
        }
        double y0 = (double)lowerBound - lowerBoundFreq * (double)(upperBound - lowerBound) / (upperBoundFreq - lowerBoundFreq);
        return firstLineUTC + y0 * lineTimeInterval;
    }

    public static double getEarthPointZeroDopplerTimeNewton(double firstLineUTC, double lineTimeInterval, double wavelength, double[] earthPoint, double[][] sensorPosition, double[][] sensorVelocity) throws OperatorException {
        boolean lowerBound = false;
        int upperBound = sensorPosition.length - 1;
        double lowerBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[0], sensorVelocity[0], wavelength);
        double upperBoundFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[upperBound], sensorVelocity[upperBound], wavelength);
        if (Double.compare(lowerBoundFreq, 0.0) == 0) {
            return firstLineUTC + 0.0 * lineTimeInterval;
        }
        if (Double.compare(upperBoundFreq, 0.0) == 0) {
            return firstLineUTC + (double)upperBound * lineTimeInterval;
        }
        if (lowerBoundFreq * upperBoundFreq > 0.0) {
            return -99999.0;
        }
        int yOld = 0;
        int yNew = sensorPosition.length / 2;
        int yNew1 = 0;
        int yMax = sensorPosition.length - 1;
        double fOld = 0.0;
        double fOld1 = 0.0;
        double fNew = 0.0;
        double fNew1 = 0.0;
        double d = 0.0;
        while (Math.abs(yNew - yOld) > 2) {
            yOld = yNew;
            int yOld1 = yOld + 1;
            if (yOld1 > yMax) {
                yOld1 = yOld - 1;
            }
            if ((yNew = (int)((double)yOld - (fOld = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[yOld], sensorVelocity[yOld], wavelength)) / (d = ((fOld1 = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[yOld1], sensorVelocity[yOld1], wavelength)) - fOld) / (double)(yOld1 - yOld)))) < 0) {
                yNew = 0;
                continue;
            }
            if (yNew <= yMax) continue;
            yNew = yMax;
        }
        fNew = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[yNew], sensorVelocity[yNew], wavelength);
        if (fNew * (fNew1 = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[yNew1 = yNew + 1], sensorVelocity[yNew1], wavelength)) > 0.0) {
            yNew1 = yNew - 1;
            fNew1 = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition[yNew1], sensorVelocity[yNew1], wavelength);
        }
        double y0 = (double)yNew - fNew * (double)(yNew1 - yNew) / (fNew1 - fNew);
        return firstLineUTC + y0 * lineTimeInterval;
    }

    public static double getZeroDopplerTime(double firstLineUTC, double lineTimeInterval, double wavelength, double[] earthPoint, Orbit orbit) throws OperatorException {
        int numOrbitVec = orbit.orbitStateVectors.length;
        double[] sensorPosition = new double[3];
        double[] sensorVelocity = new double[3];
        double firstVecTime = 0.0;
        double secondVecTime = 0.0;
        double firstVecFreq = 0.0;
        double secondVecFreq = 0.0;
        for (int i = 0; i < numOrbitVec; ++i) {
            sensorPosition[0] = orbit.orbitStateVectors[i].x_pos;
            sensorPosition[1] = orbit.orbitStateVectors[i].y_pos;
            sensorPosition[2] = orbit.orbitStateVectors[i].z_pos;
            sensorVelocity[0] = orbit.orbitStateVectors[i].x_vel;
            sensorVelocity[1] = orbit.orbitStateVectors[i].y_vel;
            sensorVelocity[2] = orbit.orbitStateVectors[i].z_vel;
            double currentFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition, sensorVelocity, wavelength);
            if (i != 0 && !(firstVecFreq * currentFreq > 0.0)) {
                secondVecTime = orbit.orbitStateVectors[i].time_mjd;
                secondVecFreq = currentFreq;
                break;
            }
            firstVecTime = orbit.orbitStateVectors[i].time_mjd;
            firstVecFreq = currentFreq;
        }
        if (firstVecFreq * secondVecFreq >= 0.0) {
            return -99999.0;
        }
        double lowerBoundTime = firstVecTime;
        double upperBoundTime = secondVecTime;
        double lowerBoundFreq = firstVecFreq;
        double upperBoundFreq = secondVecFreq;
        double diffTime = Math.abs(upperBoundTime - lowerBoundTime);
        while (diffTime > Math.abs(lineTimeInterval)) {
            double midTime = (upperBoundTime + lowerBoundTime) / 2.0;
            orbit.getPositionVelocity(midTime, sensorPosition, sensorVelocity);
            double midFreq = SARGeocoding.getDopplerFrequency(earthPoint, sensorPosition, sensorVelocity, wavelength);
            if (midFreq * lowerBoundFreq > 0.0) {
                lowerBoundTime = midTime;
                lowerBoundFreq = midFreq;
            } else if (midFreq * upperBoundFreq > 0.0) {
                upperBoundTime = midTime;
                upperBoundFreq = midFreq;
            } else if (Double.compare(midFreq, 0.0) == 0) {
                return midTime;
            }
            diffTime = Math.abs(upperBoundTime - lowerBoundTime);
        }
        return lowerBoundTime - lowerBoundFreq * (upperBoundTime - lowerBoundTime) / (upperBoundFreq - lowerBoundFreq);
    }

    private static double getDopplerFrequency(double[] earthPoint, double[] sensorPosition, double[] sensorVelocity, double wavelength) {
        double xDiff = earthPoint[0] - sensorPosition[0];
        double yDiff = earthPoint[1] - sensorPosition[1];
        double zDiff = earthPoint[2] - sensorPosition[2];
        double distance = Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        return 2.0 * (sensorVelocity[0] * xDiff + sensorVelocity[1] * yDiff + sensorVelocity[2] * zDiff) / (distance * wavelength);
    }

    public static double computeSlantRange(double time, Orbit orbit, double[] earthPoint, double[] sensorPos) {
        double[] sensorVel = new double[3];
        orbit.getPositionVelocity(time, sensorPos, sensorVel);
        double xDiff = sensorPos[0] - earthPoint[0];
        double yDiff = sensorPos[1] - earthPoint[1];
        double zDiff = sensorPos[2] - earthPoint[2];
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    public static double computeRangeIndex(boolean srgrFlag, int sourceImageWidth, double firstLineUTC, double lastLineUTC, double rangeSpacing, double zeroDopplerTime, double slantRange, double nearEdgeSlantRange, AbstractMetadata.SRGRCoefficientList[] srgrConvParams) {
        if (zeroDopplerTime < Math.min(firstLineUTC, lastLineUTC) || zeroDopplerTime > Math.max(firstLineUTC, lastLineUTC)) {
            return -1.0;
        }
        if (srgrFlag) {
            double groundRange = 0.0;
            if (srgrConvParams.length == 1) {
                groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrConvParams[0].coefficients, srgrConvParams[0].ground_range_origin);
                if (groundRange < 0.0) {
                    return -1.0;
                }
                return (groundRange - srgrConvParams[0].ground_range_origin) / rangeSpacing;
            }
            int idx = 0;
            int i = 0;
            while (i < srgrConvParams.length && zeroDopplerTime >= srgrConvParams[i].timeMJD) {
                idx = i++;
            }
            double[] srgrCoefficients = new double[srgrConvParams[idx].coefficients.length];
            if (idx == srgrConvParams.length - 1) {
                --idx;
            }
            double mu = (zeroDopplerTime - srgrConvParams[idx].timeMJD) / (srgrConvParams[idx + 1].timeMJD - srgrConvParams[idx].timeMJD);
            for (int i2 = 0; i2 < srgrCoefficients.length; ++i2) {
                srgrCoefficients[i2] = Maths.interpolationLinear((double)srgrConvParams[idx].coefficients[i2], (double)srgrConvParams[idx + 1].coefficients[i2], (double)mu);
            }
            groundRange = SARGeocoding.computeGroundRange(sourceImageWidth, rangeSpacing, slantRange, srgrCoefficients, srgrConvParams[idx].ground_range_origin);
            if (groundRange < 0.0) {
                return -1.0;
            }
            return (groundRange - srgrConvParams[idx].ground_range_origin) / rangeSpacing;
        }
        return (slantRange - nearEdgeSlantRange) / rangeSpacing;
    }

    public static double computeGroundRange(int sourceImageWidth, double rangeSpacing, double slantRange, double[] srgrCoeff, double ground_range_origin) {
        double lowerBound = ground_range_origin;
        double upperBound = ground_range_origin + (double)sourceImageWidth * rangeSpacing;
        double lowerBoundSlantRange = Maths.computePolynomialValue((double)lowerBound, (double[])srgrCoeff);
        double upperBoundSlantRange = Maths.computePolynomialValue((double)upperBound, (double[])srgrCoeff);
        if (slantRange < lowerBoundSlantRange || slantRange > upperBoundSlantRange) {
            return -1.0;
        }
        while (upperBound - lowerBound > 0.0) {
            double mid = (lowerBound + upperBound) / 2.0;
            double midSlantRange = Maths.computePolynomialValue((double)mid, (double[])srgrCoeff);
            if (Math.abs(midSlantRange - slantRange) < 0.1) {
                return mid;
            }
            if (midSlantRange < slantRange) {
                lowerBound = mid;
                continue;
            }
            if (!(midSlantRange > slantRange)) continue;
            upperBound = mid;
        }
        return -1.0;
    }

    public static void computeLocalIncidenceAngle(LocalGeometry lg, float demNoDataValue, boolean saveLocalIncidenceAngle, boolean saveProjectedLocalIncidenceAngle, boolean saveSigmaNought, int x0, int y0, int x, int y, double[][] localDEM, double[] localIncidenceAngles) {
        for (int i = 0; i < 3; ++i) {
            int yy = y - y0 + i;
            for (int j = 0; j < 3; ++j) {
                if (localDEM[yy][x - x0 + j] != (double)demNoDataValue) continue;
                return;
            }
        }
        int yy = y - y0;
        int xx = x - x0;
        double rightPointHeight = (localDEM[yy][xx + 2] + localDEM[yy + 1][xx + 2] + localDEM[yy + 2][xx + 2]) / 3.0;
        double leftPointHeight = (localDEM[yy][xx] + localDEM[yy + 1][xx] + localDEM[yy + 2][xx]) / 3.0;
        double upPointHeight = (localDEM[yy][xx] + localDEM[yy][xx + 1] + localDEM[yy][xx + 2]) / 3.0;
        double downPointHeight = (localDEM[yy + 2][xx] + localDEM[yy + 2][xx + 1] + localDEM[yy + 2][xx + 2]) / 3.0;
        double[] rightPoint = new double[3];
        double[] leftPoint = new double[3];
        double[] upPoint = new double[3];
        double[] downPoint = new double[3];
        GeoUtils.geo2xyzWGS84((double)lg.rightPointLat, (double)lg.rightPointLon, (double)rightPointHeight, (double[])rightPoint);
        GeoUtils.geo2xyzWGS84((double)lg.leftPointLat, (double)lg.leftPointLon, (double)leftPointHeight, (double[])leftPoint);
        GeoUtils.geo2xyzWGS84((double)lg.upPointLat, (double)lg.upPointLon, (double)upPointHeight, (double[])upPoint);
        GeoUtils.geo2xyzWGS84((double)lg.downPointLat, (double)lg.downPointLon, (double)downPointHeight, (double[])downPoint);
        double[] a = new double[]{rightPoint[0] - leftPoint[0], rightPoint[1] - leftPoint[1], rightPoint[2] - leftPoint[2]};
        double[] b = new double[]{downPoint[0] - upPoint[0], downPoint[1] - upPoint[1], downPoint[2] - upPoint[2]};
        double[] c = new double[]{lg.centrePoint[0], lg.centrePoint[1], lg.centrePoint[2]};
        double[] n = new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        Maths.normalizeVector((double[])n);
        if (Maths.innerProduct((double[])n, (double[])c) < 0.0) {
            n[0] = -n[0];
            n[1] = -n[1];
            n[2] = -n[2];
        }
        double[] s = new double[]{lg.sensorPos[0] - lg.centrePoint[0], lg.sensorPos[1] - lg.centrePoint[1], lg.sensorPos[2] - lg.centrePoint[2]};
        Maths.normalizeVector((double[])s);
        if (saveLocalIncidenceAngle) {
            double nsInnerProduct = Maths.innerProduct((double[])n, (double[])s);
            localIncidenceAngles[0] = FastMath.acos((double)nsInnerProduct) * 57.29577951308232;
        }
        if (saveProjectedLocalIncidenceAngle || saveSigmaNought) {
            double[] m = new double[]{s[1] * c[2] - s[2] * c[1], s[2] * c[0] - s[0] * c[2], s[0] * c[1] - s[1] * c[0]};
            Maths.normalizeVector((double[])m);
            double mnInnerProduct = Maths.innerProduct((double[])m, (double[])n);
            double[] n1 = new double[]{n[0] - m[0] * mnInnerProduct, n[1] - m[1] * mnInnerProduct, n[2] - m[2] * mnInnerProduct};
            Maths.normalizeVector((double[])n1);
            localIncidenceAngles[1] = FastMath.acos((double)Maths.innerProduct((double[])n1, (double[])s)) * 57.29577951308232;
        }
    }

    public static void computeLocalIncidenceAngle(LocalGeometry lg, float demNoDataValue, boolean saveLocalIncidenceAngle, boolean saveProjectedLocalIncidenceAngle, boolean saveSigmaNought, int x0, int y0, int x, int y, double[][] localDEM, double[] localIncidenceAngles, TileGeoreferencing tileGeoRef, ElevationModel dem) throws Exception {
        double alt;
        int n;
        int yy = y - y0;
        int xx = x - x0;
        int maxX = localDEM[0].length - 1;
        int maxY = localDEM.length - 1;
        int numN = 3;
        GeoPos geo = new GeoPos();
        double rightPointHeight = 0.0;
        double leftPointHeight = 0.0;
        double upPointHeight = 0.0;
        double downPointHeight = 0.0;
        int cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (xx + n > maxX) {
                tileGeoRef.getGeoPos(xx + n, yy, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy][xx + n];
            }
            if (alt == (double)demNoDataValue) continue;
            rightPointHeight += alt;
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        rightPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (xx - n < 0) {
                tileGeoRef.getGeoPos(xx - n, yy, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy][xx - n];
            }
            if (alt == (double)demNoDataValue) continue;
            leftPointHeight += alt;
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        leftPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (yy - n < 0) {
                tileGeoRef.getGeoPos(xx, yy - n, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy - n][xx];
            }
            if (alt == (double)demNoDataValue) continue;
            upPointHeight += alt;
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        upPointHeight /= (double)cnt;
        cnt = 0;
        for (n = 0; n < 3; ++n) {
            if (yy + n > maxY) {
                tileGeoRef.getGeoPos(xx, yy + n, geo);
                alt = dem.getElevation(geo);
            } else {
                alt = localDEM[yy + n][xx];
            }
            if (alt == (double)demNoDataValue) continue;
            downPointHeight += alt;
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        downPointHeight /= (double)cnt;
        double[] rightPoint = new double[3];
        double[] leftPoint = new double[3];
        double[] upPoint = new double[3];
        double[] downPoint = new double[3];
        double[] centrePoint = new double[3];
        GeoUtils.geo2xyzWGS84((double)lg.rightPointLat, (double)lg.rightPointLon, (double)rightPointHeight, (double[])rightPoint);
        GeoUtils.geo2xyzWGS84((double)lg.leftPointLat, (double)lg.leftPointLon, (double)leftPointHeight, (double[])leftPoint);
        GeoUtils.geo2xyzWGS84((double)lg.upPointLat, (double)lg.upPointLon, (double)upPointHeight, (double[])upPoint);
        GeoUtils.geo2xyzWGS84((double)lg.downPointLat, (double)lg.downPointLon, (double)downPointHeight, (double[])downPoint);
        tileGeoRef.getGeoPos(xx, yy, geo);
        double centerHeight = localDEM[yy][xx];
        GeoUtils.geo2xyzWGS84((double)geo.getLat(), (double)geo.lon, (double)centerHeight, (double[])centrePoint);
        double[] a = new double[]{rightPoint[0] - leftPoint[0], rightPoint[1] - leftPoint[1], rightPoint[2] - leftPoint[2]};
        double[] b = new double[]{downPoint[0] - upPoint[0], downPoint[1] - upPoint[1], downPoint[2] - upPoint[2]};
        double[] c = new double[]{centrePoint[0], centrePoint[1], centrePoint[2]};
        double[] n2 = new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        Maths.normalizeVector((double[])n2);
        if (Maths.innerProduct((double[])n2, (double[])c) < 0.0) {
            n2[0] = -n2[0];
            n2[1] = -n2[1];
            n2[2] = -n2[2];
        }
        double[] s = new double[]{lg.sensorPos[0] - centrePoint[0], lg.sensorPos[1] - centrePoint[1], lg.sensorPos[2] - centrePoint[2]};
        Maths.normalizeVector((double[])s);
        if (saveLocalIncidenceAngle) {
            double nsInnerProduct = Maths.innerProduct((double[])n2, (double[])s);
            localIncidenceAngles[0] = FastMath.acos((double)nsInnerProduct) * 57.29577951308232;
        }
        if (saveProjectedLocalIncidenceAngle || saveSigmaNought) {
            double[] m = new double[]{s[1] * c[2] - s[2] * c[1], s[2] * c[0] - s[0] * c[2], s[0] * c[1] - s[1] * c[0]};
            Maths.normalizeVector((double[])m);
            double mnInnerProduct = Maths.innerProduct((double[])m, (double[])n2);
            double[] n1 = new double[]{n2[0] - m[0] * mnInnerProduct, n2[1] - m[1] * mnInnerProduct, n2[2] - m[2] * mnInnerProduct};
            Maths.normalizeVector((double[])n1);
            localIncidenceAngles[1] = FastMath.acos((double)Maths.innerProduct((double[])n1, (double[])s)) * 57.29577951308232;
        }
    }

    public static double getAzimuthPixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        return AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
    }

    public static double getRangePixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        if (srgrFlag) {
            return rangeSpacing;
        }
        return rangeSpacing / FastMath.sin((double)SARGeocoding.getIncidenceAngleAtCentreRangePixel(srcProduct));
    }

    public static double getPixelSpacing(Product srcProduct) throws Exception {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
        double rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"range_spacing");
        double azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)abs, (String)"azimuth_spacing");
        boolean srgrFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)abs, (String)"srgr_flag");
        if (srgrFlag) {
            return Math.min(rangeSpacing, azimuthSpacing);
        }
        return Math.min(rangeSpacing / FastMath.sin((double)SARGeocoding.getIncidenceAngleAtCentreRangePixel(srcProduct)), azimuthSpacing);
    }

    private static double getIncidenceAngleAtCentreRangePixel(Product srcProduct) throws OperatorException {
        int sourceImageWidth = srcProduct.getSceneRasterWidth();
        int sourceImageHeight = srcProduct.getSceneRasterHeight();
        int x = sourceImageWidth / 2;
        int y = sourceImageHeight / 2;
        TiePointGrid incidenceAngle = OperatorUtils.getIncidenceAngle((Product)srcProduct);
        if (incidenceAngle == null) {
            throw new OperatorException("incidence_angle tie point grid not found in product");
        }
        return (double)incidenceAngle.getPixelFloat((float)x, (float)y) * (Math.PI / 180);
    }

    public static double getPixelSpacingInDegree(double pixelSpacingInMeter) {
        return pixelSpacingInMeter / 6378137.0 * 57.29577951308232;
    }

    public static double getPixelSpacingInMeter(double pixelSpacingInDegree) {
        return pixelSpacingInDegree * 6356752.314245179 * (Math.PI / 180);
    }

    public static boolean isValidCell(double rangeIndex, double azimuthIndex, double lat, double lon, TileGeoreferencing tileGeoRef, int srcMaxRange, int srcMaxAzimuth, double[] sensorPos) {
        if (rangeIndex < 0.0 || rangeIndex >= (double)srcMaxRange || azimuthIndex < 0.0 || azimuthIndex >= (double)srcMaxAzimuth) {
            return false;
        }
        GeoPos sensorGeoPos = new GeoPos();
        GeoUtils.xyz2geo((double[])sensorPos, (GeoPos)sensorGeoPos, (GeoUtils.EarthModel)GeoUtils.EarthModel.WGS84);
        double delLatMax = Math.abs(lat - (double)sensorGeoPos.lat);
        double delLonMax = lon < 0.0 && sensorGeoPos.lon > 0.0f ? Math.min(Math.abs(360.0 + lon - (double)sensorGeoPos.lon), (double)sensorGeoPos.lon - lon) : (lon > 0.0 && sensorGeoPos.lon < 0.0f ? Math.min(Math.abs((double)(360.0f + sensorGeoPos.lon) - lon), lon - (double)sensorGeoPos.lon) : Math.abs(lon - (double)sensorGeoPos.lon));
        GeoPos geoPos = new GeoPos();
        tileGeoRef.getGeoPos(new PixelPos((float)rangeIndex, (float)azimuthIndex), geoPos);
        double delLat = Math.abs(lat - (double)geoPos.getLat());
        double srcLon = geoPos.getLon();
        double delLon = lon < 0.0 && srcLon > 0.0 ? Math.min(Math.abs(360.0 + lon - srcLon), srcLon - lon) : (lon > 0.0 && srcLon < 0.0 ? Math.min(Math.abs(360.0 + srcLon - lon), lon - srcLon) : Math.abs(lon - srcLon));
        return delLat + delLon <= delLatMax + delLonMax;
    }

    public static void addLookDirection(String name, MetadataElement lookDirectionListElem, int index, int num, int sourceImageWidth, int sourceImageHeight, double firstLineUTC, double lineTimeInterval, boolean nearRangeOnLeft, TiePointGrid latitude, TiePointGrid longitude) {
        int xTail;
        int xHead;
        int y;
        MetadataElement lookDirectionElem = new MetadataElement(name + index);
        if (num == 1) {
            y = sourceImageHeight / 2;
        } else if (num > 1) {
            y = (index - 1) * sourceImageHeight / (num - 1);
        } else {
            throw new OperatorException("Invalid number of look directions");
        }
        double time = firstLineUTC + (double)y * lineTimeInterval;
        lookDirectionElem.setAttributeUTC("time", new ProductData.UTC(time));
        if (nearRangeOnLeft) {
            xHead = sourceImageWidth - 1;
            xTail = 0;
        } else {
            xHead = 0;
            xTail = sourceImageWidth - 1;
        }
        lookDirectionElem.setAttributeDouble("head_lat", latitude.getPixelDouble(xHead, y));
        lookDirectionElem.setAttributeDouble("head_lon", longitude.getPixelDouble(xHead, y));
        lookDirectionElem.setAttributeDouble("tail_lat", latitude.getPixelDouble(xTail, y));
        lookDirectionElem.setAttributeDouble("tail_lon", longitude.getPixelDouble(xTail, y));
        lookDirectionListElem.addElement(lookDirectionElem);
    }

    public static class Orbit {
        public OrbitStateVector[] orbitStateVectors = null;
        public int polyDegree;
        public double firstLineUTC;
        public double[][] sensorPosition = null;
        public double[][] sensorVelocity = null;
        private int[] adjVecIndices = null;
        private double[] xPosCoeff = null;
        private double[] yPosCoeff = null;
        private double[] zPosCoeff = null;
        private double[] xVelCoeff = null;
        private double[] yVelCoeff = null;
        private double[] zVelCoeff = null;

        public Orbit(OrbitStateVector[] orbitStateVectors, int polyDegree, double firstLineUTC, double lineTimeInterval, int sourceImageHeight) {
            this.polyDegree = polyDegree;
            this.firstLineUTC = firstLineUTC;
            if (orbitStateVectors.length < polyDegree + 1) {
                throw new OperatorException("Not enough orbit state vectors for polynomial fitting");
            }
            this.orbitStateVectors = new OrbitStateVector[orbitStateVectors.length];
            System.arraycopy(orbitStateVectors, 0, this.orbitStateVectors, 0, orbitStateVectors.length);
            this.sensorPosition = new double[sourceImageHeight][3];
            this.sensorVelocity = new double[sourceImageHeight][3];
            for (int i = 0; i < sourceImageHeight; ++i) {
                double time = firstLineUTC + (double)i * lineTimeInterval;
                this.getPositionVelocity(time, this.sensorPosition[i], this.sensorVelocity[i]);
            }
        }

        public Orbit(OrbitStateVector[] orbitStateVectors, int polyDegree, double firstLineUTC) {
            this.polyDegree = polyDegree;
            this.firstLineUTC = firstLineUTC;
            if (orbitStateVectors.length < polyDegree + 1) {
                throw new OperatorException("Not enough orbit state vectors for polynomial fitting");
            }
            this.orbitStateVectors = new OrbitStateVector[orbitStateVectors.length];
            System.arraycopy(orbitStateVectors, 0, this.orbitStateVectors, 0, orbitStateVectors.length);
        }

        public void getPositionVelocity(double time, double[] position, double[] velocity) {
            int[] adjVecIndices = this.findAdjacentVectors(time);
            if (this.adjVecIndices == null || this.adjVecIndices[0] != adjVecIndices[0]) {
                this.computePolyFitCoeff(adjVecIndices);
                this.adjVecIndices = new int[adjVecIndices.length];
                System.arraycopy(adjVecIndices, 0, this.adjVecIndices, 0, adjVecIndices.length);
            }
            double normalizedTime = time - this.firstLineUTC;
            position[0] = Maths.polyVal((double)normalizedTime, (double[])this.xPosCoeff);
            position[1] = Maths.polyVal((double)normalizedTime, (double[])this.yPosCoeff);
            position[2] = Maths.polyVal((double)normalizedTime, (double[])this.zPosCoeff);
            velocity[0] = Maths.polyVal((double)normalizedTime, (double[])this.xVelCoeff);
            velocity[1] = Maths.polyVal((double)normalizedTime, (double[])this.yVelCoeff);
            velocity[2] = Maths.polyVal((double)normalizedTime, (double[])this.zVelCoeff);
        }

        public double getVelocity(double time) {
            double[] position = new double[3];
            double[] velocity = new double[3];
            this.getPositionVelocity(time, position, velocity);
            return Math.sqrt(velocity[0] * velocity[0] + velocity[1] * velocity[1] + velocity[2] * velocity[2]);
        }

        private int[] findAdjacentVectors(double time) {
            int nv = this.orbitStateVectors.length;
            int[] vectorIndices = new int[4];
            if (nv <= 4) {
                for (int i = 0; i < nv; ++i) {
                    vectorIndices[i] = i;
                }
                return vectorIndices;
            }
            if (time < this.orbitStateVectors[0].time_mjd) {
                for (int i = 0; i < 4; ++i) {
                    vectorIndices[i] = i;
                }
                return vectorIndices;
            }
            if (time > this.orbitStateVectors[nv - 1].time_mjd) {
                for (int i = 0; i < 4; ++i) {
                    vectorIndices[i] = nv - 4 + i;
                }
                return vectorIndices;
            }
            int midVecIdx = 0;
            for (int i = 0; i < nv - 1; ++i) {
                if (!(time >= this.orbitStateVectors[i].time_mjd) || !(time < this.orbitStateVectors[i + 1].time_mjd)) continue;
                midVecIdx = i;
                break;
            }
            if (midVecIdx == 0) {
                vectorIndices[0] = 0;
                vectorIndices[1] = 1;
                vectorIndices[2] = 2;
                vectorIndices[3] = 3;
            } else if (midVecIdx >= nv - 2) {
                vectorIndices[0] = nv - 4;
                vectorIndices[1] = nv - 3;
                vectorIndices[2] = nv - 2;
                vectorIndices[3] = nv - 1;
            } else {
                vectorIndices[0] = midVecIdx - 1;
                vectorIndices[1] = midVecIdx;
                vectorIndices[2] = midVecIdx + 1;
                vectorIndices[3] = midVecIdx + 2;
            }
            return vectorIndices;
        }

        private void computePolyFitCoeff(int[] adjVecIndices) {
            double[] timeArray = new double[adjVecIndices.length];
            double[] xPosArray = new double[adjVecIndices.length];
            double[] yPosArray = new double[adjVecIndices.length];
            double[] zPosArray = new double[adjVecIndices.length];
            double[] xVelArray = new double[adjVecIndices.length];
            double[] yVelArray = new double[adjVecIndices.length];
            double[] zVelArray = new double[adjVecIndices.length];
            for (int i = 0; i < adjVecIndices.length; ++i) {
                int idx = adjVecIndices[i];
                timeArray[i] = this.orbitStateVectors[idx].time_mjd - this.firstLineUTC;
                xPosArray[i] = this.orbitStateVectors[idx].x_pos;
                yPosArray[i] = this.orbitStateVectors[idx].y_pos;
                zPosArray[i] = this.orbitStateVectors[idx].z_pos;
                xVelArray[i] = this.orbitStateVectors[idx].x_vel;
                yVelArray[i] = this.orbitStateVectors[idx].y_vel;
                zVelArray[i] = this.orbitStateVectors[idx].z_vel;
            }
            Matrix A = Maths.createVandermondeMatrix((double[])timeArray, (int)this.polyDegree);
            this.xPosCoeff = Maths.polyFit((Matrix)A, (double[])xPosArray);
            this.yPosCoeff = Maths.polyFit((Matrix)A, (double[])yPosArray);
            this.zPosCoeff = Maths.polyFit((Matrix)A, (double[])zPosArray);
            this.xVelCoeff = Maths.polyFit((Matrix)A, (double[])xVelArray);
            this.yVelCoeff = Maths.polyFit((Matrix)A, (double[])yVelArray);
            this.zVelCoeff = Maths.polyFit((Matrix)A, (double[])zVelArray);
        }
    }
}

