/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.gpf.geometric;

import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.snap.datamodel.AbstractMetadata;

public class SARUtils {
    public static double getRadarFrequency(MetadataElement absRoot) throws Exception {
        double radarFreq = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"radar_frequency") * 1000000.0;
        if (Double.compare(radarFreq, 0.0) <= 0) {
            throw new OperatorException("Invalid radar frequency: " + radarFreq);
        }
        return 2.99792458E8 / radarFreq;
    }
}

