/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math;

import org.esa.nest.math.Transform;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.transforms.BasicTransform;
import org.esa.nest.math.transforms.DiscreteFourierTransform;
import org.esa.nest.math.transforms.FastWaveletTransform;
import org.esa.nest.math.transforms.WaveletPacketTransform;
import org.esa.nest.math.transforms.wavelets.Haar1;
import org.esa.nest.math.transforms.wavelets.Wavelet;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet1;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies2;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies3;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies4;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre1;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre2;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre3;

public class JWave {
    public static void main(String[] args) {
        try {
            Transform t;
            String waveletTypeList = "Haar1, Daubechies2, Daubechies4, Legendre1";
            if (args.length < 2 || args.length > 3) {
                System.err.println("usage: JWave [transformType] {waveletType} {noOfSteps}");
                System.err.println("");
                System.err.println("transformType: DFT, FWT, WPT, DWT");
                System.err.println("waveletType : " + waveletTypeList);
                System.err.println("noOfSteps : no of steps forward and reverse; optional");
                return;
            }
            String wType = args[1];
            Wavelet wavelet = null;
            if (wType.equalsIgnoreCase("haar02")) {
                wavelet = new Haar1();
            } else if (wType.equalsIgnoreCase("lege02")) {
                wavelet = new Legendre1();
            } else if (wType.equalsIgnoreCase("daub02")) {
                wavelet = new Daubechies2();
            } else if (wType.equalsIgnoreCase("daub03")) {
                wavelet = new Daubechies3();
            } else if (wType.equalsIgnoreCase("daub04")) {
                wavelet = new Daubechies4();
            } else if (wType.equalsIgnoreCase("lege04")) {
                wavelet = new Legendre2();
            } else if (wType.equalsIgnoreCase("lege06")) {
                wavelet = new Legendre3();
            } else if (wType.equalsIgnoreCase("coif06")) {
                wavelet = new Coiflet1();
            } else {
                System.err.println("usage: JWave [transformType] {waveletType}");
                System.err.println("");
                System.err.println("available wavelets are " + waveletTypeList);
                return;
            }
            String tType = args[0];
            BasicTransform bWave = null;
            if (tType.equalsIgnoreCase("dft")) {
                bWave = new DiscreteFourierTransform();
            } else if (tType.equalsIgnoreCase("fwt")) {
                bWave = new FastWaveletTransform(wavelet);
            } else if (tType.equalsIgnoreCase("wpt")) {
                bWave = new WaveletPacketTransform(wavelet);
            } else {
                System.err.println("usage: JWave [transformType] {waveletType}");
                System.err.println("");
                System.err.println("available transforms are DFT, FWT, WPT");
                return;
            }
            if (args.length > 2) {
                String argNoOfSteps = args[2];
                int noOfSteps = Integer.parseInt(argNoOfSteps);
                t = new Transform(bWave, noOfSteps);
            } else {
                t = new Transform(bWave);
            }
            double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            System.out.println("");
            System.out.println("time domain:");
            for (int p = 0; p < arrTime.length; ++p) {
                System.out.printf("%9.6f", arrTime[p]);
            }
            System.out.println("");
            double[] arrFreqOrHilb = null;
            arrFreqOrHilb = t.forward(arrTime);
            if (bWave instanceof DiscreteFourierTransform) {
                System.out.println("frequency domain:");
            } else {
                System.out.println("Hilbert domain:");
            }
            for (int p = 0; p < arrTime.length; ++p) {
                System.out.printf("%9.6f", arrFreqOrHilb[p]);
            }
            System.out.println("");
            double[] arrReco = null;
            arrReco = t.reverse(arrFreqOrHilb);
            System.out.println("reconstruction:");
            for (int p = 0; p < arrTime.length; ++p) {
                System.out.printf("%9.6f", arrReco[p]);
            }
            System.out.println("");
        }
        catch (JWaveException e1) {
            e1.printStackTrace();
        }
    }
}

