/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math;

import org.esa.nest.math.datatypes.Complex;
import org.esa.nest.math.exceptions.JWaveError;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.exceptions.JWaveFailure;
import org.esa.nest.math.tools.MathToolKit;
import org.esa.nest.math.transforms.BasicTransform;

public class Transform {
    protected BasicTransform _transform;
    protected MathToolKit _mathToolKit;

    public Transform(BasicTransform transform) {
        this._transform = transform;
        this._mathToolKit = new MathToolKit();
    }

    @Deprecated
    public Transform(BasicTransform transform, int iteration) {
        if (transform instanceof BasicTransform) {
            this._transform = transform;
            try {
                throw new JWaveError("THE ITERATION METHODS ARE BORKEN AT MOMENT");
            }
            catch (JWaveError e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Can't use transform :" + transform.getClass() + " with a specific level decomposition ;" + " use Transform( TransformI transform ) constructor instead.");
        }
        this._mathToolKit = new MathToolKit();
    }

    public double[] forward(double[] arrTime) throws JWaveException {
        if (!this._mathToolKit.isBinary(arrTime.length)) {
            throw new JWaveFailure("given array length is not 2^p = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.forward(arrTime);
    }

    public double[] reverse(double[] arrFreq) throws JWaveException {
        if (!this._mathToolKit.isBinary(arrFreq.length)) {
            throw new JWaveFailure("given array length is not 2^p = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.reverse(arrFreq);
    }

    public Complex[] forward(Complex[] arrTime) {
        return this._transform.forward(arrTime);
    }

    public Complex[] reverse(Complex[] arrFreq) {
        return this._transform.reverse(arrFreq);
    }

    public double[][] forward(double[][] matrixTime) throws JWaveException {
        int M = matrixTime.length;
        if (!this._mathToolKit.isBinary(M)) {
            throw new JWaveFailure("given matrix dimension " + M + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        for (int i = 0; i < M; ++i) {
            if (this._mathToolKit.isBinary(matrixTime[i].length)) continue;
            throw new JWaveFailure("given matrix dimension N(i)=" + matrixTime[i].length + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.forward(matrixTime);
    }

    public double[][] reverse(double[][] matrixFreq) throws JWaveException {
        int M = matrixFreq.length;
        if (!this._mathToolKit.isBinary(M)) {
            throw new JWaveFailure("given matrix dimension " + M + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        for (int i = 0; i < M; ++i) {
            if (this._mathToolKit.isBinary(matrixFreq[i].length)) continue;
            throw new JWaveFailure("given matrix dimension N(i)=" + matrixFreq[i].length + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.reverse(matrixFreq);
    }

    public double[][][] forward(double[][][] spaceTime) throws JWaveException {
        int M = spaceTime.length;
        if (!this._mathToolKit.isBinary(M)) {
            throw new JWaveFailure("given space dimension " + M + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        for (int i = 0; i < M; ++i) {
            int N = spaceTime[i].length;
            if (!this._mathToolKit.isBinary(N)) {
                throw new JWaveFailure("given space dimension N(i)=" + N + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
            }
            for (int j = 0; j < N; ++j) {
                if (this._mathToolKit.isBinary(spaceTime[i][j].length)) continue;
                throw new JWaveFailure("given space dimension M(j)=" + spaceTime[i][j].length + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
            }
        }
        return this._transform.forward(spaceTime);
    }

    public double[][][] reverse(double[][][] spaceFreq) throws JWaveException {
        int M = spaceFreq.length;
        if (!this._mathToolKit.isBinary(M)) {
            throw new JWaveFailure("given space dimension " + M + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
        }
        for (int i = 0; i < M; ++i) {
            int N = spaceFreq[i].length;
            if (!this._mathToolKit.isBinary(N)) {
                throw new JWaveFailure("given space dimension N(i)=" + N + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
            }
            for (int j = 0; j < N; ++j) {
                if (this._mathToolKit.isBinary(spaceFreq[i][j].length)) continue;
                throw new JWaveFailure("given space dimension M(j)=" + spaceFreq[i][j].length + " is not 2^p = 1, 2, 4, 8, 16, 32, .. " + "please use the Ancient Egyptian Decomposition for any other array length!");
            }
        }
        return this._transform.reverse(spaceFreq);
    }

    public double[][] decompose(double[] arrTime) throws JWaveException {
        if (!this._mathToolKit.isBinary(arrTime.length)) {
            throw new JWaveFailure("given array length is not 2^p = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.decompose(arrTime);
    }

    public double[] recompose(double[][] matDeComp) throws JWaveException {
        if (!this._mathToolKit.isBinary(matDeComp[0].length)) {
            throw new JWaveFailure("given array length is not 2^p = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        return this._transform.recompose(matDeComp);
    }
}

