/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math;

import org.esa.nest.math.Transform;
import org.esa.nest.math.datatypes.Complex;
import org.esa.nest.math.exceptions.JWaveException;
import org.esa.nest.math.exceptions.JWaveFailure;
import org.esa.nest.math.transforms.FastWaveletTransform;
import org.esa.nest.math.transforms.wavelets.Haar1;
import org.esa.nest.math.transforms.wavelets.Haar1Orthogonal;
import org.esa.nest.math.transforms.wavelets.Wavelet;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal11;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal13;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal15;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal22;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal24;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal26;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal28;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal31;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal33;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal35;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal37;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal39;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal44;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal55;
import org.esa.nest.math.transforms.wavelets.biorthogonal.BiOrthogonal68;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet1;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet2;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet3;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet4;
import org.esa.nest.math.transforms.wavelets.coiflet.Coiflet5;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies10;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies11;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies12;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies13;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies14;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies15;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies16;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies17;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies18;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies19;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies2;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies20;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies3;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies4;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies5;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies6;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies7;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies8;
import org.esa.nest.math.transforms.wavelets.daubechies.Daubechies9;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre1;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre2;
import org.esa.nest.math.transforms.wavelets.legendre.Legendre3;
import org.esa.nest.math.transforms.wavelets.other.DiscreteMayer;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet10;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet11;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet12;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet13;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet14;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet15;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet16;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet17;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet18;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet19;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet2;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet20;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet3;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet4;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet5;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet6;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet7;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet8;
import org.esa.nest.math.transforms.wavelets.symlets.Symlet9;
import org.junit.Assert;
import org.junit.Test;

public class TransformTest {
    @Test
    public void testRounding() {
        System.out.println("");
        System.out.println("testRounding");
        System.out.println("");
        int arrTimeLength = 1024;
        double[] arrTime = new double[arrTimeLength];
        for (int i = 0; i < arrTime.length; ++i) {
            arrTime[i] = 1.0;
        }
        double delta = 1.0E-10;
        try {
            System.out.println("testRounding Haar1 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Haar1(), delta);
            System.out.println("");
            System.out.println("testRounding Haar1Orthogonal - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Haar1Orthogonal(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies2 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies2(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies3 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies3(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies4 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies4(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies5 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies5(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies6 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies6(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies7 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies7(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies8 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies8(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies9 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies9(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies10 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies10(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies11 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies11(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies12 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies12(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies13 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies13(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies14 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies14(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies15 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies15(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies16 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies16(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies17 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies17(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies18 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies18(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies19 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies19(), delta);
            System.out.println("");
            System.out.println("testRounding Daubechies20 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Daubechies20(), delta);
            System.out.println("");
            System.out.println("testRounding Legendre1 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Legendre1(), delta);
            System.out.println("");
            System.out.println("testRounding Legendre2 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Legendre2(), delta);
            System.out.println("");
            System.out.println("testRounding Legendre3 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Legendre3(), delta);
            System.out.println("");
            System.out.println("testRounding Coiflet1 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Coiflet1(), delta);
            System.out.println("");
            System.out.println("testRounding Coiflet2 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Coiflet2(), delta);
            System.out.println("");
            System.out.println("testRounding Coiflet3 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Coiflet3(), delta);
            System.out.println("");
            System.out.println("testRounding Coiflet4 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Coiflet4(), delta);
            System.out.println("");
            System.out.println("testRounding Coiflet5 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Coiflet5(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet2 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet2(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet3 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet3(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet4 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet4(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet5 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet5(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet6 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet6(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet7 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet7(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet8 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet8(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet9 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet9(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet10 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet10(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet11 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet11(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet12 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet12(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet13 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet13(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet14 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet14(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet15 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet15(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet16 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet16(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet17 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet17(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet18 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet18(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet19 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet19(), delta);
            System.out.println("");
            System.out.println("testRounding Symlet20 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new Symlet20(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal11 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal11(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal13 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal13(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal15 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal15(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal22 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal22(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal24 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal24(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal26 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal26(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal28 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal28(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal31 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal31(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal33 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal33(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal35 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal35(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal37 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal37(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal39 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal39(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal44 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal44(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal55 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal55(), delta);
            System.out.println("");
            System.out.println("testRounding BiOrthogonal68 - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new BiOrthogonal68(), delta);
            System.out.println("");
            System.out.println("testRounding DiscreteMayer - 1000 transforms => rounding error: " + delta);
            this.testFastWaveletTransformRounding(arrTime, new DiscreteMayer(), 0.01);
            System.out.println("");
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    public void testFastWaveletTransformRounding(double[] arr, Wavelet wavelet, double delta) throws JWaveException {
        long noOfSteps = 1000L;
        double[] arrTime = arr;
        this.showTime(arrTime);
        double[] arrTimeRound = new double[arrTime.length];
        for (int c = 0; c < arrTime.length; ++c) {
            arrTimeRound[c] = arrTime[c];
        }
        Transform t = new Transform(new FastWaveletTransform(wavelet));
        System.out.println("");
        System.out.println("");
        System.out.print("Performing: " + noOfSteps + " forward and reverse transforms ...");
        for (long s = 0L; s < noOfSteps; ++s) {
            arrTimeRound = t.reverse(t.forward(arrTimeRound));
        }
        System.out.println("");
        System.out.println("");
        this.assertArray(arrTime, arrTimeRound, delta);
        System.out.println("Input ...");
        this.showTime(arrTime);
        System.out.println("");
        System.out.println("Result ...");
        this.showTime(arrTimeRound);
        System.out.println("");
        double[] arrTimeErrorAbs = new double[arrTimeRound.length];
        for (int c = 0; c < arrTimeRound.length; ++c) {
            arrTimeErrorAbs[c] = Math.abs(arrTimeRound[c] - arrTime[c]);
        }
        System.out.println("Absolute error");
        this.showTime(arrTimeErrorAbs);
        System.out.println("");
        double[] arrTimeErrorRel = new double[arrTimeRound.length];
        for (int c = 0; c < arrTimeRound.length; ++c) {
            arrTimeErrorRel[c] = Math.abs((arrTimeRound[c] - arrTime[c]) * 100.0 / arrTime[c]);
        }
        System.out.println("Relative error [%] ...");
        this.showTime(arrTimeErrorRel);
        System.out.println("");
    }

    @Test
    public void testForwardDoubleArray() {
        double[] expected;
        double[] arrHilb;
        Transform t;
        double[] arrTime;
        double delta;
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 1-D method using Haar1 Wavelet");
        try {
            delta = 1.0E-12;
            arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
            this.showTime(arrTime);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrHilb = t.forward(arrTime);
            this.showHilb(arrHilb);
            expected = new double[]{2.0, 0.0, 0.0, 0.0};
            this.assertArray(expected, arrHilb, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 1-D method using Haar1 Wavelet and a long array");
        try {
            delta = 1.0E-12;
            arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            this.showTime(arrTime);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrHilb = t.forward(arrTime);
            this.showHilb(arrHilb);
            expected = new double[]{8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.assertArray(expected, arrHilb, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 1-D method using Haar1 Wavelet and a random array");
        try {
            double delta2 = 1.0E-12;
            arrTime = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
            this.showTime(arrTime);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrHilb = t.forward(arrTime);
            this.showHilb(arrHilb);
            expected = new double[]{9.333809511662427, -1.2727922061357857, -2.1999999999999997, 2.2, -0.7778174593052021, -0.7778174593052025, 0.7778174593052025, 0.7778174593052023};
            this.assertArray(expected, arrHilb, delta2);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testReverseDoubleArray() {
        double[] expected;
        double[] arrTime;
        Transform t;
        double[] arrHilb;
        double delta;
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
        try {
            delta = 1.0E-12;
            arrHilb = new double[]{2.0, 0.0, 0.0, 0.0};
            this.showHilb(arrHilb);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrTime = t.reverse(arrHilb);
            this.showTime(arrTime);
            expected = new double[]{1.0, 1.0, 1.0, 1.0};
            this.assertArray(expected, arrTime, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
        try {
            delta = 1.0E-12;
            arrHilb = new double[]{8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.showHilb(arrHilb);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrTime = t.reverse(arrHilb);
            this.showTime(arrTime);
            expected = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
            this.assertArray(expected, arrTime, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet and a random array");
        try {
            double delta2 = 1.0E-12;
            arrHilb = new double[]{9.333809511662427, -1.2727922061357857, -2.1999999999999997, 2.2, -0.7778174593052021, -0.7778174593052025, 0.7778174593052025, 0.7778174593052023};
            this.showHilb(arrHilb);
            t = new Transform(new FastWaveletTransform(new Haar1()));
            arrTime = t.reverse(arrHilb);
            this.showTime(arrTime);
            expected = new double[]{1.2, 2.3, 3.4, 4.5, 5.4, 4.3, 3.2, 2.1};
            this.assertArray(expected, arrTime, delta2);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testDecomposeDoubleArray() {
        try {
            double delta = 1.0E-8;
            int noOfWavelets = 20;
            Wavelet[] arrOfWaveletObjects = new Wavelet[noOfWavelets];
            arrOfWaveletObjects[0] = new Haar1();
            arrOfWaveletObjects[1] = new Daubechies4();
            arrOfWaveletObjects[2] = new Daubechies6();
            arrOfWaveletObjects[3] = new Daubechies8();
            arrOfWaveletObjects[4] = new Daubechies10();
            arrOfWaveletObjects[5] = new Daubechies12();
            arrOfWaveletObjects[6] = new Daubechies14();
            arrOfWaveletObjects[7] = new Daubechies16();
            arrOfWaveletObjects[8] = new Daubechies18();
            arrOfWaveletObjects[9] = new Daubechies20();
            arrOfWaveletObjects[10] = new Coiflet3();
            arrOfWaveletObjects[11] = new Coiflet5();
            arrOfWaveletObjects[12] = new Symlet4();
            arrOfWaveletObjects[13] = new Symlet8();
            arrOfWaveletObjects[14] = new Symlet12();
            arrOfWaveletObjects[15] = new Symlet16();
            arrOfWaveletObjects[16] = new Symlet20();
            arrOfWaveletObjects[17] = new BiOrthogonal13();
            arrOfWaveletObjects[18] = new BiOrthogonal39();
            arrOfWaveletObjects[19] = new BiOrthogonal68();
            for (int w = 0; w < noOfWavelets; ++w) {
                Wavelet wavelet = arrOfWaveletObjects[w];
                System.out.println("");
                System.out.println("Testing the Fast Wavelet Transform decompse 1-D method using " + wavelet.getName());
                double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0};
                this.showTime(arrTime);
                Transform t = new Transform(new FastWaveletTransform(wavelet));
                double[][] matDeComp = t.decompose(arrTime);
                this.showHilb(matDeComp);
                double sqrt2 = Math.sqrt(2.0);
                double[][] expected = new double[][]{{1.0, 1.0, 1.0, 1.0}, {sqrt2, sqrt2, 0.0, 0.0}, {2.0, 0.0, 0.0, 0.0}};
                this.assertMatrix(expected, matDeComp, delta);
                double[] arrTimeReComp = t.recompose(matDeComp);
                this.showTime(arrTimeReComp);
                this.assertArray(arrTime, arrTimeReComp, delta);
                System.out.println("");
                System.out.println("Testing the Fast Wavelet Transform forward 1-D method using " + wavelet.getName() + " and a long array");
                double[] arrTime64 = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
                this.showTime(arrTime);
                double[][] matDeComp64 = t.decompose(arrTime64);
                this.showHilb(matDeComp64);
                double d1sqrt2 = 1.0 * sqrt2;
                double d2sqrt2 = 2.0 * d1sqrt2;
                double d4sqrt2 = 2.0 * d2sqrt2;
                double[][] expected64 = new double[][]{{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, {d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, d1sqrt2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d2sqrt2, d2sqrt2, d2sqrt2, d2sqrt2, d2sqrt2, d2sqrt2, d2sqrt2, d2sqrt2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {4.0, 4.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {d4sqrt2, d4sqrt2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
                this.assertMatrix(expected64, matDeComp64, delta);
                double[] arrTimeReComp64 = t.recompose(matDeComp64);
                this.showTime(arrTimeReComp64);
                this.assertArray(arrTime64, arrTimeReComp64, delta);
            }
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testForwardComplexArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 1-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            int arrTimeLength = 8;
            Complex[] arrTime = new Complex[arrTimeLength];
            for (int i = 0; i < arrTimeLength; ++i) {
                arrTime[i] = new Complex(1.0, 1.0);
            }
            this.showTime(arrTime);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            Complex[] arrHilb = t.forward(arrTime);
            this.showHilb(arrHilb);
            Complex[] expected = new Complex[arrTimeLength];
            for (int i = 0; i < arrTimeLength; ++i) {
                expected[i] = new Complex(0.0, 0.0);
            }
            expected[0].setReal(4.0);
            this.assertArray(expected, arrHilb, delta);
        }
        catch (JWaveFailure e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testReverseComplexArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            int arrTimeLength = 8;
            Complex[] arrHilb = new Complex[arrTimeLength];
            for (int i = 0; i < arrTimeLength; ++i) {
                arrHilb[i] = new Complex(0.0, 0.0);
            }
            arrHilb[0].setReal(4.0);
            this.showHilb(arrHilb);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            Complex[] arrTime = t.reverse(arrHilb);
            this.showTime(arrTime);
            Complex[] expected = new Complex[arrTimeLength];
            for (int i = 0; i < arrTimeLength; ++i) {
                expected[i] = new Complex(1.0, 1.0);
            }
            this.assertArray(expected, arrTime, delta);
        }
        catch (JWaveFailure e) {
            e.showMessage();
            e.printStackTrace();
        }
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 1-D method using Haar1 Wavelet");
    }

    @Test
    public void testForwardDoubleArrayArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 2-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            double[][] matrixTime = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
            this.showTime(matrixTime);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            double[][] matrixHilb = t.forward(matrixTime);
            this.showHilb(matrixHilb);
            double[][] expected = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
            this.assertMatrix(expected, matrixHilb, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testReverseDoubleArrayArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 2-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            double[][] matrixHilb = new double[][]{{4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
            this.showHilb(matrixHilb);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            double[][] matrixTime = t.reverse(matrixHilb);
            this.showTime(matrixTime);
            double[][] expected = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}};
            this.assertMatrix(expected, matrixTime, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testForwardDoubleArrayArrayArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform forward 3-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            double[][][] spaceTime = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
            this.showTime(spaceTime);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            double[][][] spaceHilb = t.forward(spaceTime);
            this.showHilb(spaceHilb);
            double[][][] expected = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
            this.assertSpace(expected, spaceHilb, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    @Test
    public void testReverseDoubleArrayArrayArray() {
        System.out.println("");
        System.out.println("Testing the Fast Wavelet Transform reverse 3-D method using Haar1 Wavelet");
        try {
            double delta = 1.0E-12;
            double[][][] spaceHilb = new double[][][]{new double[][]{{8.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}, new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}}};
            this.showHilb(spaceHilb);
            Transform t = new Transform(new FastWaveletTransform(new Haar1()));
            double[][][] spaceTime = t.reverse(spaceHilb);
            this.showTime(spaceTime);
            double[][][] expected = new double[][][]{new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}, new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}}};
            this.assertSpace(expected, spaceTime, delta);
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
    }

    public void assertArray(Complex[] expected, Complex[] actual, double delta) {
        int expectedLength = expected.length;
        int actualLength = actual.length;
        Assert.assertEquals((long)expectedLength, (long)actualLength);
        for (int c = 0; c < expectedLength; ++c) {
            double expectedReal = expected[c].getReal();
            double expectedImag = expected[c].getImag();
            double actualReal = actual[c].getReal();
            double actualImag = actual[c].getImag();
            Assert.assertEquals((double)expectedReal, (double)actualReal, (double)delta);
            Assert.assertEquals((double)expectedImag, (double)actualImag, (double)delta);
        }
    }

    protected void assertArray(double[] expected, double[] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)delta);
        }
    }

    protected void assertMatrix(double[][] expected, double[][] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            for (int j = 0; j < expected[i].length; ++j) {
                Assert.assertEquals((double)expected[i][j], (double)actual[i][j], (double)delta);
            }
        }
    }

    protected void assertSpace(double[][][] expected, double[][][] actual, double delta) {
        for (int i = 0; i < expected.length; ++i) {
            for (int j = 0; j < expected[i].length; ++j) {
                for (int k = 0; k < expected[i][j].length; ++k) {
                    Assert.assertEquals((double)expected[i][j][k], (double)actual[i][j][k], (double)delta);
                }
            }
        }
    }

    protected void showTime(double[] arrTime) {
        System.out.print("time domain: \t\t");
        for (int c = 0; c < arrTime.length; ++c) {
            System.out.print(arrTime[c] + " ");
        }
        System.out.println("");
    }

    protected void showFreq(double[] arrFreq) {
        System.out.print("frequency domain: \t");
        for (int c = 0; c < arrFreq.length; ++c) {
            System.out.print(arrFreq[c] + " ");
        }
        System.out.println("");
    }

    protected void showHilb(double[] arrHilb) {
        System.out.print("Hilbert domain: \t");
        for (int c = 0; c < arrHilb.length; ++c) {
            System.out.print(arrHilb[c] + " ");
        }
        System.out.println("");
    }

    protected void showTime(Complex[] arrTime) {
        System.out.print("time domain: \t\t");
        for (int c = 0; c < arrTime.length; ++c) {
            System.out.print(arrTime[c].toString() + " ");
        }
        System.out.println("");
    }

    protected void showHilb(Complex[] arrFreq) {
        System.out.print("frequency domain: \t");
        for (int c = 0; c < arrFreq.length; ++c) {
            System.out.print(arrFreq[c].toString() + " ");
        }
        System.out.println("");
    }

    protected void showTime(double[][] matrixTime) {
        System.out.println("time domain: \t");
        for (int i = 0; i < matrixTime.length; ++i) {
            for (int j = 0; j < matrixTime[i].length; ++j) {
                System.out.print(matrixTime[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][] matrixFreq) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < matrixFreq.length; ++i) {
            for (int j = 0; j < matrixFreq[i].length; ++j) {
                System.out.print(matrixFreq[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][] matrixHilb) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < matrixHilb.length; ++i) {
            for (int j = 0; j < matrixHilb[i].length; ++j) {
                System.out.print(matrixHilb[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showTime(double[][][] spaceTime) {
        System.out.println("time domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showFreq(double[][][] spaceTime) {
        System.out.println("frequency domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    protected void showHilb(double[][][] spaceTime) {
        System.out.println("Hilbert domain: \t");
        for (int i = 0; i < spaceTime.length; ++i) {
            for (int j = 0; j < spaceTime[i].length; ++j) {
                for (int k = 0; k < spaceTime[i][j].length; ++k) {
                    System.out.print(spaceTime[i][j][k] + " ");
                }
                System.out.println("");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

