/*
 * Decompiled with CFR 0.152.
 */
package org.esa.nest.math.compressions;

import org.esa.nest.math.compressions.Compressor;
import org.esa.nest.math.exceptions.JWaveException;

public class CompressorMagnitude
extends Compressor {
    protected double _magnitude = 0.0;

    public CompressorMagnitude() {
        this._threshold = 1.0;
    }

    public CompressorMagnitude(double threshold) throws JWaveException {
        super(threshold);
    }

    @Override
    protected double[] compress(double[] arrHilb) {
        int i;
        this._magnitude = 0.0;
        int arrHilbSize = arrHilb.length;
        double[] arrComp = new double[arrHilbSize];
        for (i = 0; i < arrHilbSize; ++i) {
            this._magnitude += Math.abs(arrHilb[i]);
        }
        for (i = 0; i < arrHilbSize; ++i) {
            arrComp[i] = Math.abs(arrHilb[i]) >= this._magnitude * this._threshold ? arrHilb[i] : 0.0;
        }
        return arrComp;
    }

    @Override
    protected double[][] compress(double[][] matHilb) {
        int j;
        int i;
        this._magnitude = 0.0;
        int matHilbNoOfRows = matHilb.length;
        int matHilbNoOfCols = matHilb[0].length;
        double[][] matComp = new double[matHilbNoOfRows][matHilbNoOfCols];
        for (i = 0; i < matHilbNoOfRows; ++i) {
            for (j = 0; j < matHilbNoOfCols; ++j) {
                this._magnitude += Math.abs(matHilb[i][j]);
            }
        }
        for (i = 0; i < matHilbNoOfRows; ++i) {
            for (j = 0; j < matHilbNoOfCols; ++j) {
                matComp[i][j] = Math.abs(matHilb[i][j]) >= this._magnitude * this._threshold ? matHilb[i][j] : 0.0;
            }
        }
        return matComp;
    }

    @Override
    protected double[][][] compress(double[][][] spcHilb) {
        int k;
        int j;
        int i;
        this._magnitude = 0.0;
        int matHilbNoOfRows = spcHilb.length;
        int matHilbNoOfCols = spcHilb[0].length;
        int matHilbNoOfLvls = spcHilb[0][0].length;
        double[][][] spcComp = new double[matHilbNoOfRows][matHilbNoOfCols][matHilbNoOfLvls];
        for (i = 0; i < matHilbNoOfRows; ++i) {
            for (j = 0; j < matHilbNoOfCols; ++j) {
                for (k = 0; k < matHilbNoOfLvls; ++k) {
                    this._magnitude += Math.abs(spcHilb[i][j][k]);
                }
            }
        }
        for (i = 0; i < matHilbNoOfRows; ++i) {
            for (j = 0; j < matHilbNoOfCols; ++j) {
                for (k = 0; k < matHilbNoOfLvls; ++k) {
                    spcComp[i][j][k] = Math.abs(spcHilb[i][j][k]) >= this._magnitude * this._threshold ? spcHilb[i][j][k] : 0.0;
                }
            }
        }
        return spcComp;
    }
}

